/*
 * Decompiled with CFR 0.152.
 */
package com.sun.portal.portletcontainer.common;

import com.sun.portal.container.ContainerLogger;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Enumeration;
import java.util.Map;
import java.util.Properties;
import java.util.logging.Level;
import java.util.logging.Logger;

public class PortletDeployConfigReader {
    private static Logger logger = ContainerLogger.getLogger(PortletDeployConfigReader.class, (String)"PCCLogMessages");
    public static final String VALIDATE_PROPERTY = "portletXML.validate";
    public static final String VENDOR_PORTLET_XML_PREFIX = "vendorPortletXML";
    public static final String NAME_SUFFIX = "name";
    public static final String IMPL_SUFFIX = "impl";
    public static final String VALIDATE_SUFFIX = "validate";
    private static final String PORTLET_DEPLOY_CONFIG_FILE = "PortletDeployConfig.properties";
    private static final String PORTLET_DEPLOY_CONFIG_DEFAULT_FILE = "PortletDeployConfigDefault.properties";
    private static Properties configProps = null;

    public static Properties getPortletDeployDefaultConfigProperties() {
        PortletDeployConfigReader.init();
        return new Properties(configProps);
    }

    public static Properties getPortletDeployConfigProperties(Properties deployConfigCustomProperties) {
        Properties customProperties = PortletDeployConfigReader.getPortletDeployDefaultConfigProperties();
        if (deployConfigCustomProperties != null && deployConfigCustomProperties.size() > 0) {
            for (Map.Entry<Object, Object> entry : deployConfigCustomProperties.entrySet()) {
                customProperties.put(entry.getKey(), entry.getValue());
            }
        }
        return customProperties;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Properties getPortletDeployConfigProperties(String deployConfigFileLocation) {
        Properties customProperties = PortletDeployConfigReader.getPortletDeployDefaultConfigProperties();
        if (deployConfigFileLocation != null) {
            InputStream configPropsStream = null;
            try {
                configPropsStream = new FileInputStream(deployConfigFileLocation + File.separator + PORTLET_DEPLOY_CONFIG_FILE);
                customProperties.load(configPropsStream);
            }
            catch (Exception e) {
                logger.log(Level.WARNING, "PSPL_PCCCSPPCCD0022", e);
            }
            finally {
                if (configPropsStream != null) {
                    try {
                        configPropsStream.close();
                    }
                    catch (IOException iOException) {}
                }
            }
        }
        return customProperties;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static synchronized void loadPortletDeployConfigDefaultFile() {
        if (configProps != null) {
            return;
        }
        InputStream configPropsStream = null;
        configProps = new Properties();
        try {
            configPropsStream = Thread.currentThread().getContextClassLoader().getResourceAsStream(PORTLET_DEPLOY_CONFIG_DEFAULT_FILE);
            if (configPropsStream != null) {
                configProps.load(configPropsStream);
            }
        }
        catch (IOException ex) {
            ex.printStackTrace();
        }
        finally {
            if (configPropsStream != null) {
                try {
                    configPropsStream.close();
                }
                catch (IOException iOException) {}
            }
        }
    }

    private static void init() {
        if (configProps == null) {
            PortletDeployConfigReader.loadPortletDeployConfigDefaultFile();
        }
    }

    public static void main(String[] args) {
        Properties customP = new Properties();
        customP.setProperty("test", "test1234");
        Properties p = PortletDeployConfigReader.getPortletDeployConfigProperties(customP);
        Enumeration<?> proName = p.propertyNames();
        while (proName.hasMoreElements()) {
            Object key = proName.nextElement();
            System.out.println(key + "::" + p.getProperty(key.toString()));
        }
        System.out.println(p);
    }
}

