/*
 * Decompiled with CFR 0.152.
 */
package org.silverpeas.core.sharing.model;

import java.util.Collection;
import org.silverpeas.core.ResourceReference;
import org.silverpeas.core.contribution.attachment.model.SimpleDocument;
import org.silverpeas.core.contribution.publication.model.Location;
import org.silverpeas.core.contribution.publication.model.PublicationPK;
import org.silverpeas.core.contribution.publication.service.PublicationService;
import org.silverpeas.core.node.model.NodeDetail;
import org.silverpeas.core.node.model.NodePK;
import org.silverpeas.core.node.service.NodeService;
import org.silverpeas.core.sharing.model.Ticket;
import org.silverpeas.core.sharing.security.AbstractShareableAccessControl;
import org.silverpeas.core.sharing.security.AccessControlContext;

public class NodeAccessControl
extends AbstractShareableAccessControl {
    NodeAccessControl(Ticket ticket) {
        super(ticket);
    }

    @Override
    public boolean isReadable(AccessControlContext context) {
        NodePK nodePk = new NodePK(String.valueOf(this.getSharingTicket().getSharedObjectId()), this.getSharingTicket().getComponentId());
        Collection<NodePK> authorizedNodes = this.getNodeDescendants(nodePk);
        authorizedNodes.add(nodePk);
        if (context.isAboutDocument()) {
            SimpleDocument attachment = context.getDocument();
            return this.isPublicationReadable(new ResourceReference(attachment.getForeignId(), attachment.getInstanceId()), nodePk.getInstanceId(), authorizedNodes);
        }
        NodeDetail node = context.getNode();
        return authorizedNodes.contains(node.getNodePK());
    }

    protected Collection<NodePK> getPublicationFathers(ResourceReference pk) {
        return this.getPublicationService().getAllFatherPKInSamePublicationComponentInstance(new PublicationPK(pk.getId(), pk.getInstanceId()));
    }

    protected Collection<Location> getPublicationLocations(ResourceReference pk) {
        return this.getPublicationService().getAllLocations(new PublicationPK(pk.getId(), pk.getInstanceId()));
    }

    protected Collection<NodePK> getNodeDescendants(NodePK pk) {
        return this.getNodeService().getDescendantPKs(pk);
    }

    private boolean isPublicationReadable(ResourceReference pk, String instanceId, Collection<NodePK> authorizedNodes) {
        if (pk.getInstanceId().equals(instanceId)) {
            Collection<NodePK> fathers = this.getPublicationFathers(pk);
            return authorizedNodes.stream().anyMatch(fathers::contains);
        }
        Collection<Location> locations = this.getPublicationLocations(pk);
        for (Location location : locations) {
            NodePK father = new NodePK(location.getId(), location.getInstanceId());
            if (location.isAlias() || !authorizedNodes.contains(father)) continue;
            return true;
        }
        return false;
    }

    private PublicationService getPublicationService() {
        return PublicationService.get();
    }

    private NodeService getNodeService() {
        return NodeService.get();
    }
}

