/*
 * Decompiled with CFR 0.152.
 */
package org.silverpeas.core.importexport.control;

import com.itextpdf.text.Document;
import com.itextpdf.text.DocumentException;
import com.itextpdf.text.pdf.PdfCopy;
import com.itextpdf.text.pdf.PdfReader;
import com.itextpdf.text.pdf.SimpleBookmark;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.lang.annotation.Annotation;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.StringTokenizer;
import javax.annotation.PostConstruct;
import javax.inject.Inject;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.JAXBException;
import javax.xml.bind.Marshaller;
import javax.xml.bind.Unmarshaller;
import javax.xml.bind.ValidationEventHandler;
import javax.xml.validation.Schema;
import javax.xml.validation.SchemaFactory;
import org.apache.commons.io.IOUtils;
import org.silverpeas.core.admin.component.model.ComponentInst;
import org.silverpeas.core.admin.service.OrganizationControllerProvider;
import org.silverpeas.core.admin.user.model.UserDetail;
import org.silverpeas.core.annotation.Service;
import org.silverpeas.core.contribution.publication.model.PublicationDetail;
import org.silverpeas.core.importexport.admin.AdminImportExport;
import org.silverpeas.core.importexport.attachment.AttachmentDetail;
import org.silverpeas.core.importexport.control.AbstractExportProcess;
import org.silverpeas.core.importexport.control.GEDImportExport;
import org.silverpeas.core.importexport.control.ImportExportFactory;
import org.silverpeas.core.importexport.control.ImportSettings;
import org.silverpeas.core.importexport.control.NodeTreesTypeManager;
import org.silverpeas.core.importexport.control.PublicationImportExport;
import org.silverpeas.core.importexport.control.PublicationsTypeManager;
import org.silverpeas.core.importexport.control.RepositoriesTypeManager;
import org.silverpeas.core.importexport.coordinates.CoordinateImportExport;
import org.silverpeas.core.importexport.coordinates.CoordinatesPositionsType;
import org.silverpeas.core.importexport.model.ImportExportErrorHandler;
import org.silverpeas.core.importexport.model.ImportExportException;
import org.silverpeas.core.importexport.model.PublicationType;
import org.silverpeas.core.importexport.model.SilverPeasExchangeType;
import org.silverpeas.core.importexport.report.ExportPDFReport;
import org.silverpeas.core.importexport.report.ExportReport;
import org.silverpeas.core.importexport.report.HtmlExportGenerator;
import org.silverpeas.core.importexport.report.HtmlExportPublicationGenerator;
import org.silverpeas.core.importexport.report.ImportReport;
import org.silverpeas.core.importexport.report.ImportReportManager;
import org.silverpeas.core.importexport.report.UnitReport;
import org.silverpeas.core.node.coordinates.model.Coordinate;
import org.silverpeas.core.node.coordinates.model.CoordinatePoint;
import org.silverpeas.core.node.importexport.NodeImportExport;
import org.silverpeas.core.node.importexport.NodePositionType;
import org.silverpeas.core.node.importexport.NodeTreeType;
import org.silverpeas.core.node.model.NodeDetail;
import org.silverpeas.core.node.model.NodePK;
import org.silverpeas.core.node.model.NodeRuntimeException;
import org.silverpeas.core.pdc.pdc.importexport.PdcImportExport;
import org.silverpeas.core.pdc.pdc.model.ClassifyPosition;
import org.silverpeas.core.pdc.pdc.model.PdcException;
import org.silverpeas.core.util.Charsets;
import org.silverpeas.core.util.CollectionUtil;
import org.silverpeas.core.util.MultiSilverpeasBundle;
import org.silverpeas.core.util.ServiceProvider;
import org.silverpeas.core.util.UtilException;
import org.silverpeas.core.util.WAAttributeValuePair;
import org.silverpeas.core.util.file.FileFolderManager;
import org.silverpeas.core.util.file.FileRepositoryManager;
import org.silverpeas.core.util.file.FileServerUtils;
import org.silverpeas.kernel.bundle.LocalizationBundle;
import org.silverpeas.kernel.bundle.ResourceLocator;
import org.silverpeas.kernel.bundle.SettingBundle;
import org.silverpeas.kernel.logging.SilverLogger;
import org.silverpeas.kernel.util.StringUtil;
import org.xml.sax.SAXException;

@Service
public class ImportExport
extends AbstractExportProcess {
    private static final SettingBundle settings = ResourceLocator.getSettingBundle((String)"org.silverpeas.importExport.settings.mapping");
    public static final String IFRAME_PUBLICATION = "publications";
    public static final String IFRAME_INDEX_PUBLICATIONS = "indexPublications";
    public static final int EXPORT_FULL = 0;
    public static final int EXPORT_FILESONLY = 1;
    public static final int EXPORT_PUBLICATIONSONLY = 2;
    @Inject
    private CoordinateImportExport coordinateImportExport;
    @Inject
    private NodeImportExport nodeImportExport;
    @Inject
    private PdcImportExport pdcImportExport;
    @Inject
    private RepositoriesTypeManager repositoriesTypeManager;
    private JAXBContext jaxbContext = null;

    protected ImportExport() {
    }

    @PostConstruct
    private void setup() {
        try {
            this.jaxbContext = JAXBContext.newInstance((Class[])new Class[]{SilverPeasExchangeType.class});
        }
        catch (JAXBException e) {
            SilverLogger.getLogger((Object)this).error("Cannot initialize jaxbContext", (Throwable)e);
        }
    }

    void saveToSilverpeasExchangeFile(SilverPeasExchangeType silverPeasExchangeType, String xmlToExportPath) throws ImportExportException {
        try {
            String xsdPublicId = settings.getString("xsdPublicId");
            String xsdSystemId = settings.getString("xsdDefaultSystemId");
            Marshaller mar = this.jaxbContext.createMarshaller();
            mar.setProperty("jaxb.encoding", (Object)"UTF-8");
            mar.setProperty("jaxb.formatted.output", (Object)true);
            mar.setProperty("jaxb.schemaLocation", (Object)(xsdPublicId + " " + xsdSystemId));
            mar.marshal((Object)silverPeasExchangeType, new File(xmlToExportPath));
        }
        catch (JAXBException me) {
            throw new ImportExportException("ImportExport.loadSilverpeasExchange", "importExport.EX_UNMARSHALLING_FAILED", "XML Filename : ", (Exception)((Object)me));
        }
    }

    private SilverPeasExchangeType loadSilverpeasExchange(String xmlFileName) throws ImportExportException {
        try {
            File xmlInputSource = new File(xmlFileName);
            String xsdSystemId = settings.getString("xsdDefaultSystemId");
            SchemaFactory sf = SchemaFactory.newInstance("http://www.w3.org/2001/XMLSchema");
            Schema schema = sf.newSchema(new URL(xsdSystemId));
            Unmarshaller unmarshaller = this.jaxbContext.createUnmarshaller();
            unmarshaller.setSchema(schema);
            unmarshaller.setEventHandler((ValidationEventHandler)new ImportExportErrorHandler());
            SilverPeasExchangeType silverpeasExchange = (SilverPeasExchangeType)unmarshaller.unmarshal(xmlInputSource);
            return silverpeasExchange;
        }
        catch (JAXBException me) {
            throw new ImportExportException("ImportExport.loadSilverpeasExchange", "importExport.EX_UNMARSHALLING_FAILED", "XML Filename " + xmlFileName + ": " + me.getLocalizedMessage(), (Exception)((Object)me));
        }
        catch (MalformedURLException ue) {
            throw new ImportExportException("ImportExport.loadSilverpeasExchange", "importExport.EX_UNMARSHALLING_FAILED", "XML Filename " + xmlFileName + ": " + ue.getLocalizedMessage(), ue);
        }
        catch (SAXException ve) {
            throw new ImportExportException("ImportExport.loadSilverpeasExchange", "importExport.EX_PARSING_FAILED", "XML Filename " + xmlFileName + ": " + ve.getLocalizedMessage(), ve);
        }
    }

    public ImportReport processImport(UserDetail userDetail, String xmlFileName) throws ImportExportException {
        Object typeMgr;
        SilverPeasExchangeType silverExType;
        ImportReportManager reportManager = new ImportReportManager();
        if (!StringUtil.isDefined((String)xmlFileName)) {
            UnitReport unitReport = new UnitReport("No XML file specified");
            unitReport.setError(0);
            unitReport.setStatus(3);
            reportManager.addUnitReport(unitReport, "");
        }
        if ((silverExType = this.loadSilverpeasExchange(xmlFileName)).getNodeTreesType() != null) {
            typeMgr = new NodeTreesTypeManager();
            ((NodeTreesTypeManager)typeMgr).processImport(userDetail, silverExType.getNodeTreesType(), silverExType.getTargetComponentId(), reportManager);
        }
        if (silverExType.getPublicationsType() != null) {
            typeMgr = this.getPublicationsTypeManager();
            ImportSettings importSettings = new ImportSettings(null, userDetail, silverExType.getTargetComponentId(), null, false, silverExType.isPOIUsed(), 0);
            ((PublicationsTypeManager)typeMgr).processImport(silverExType.getPublicationsType(), importSettings, reportManager);
        }
        if (silverExType.getRepositoriesType() != null) {
            ImportSettings importSettings = new ImportSettings(null, userDetail, silverExType.getTargetComponentId(), null, false, silverExType.isPOIUsed(), 0);
            this.repositoriesTypeManager.processImport(silverExType.getRepositoriesType(), importSettings, reportManager);
        }
        reportManager.reportImportEnd();
        return reportManager.getImportReport();
    }

    public ExportReport processExport(UserDetail userDetail, String language, List<WAAttributeValuePair> listItemsToExport, NodePK rootPK, int mode, boolean useNameForFolders) throws ImportExportException {
        ExportReport report = null;
        switch (mode) {
            case 0: {
                report = this.processExport(userDetail, language, listItemsToExport, rootPK, useNameForFolders);
                break;
            }
            case 1: {
                report = this.processExportOfFilesOnly(userDetail, listItemsToExport, rootPK, useNameForFolders);
                break;
            }
            default: {
                report = this.processExportOfPublicationsOnly(userDetail, listItemsToExport, rootPK, useNameForFolders);
            }
        }
        return report;
    }

    private ExportReport processExport(UserDetail userDetail, String language, List<WAAttributeValuePair> listItemsToExport, NodePK rootPK, boolean useNameForFolders) throws ImportExportException {
        LocalizationBundle messages = ResourceLocator.getLocalizationBundle((String)"org.silverpeas.importExport.multilang.importExportBundle", (String)language);
        PublicationsTypeManager pubTypMgr = this.getPublicationsTypeManager();
        AdminImportExport adminIE = new AdminImportExport();
        SilverPeasExchangeType silverPeasExch = new SilverPeasExchangeType();
        ExportReport exportReport = new ExportReport();
        try {
            List<PublicationType> publicationsType;
            exportReport.setDateDebut(new Date());
            String thisExportDir = this.generateExportDirName(userDetail, "export");
            String tempDir = FileRepositoryManager.getTemporaryPath();
            File fileExportDir = new File(tempDir + thisExportDir);
            if (!fileExportDir.exists()) {
                try {
                    FileFolderManager.createFolder((File)fileExportDir);
                }
                catch (UtilException ex) {
                    throw new ImportExportException("ImportExport", "importExport.EX_CANT_CREATE_FOLDER", (Exception)((Object)ex));
                }
            }
            if ((publicationsType = pubTypMgr.processExport(exportReport, userDetail, listItemsToExport, fileExportDir.getPath(), useNameForFolders, true, rootPK)).isEmpty()) {
                exportReport = new ExportReport();
                exportReport.setDateDebut(new Date());
                try {
                    FileFolderManager.deleteFolder((String)fileExportDir.getPath());
                }
                catch (Exception ex) {
                    throw new ImportExportException("ImportExport", "importExport.EX_CANT_DELETE_FOLDER", ex);
                }
                thisExportDir = this.generateExportDirName(userDetail, "export");
                tempDir = FileRepositoryManager.getTemporaryPath();
                fileExportDir = new File(tempDir + thisExportDir);
                publicationsType = pubTypMgr.processExport(exportReport, userDetail, listItemsToExport, fileExportDir.getPath(), useNameForFolders, true, rootPK);
            }
            silverPeasExch.setPublicationsType(publicationsType);
            HashSet<String> componentIds = new HashSet<String>();
            ArrayList<ClassifyPosition> listClassifyPosition = new ArrayList<ClassifyPosition>();
            List<PublicationType> listPubType = publicationsType;
            for (PublicationType pubType : listPubType) {
                componentIds.add(pubType.getComponentId());
                List<ClassifyPosition> pdcPos = pubType.getPdcPositionsType();
                if (pdcPos == null) continue;
                listClassifyPosition.addAll(pdcPos);
            }
            ArrayList<String> listComponentId = new ArrayList<String>(componentIds);
            silverPeasExch.setComponentsType(adminIE.getComponents(listComponentId));
            List nodeTreesType = this.nodeImportExport.getTrees(listComponentId);
            silverPeasExch.setNodeTreesType(nodeTreesType);
            if (!listClassifyPosition.isEmpty()) {
                silverPeasExch.setPdcType(this.pdcImportExport.getPdc(listClassifyPosition));
            }
            if (rootPK == null) {
                this.createSummary(exportReport, thisExportDir, tempDir, fileExportDir);
            } else {
                HtmlExportGenerator htmlGenerator = new HtmlExportGenerator(exportReport, fileExportDir.getName(), messages);
                Map<String, List<String>> topicIds = this.prepareTopicsMap(publicationsType);
                Set<String> keys = topicIds.keySet();
                for (String topicId : keys) {
                    this.createTopicHtmlFile(thisExportDir, tempDir, htmlGenerator, topicIds, topicId);
                }
                this.createEmptySummary(thisExportDir, tempDir, htmlGenerator);
                this.createTreeview(rootPK.getId(), thisExportDir, tempDir, nodeTreesType, htmlGenerator, topicIds);
                this.createExportDirectory(thisExportDir, tempDir);
            }
            try {
                this.saveToSilverpeasExchangeFile(silverPeasExch, fileExportDir.getPath() + File.separatorChar + "importExport.xml");
            }
            catch (ImportExportException iex) {
                SilverLogger.getLogger((Object)this).error(iex.getMessage(), (Throwable)((Object)iex));
            }
            this.createZipFile(fileExportDir, exportReport);
        }
        catch (NodeRuntimeException | PdcException ex) {
            throw new ImportExportException("importExport", "ImportExport.processExport()", (Exception)ex);
        }
        return exportReport;
    }

    private void createSummary(ExportReport exportReport, String thisExportDir, String tempDir, File fileExportDir) throws ImportExportException {
        File fileHTML = new File(tempDir + thisExportDir + File.separator + "index.html");
        HtmlExportGenerator h = new HtmlExportGenerator(exportReport, fileExportDir.getName());
        OutputStreamWriter fileWriter = null;
        try {
            fileHTML.createNewFile();
            fileWriter = new OutputStreamWriter((OutputStream)new FileOutputStream(fileHTML.getPath()), Charsets.UTF_8);
            fileWriter.write(h.toHTML());
        }
        catch (IOException ex) {
            try {
                throw new ImportExportException("ImportExport", "root.EX_CANT_WRITE_FILE", ex);
            }
            catch (Throwable throwable) {
                IOUtils.closeQuietly(fileWriter);
                throw throwable;
            }
        }
        IOUtils.closeQuietly((Writer)fileWriter);
    }

    private void createEmptySummary(String thisExportDir, String tempDir, HtmlExportGenerator htmlGenerator) throws ImportExportException {
        File fileExportDir = new File(tempDir, thisExportDir);
        if (!fileExportDir.exists()) {
            try {
                FileFolderManager.createFolder((File)fileExportDir);
            }
            catch (UtilException ex) {
                throw new ImportExportException("ImportExport", "importExport.EX_CANT_CREATE_FOLDER", (Exception)((Object)ex));
            }
        }
        File fileTopicHTML = new File(fileExportDir, "indexTopicEmpty.html");
        try {
            if (!fileTopicHTML.createNewFile()) {
                SilverLogger.getLogger((Object)this).warn("{0} already exists!", new Object[]{fileTopicHTML.getAbsolutePath()});
            }
            try (OutputStreamWriter fileWriter = new OutputStreamWriter((OutputStream)new FileOutputStream(fileTopicHTML.getPath()), Charsets.UTF_8);){
                fileWriter.write(htmlGenerator.toHTML(fileTopicHTML.getName()));
            }
        }
        catch (IOException ex) {
            throw new ImportExportException("ImportExport", "root.EX_CANT_WRITE_FILE", ex);
        }
    }

    private void createExportDirectory(String thisExportDir, String tempDir) throws ImportExportException {
        try {
            FileFolderManager.createFolder((String)(tempDir + thisExportDir + File.separator + "treeview"));
            Object chemin = settings.getString("mappingDir");
            if (((String)chemin).startsWith("file:")) {
                chemin = ((String)chemin).substring(8);
            }
            chemin = (String)chemin + "treeview";
            Collection files = FileFolderManager.getAllFile((String)chemin);
            for (File file : files) {
                File newFile = new File(tempDir + thisExportDir + File.separator + "treeview" + File.separator + file.getName());
                FileRepositoryManager.copyFile((String)file.getPath(), (String)newFile.getPath());
            }
        }
        catch (Exception e) {
            throw new ImportExportException("ImportExport", "importExport.EX_CANT_CREATE_FOLDER", e);
        }
    }

    private void createTreeview(String rootId, String thisExportDir, String tempDir, List<NodeTreeType> nodeTreesType, HtmlExportGenerator htmlGenerator, Map<String, List<String>> topicIds) throws ImportExportException {
        File fileHTML = new File(tempDir + thisExportDir + File.separator + "index.html");
        OutputStreamWriter fileWriter = null;
        try {
            fileHTML.createNewFile();
            fileWriter = new OutputStreamWriter((OutputStream)new FileOutputStream(fileHTML.getPath()), Charsets.UTF_8);
            Set<String> topics = topicIds.keySet();
            fileWriter.write(htmlGenerator.indexToHTML(fileHTML.getName(), topics, nodeTreesType, rootId));
        }
        catch (IOException ex) {
            try {
                throw new ImportExportException("ImportExport", "root.EX_CANT_WRITE_FILE", ex);
            }
            catch (Throwable throwable) {
                IOUtils.closeQuietly(fileWriter);
                throw throwable;
            }
        }
        IOUtils.closeQuietly((Writer)fileWriter);
    }

    private Map<String, List<String>> prepareTopicsMap(List<PublicationType> listPubType) {
        HashMap<String, List<String>> topicIds = new HashMap<String, List<String>>(listPubType.size());
        for (PublicationType publicationType : listPubType) {
            String pubId = Integer.toString(publicationType.getId());
            List<NodePositionType> listNodePositionType = publicationType.getNodePositionsType();
            for (NodePositionType nodePositionType : listNodePositionType) {
                String topicId = String.valueOf(nodePositionType.getId());
                ArrayList<String> pubIds = topicIds.containsKey(topicId) ? (ArrayList<String>)topicIds.get(topicId) : new ArrayList<String>(listPubType.size());
                pubIds.add(pubId);
                topicIds.put(topicId, pubIds);
            }
        }
        return topicIds;
    }

    private void createTopicHtmlFile(String thisExportDir, String tempDir, HtmlExportGenerator h, Map<String, List<String>> topicIds, String topicId) throws ImportExportException {
        File fileTopicHTML = new File(tempDir + thisExportDir, "indexTopic" + topicId + ".html");
        OutputStreamWriter fileWriter = null;
        try {
            fileTopicHTML.createNewFile();
            fileWriter = new OutputStreamWriter((OutputStream)new FileOutputStream(fileTopicHTML.getPath()), Charsets.UTF_8);
            fileWriter.write(h.toHTML(fileTopicHTML.getName(), (Collection<String>)topicIds.get(topicId)));
        }
        catch (IOException ex) {
            try {
                throw new ImportExportException("ImportExport", "root.EX_CANT_WRITE_FILE", ex);
            }
            catch (Throwable throwable) {
                IOUtils.closeQuietly(fileWriter);
                throw throwable;
            }
        }
        IOUtils.closeQuietly((Writer)fileWriter);
    }

    public ExportPDFReport processExportPDF(UserDetail userDetail, List<WAAttributeValuePair> itemsToExport, NodePK rootPK) throws ImportExportException {
        File pdfFileName;
        ExportPDFReport report;
        block23: {
            report = new ExportPDFReport();
            report.setDateDebut(new Date());
            PublicationsTypeManager pubTypeManager = this.getPublicationsTypeManager();
            String fileExportName = this.generateExportDirName(userDetail, "fusion");
            String tempDir = FileRepositoryManager.getTemporaryPath();
            File fileExportDir = new File(tempDir + fileExportName);
            if (!fileExportDir.exists()) {
                try {
                    FileFolderManager.createFolder((File)fileExportDir);
                }
                catch (UtilException ex) {
                    throw new ImportExportException("ImportExport", "importExport.EX_CANT_CREATE_FOLDER", (Exception)((Object)ex));
                }
            }
            Document document = null;
            PdfCopy writer = null;
            ArrayList<PdfReader> readers = new ArrayList<PdfReader>();
            pdfFileName = new File(tempDir + fileExportName + ".pdf");
            try {
                List<AttachmentDetail> pdfList = pubTypeManager.processPDFExport(report, userDetail, itemsToExport, fileExportDir.getPath(), true, rootPK);
                ArrayList master = new ArrayList();
                if (!pdfList.isEmpty()) {
                    int pageOffset = 0;
                    Iterator<AttachmentDetail> iterator = pdfList.iterator();
                    while (iterator.hasNext()) {
                        AttachmentDetail attDetail = iterator.next();
                        PdfReader reader = this.getPdfReader(fileExportDir, attDetail);
                        if (reader == null) continue;
                        readers.add(reader);
                        reader.consolidateNamedDestinations();
                        int nbPages = reader.getNumberOfPages();
                        List bookmarks = SimpleBookmark.getBookmark((PdfReader)reader);
                        if (writer == null) {
                            document = new Document(reader.getPageSizeWithRotation(1));
                            writer = new PdfCopy(document, (OutputStream)new FileOutputStream(pdfFileName));
                            writer.setMergeFields();
                            document.open();
                        }
                        if (!this.mergeDocument(attDetail, reader, writer)) continue;
                        if (CollectionUtil.isNotEmpty((Collection)bookmarks)) {
                            if (pageOffset != 0) {
                                SimpleBookmark.shiftPageNumbers((List)bookmarks, (int)pageOffset, null);
                            }
                            master.addAll(bookmarks);
                        }
                        pageOffset += nbPages;
                    }
                    if (!master.isEmpty()) {
                        writer.setOutlines(master);
                    }
                    break block23;
                }
                ExportPDFReport pageOffset = null;
                return pageOffset;
            }
            catch (DocumentException | IOException e) {
                throw new ImportExportException("ImportExport", "root.EX_CANT_WRITE_FILE", (Exception)e);
            }
            finally {
                if (writer != null) {
                    writer.flush();
                    writer.close();
                }
                if (document != null) {
                    document.close();
                }
                for (PdfReader reader : readers) {
                    try {
                        reader.close();
                    }
                    catch (Exception e) {
                        SilverLogger.getLogger((Object)this).warn((Throwable)e);
                    }
                }
            }
        }
        report.setPdfFileName(pdfFileName.getName());
        report.setPdfFileSize(pdfFileName.length());
        report.setPdfFilePath(FileServerUtils.getUrlToTempDir((String)pdfFileName.getName()));
        report.setDateFin(new Date());
        return report;
    }

    private PdfReader getPdfReader(File fileExportDir, AttachmentDetail attDetail) {
        try {
            return new PdfReader(fileExportDir.getPath() + File.separatorChar + attDetail.getLogicalName());
        }
        catch (IOException ioe) {
            SilverLogger.getLogger((Object)this).error("Cannot find PDF {0}", (Object[])new String[]{attDetail.getLogicalName()}, (Throwable)ioe);
            return null;
        }
    }

    private boolean mergeDocument(AttachmentDetail attDetail, PdfReader reader, PdfCopy writer) {
        try {
            writer.addDocument(reader);
            return true;
        }
        catch (Exception e) {
            SilverLogger.getLogger((Object)this).error("Cannot merge PDF {0}", (Object[])new String[]{attDetail.getLogicalName()}, (Throwable)e);
            return false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    public ExportReport processExportKmax(UserDetail userDetail, String language, List<WAAttributeValuePair> itemsToExport, List<String> combination, String timeCriteria, boolean useNameForFolders) throws ImportExportException {
        LocalizationBundle messages = ResourceLocator.getLocalizationBundle((String)"org.silverpeas.importExport.multilang.importExportBundle", (String)language);
        PublicationsTypeManager pubTypMgr = this.getPublicationsTypeManager();
        AdminImportExport adminIE = new AdminImportExport();
        SilverPeasExchangeType silverPeasExch = new SilverPeasExchangeType();
        ExportReport exportReport = new ExportReport();
        try {
            File fileExportDir;
            block57: {
                void var35_54;
                String exportPath;
                String publicationFileNameRelativePath;
                String componentId;
                String tempDir;
                String thisExportDir;
                block56: {
                    exportReport.setDateDebut(new Date());
                    thisExportDir = this.generateExportDirName(userDetail, "export");
                    tempDir = FileRepositoryManager.getTemporaryPath();
                    fileExportDir = new File(tempDir + thisExportDir);
                    if (!fileExportDir.exists()) {
                        try {
                            FileFolderManager.createFolder((File)fileExportDir);
                        }
                        catch (UtilException ex) {
                            throw new ImportExportException("ImportExport", "importExport.EX_CANT_CREATE_FOLDER", (Exception)((Object)ex));
                        }
                    }
                    List<PublicationType> publicationsType = pubTypMgr.processExport(exportReport, userDetail, itemsToExport, fileExportDir.getPath(), useNameForFolders, true, null);
                    HashSet<String> listComponentId = new HashSet<String>();
                    componentId = null;
                    for (PublicationType pubType : publicationsType) {
                        listComponentId.add(pubType.getComponentId());
                        componentId = pubType.getComponentId();
                    }
                    silverPeasExch.setComponentsType(adminIE.getComponents(new ArrayList<String>(listComponentId)));
                    if (combination == null) break block56;
                    File fileHTML = new File(tempDir + thisExportDir + File.separator + "index.html");
                    HtmlExportGenerator h = new HtmlExportGenerator(exportReport, fileExportDir.getName(), messages);
                    OutputStreamWriter fileWriter = null;
                    try {
                        fileHTML.createNewFile();
                        fileWriter = new OutputStreamWriter((OutputStream)new FileOutputStream(fileHTML.getPath()), Charsets.UTF_8);
                        List<String> positionsLabels = this.coordinateImportExport.getCombinationLabels(combination, componentId);
                        fileWriter.write(h.kmaxPublicationsToHTML(positionsLabels, timeCriteria, IFRAME_PUBLICATION));
                    }
                    catch (IOException ex) {
                        try {
                            throw new ImportExportException("ImportExport", "root.EX_CANT_WRITE_FILE", ex);
                        }
                        catch (Throwable throwable) {
                            IOUtils.closeQuietly(fileWriter);
                            throw throwable;
                        }
                    }
                    IOUtils.closeQuietly((Writer)fileWriter);
                    break block57;
                }
                File emptyFileHTML = new File(tempDir + thisExportDir + File.separatorChar + "empty.html");
                OutputStreamWriter fileWriter = null;
                try {
                    emptyFileHTML.createNewFile();
                    fileWriter = new OutputStreamWriter((OutputStream)new FileOutputStream(emptyFileHTML.getPath()), Charsets.UTF_8);
                }
                catch (IOException ex) {
                    try {
                        throw new ImportExportException("ImportExport", "root.EX_CANT_WRITE_FILE", ex);
                    }
                    catch (Throwable throwable) {
                        IOUtils.closeQuietly(fileWriter);
                        throw throwable;
                    }
                }
                IOUtils.closeQuietly((Writer)fileWriter);
                ComponentInst componentInst = OrganizationControllerProvider.getOrganisationController().getComponentInst(componentId);
                GEDImportExport gedIE = ImportExportFactory.createGEDImportExport(userDetail, componentId);
                String unbalancedFileNameRelativePath = "index-2.html";
                File unclassifiedFileHTML = new File(tempDir + thisExportDir + File.separatorChar + unbalancedFileNameRelativePath);
                HtmlExportGenerator h = new HtmlExportGenerator(exportReport, fileExportDir.getName(), messages);
                try {
                    unclassifiedFileHTML.createNewFile();
                    fileWriter = new OutputStreamWriter((OutputStream)new FileOutputStream(unclassifiedFileHTML.getPath(), true), Charsets.UTF_8);
                    fileWriter.write(h.toHtmlPublicationsByPositionStart());
                }
                catch (IOException ex) {
                    throw new ImportExportException("ImportExport", "root.EX_CANT_WRITE_FILE", ex);
                }
                finally {
                    IOUtils.closeQuietly((Writer)fileWriter);
                }
                List<PublicationDetail> unbalancedPublications = PublicationImportExport.getUnbalancedPublications(componentId);
                String componentLabel = FileServerUtils.replaceAccentChars((String)componentInst.getLabel());
                for (PublicationDetail pubDetail : unbalancedPublications) {
                    PublicationType publicationType = gedIE.getPublicationCompleteById(String.valueOf(pubDetail.getId()), componentId);
                    publicationFileNameRelativePath = componentLabel + File.separator + pubDetail.getId() + File.separator + "index.html";
                    pubTypMgr.fillPublicationType(gedIE, publicationType, null);
                    int nbThemes = pubTypMgr.getNbThemes(gedIE, publicationType, null);
                    HtmlExportPublicationGenerator unbalanced = new HtmlExportPublicationGenerator(publicationType, null, publicationFileNameRelativePath, nbThemes);
                    exportReport.addHtmlIndex(pubDetail.getId(), unbalanced);
                    fileWriter = null;
                    try {
                        fileWriter = new OutputStreamWriter((OutputStream)new FileOutputStream(unclassifiedFileHTML.getPath(), true), Charsets.UTF_8);
                        fileWriter.write(unbalanced.toHtmlSommairePublication(IFRAME_PUBLICATION));
                    }
                    catch (IOException ex) {
                        throw new ImportExportException("ImportExport", "root.EX_CANT_WRITE_FILE", ex);
                    }
                    finally {
                        IOUtils.closeQuietly((Writer)fileWriter);
                    }
                }
                File fileHTML = new File(tempDir + thisExportDir + File.separator + "index.html");
                h = new HtmlExportGenerator(exportReport, fileExportDir.getName(), messages);
                try {
                    fileHTML.createNewFile();
                    fileWriter = new OutputStreamWriter((OutputStream)new FileOutputStream(fileHTML.getPath()), Charsets.UTF_8);
                    List<NodeDetail> axis = this.coordinateImportExport.getAxis(componentId);
                    fileWriter.write(h.kmaxAxisToHTML(axis, language));
                }
                catch (IOException ex) {
                    throw new ImportExportException("ImportExport", "root.EX_CANT_WRITE_FILE", ex);
                }
                finally {
                    IOUtils.closeQuietly((Writer)fileWriter);
                }
                String exportSummaryPath = exportPath = fileExportDir.getPath();
                List<NodeDetail> listAxis = this.coordinateImportExport.getAxisHeadersWithChildren(componentId, true, true);
                listAxis.remove(0);
                int nbAxis = listAxis.size();
                ArrayList<Collection> listAxisWithChildren = new ArrayList<Collection>();
                for (NodeDetail nodeDetail : listAxis) {
                    Collection childrenNodeDetails = nodeDetail.getChildrenDetails();
                    if (childrenNodeDetails == null || childrenNodeDetails.isEmpty()) continue;
                    listAxisWithChildren.add(childrenNodeDetails);
                }
                ArrayList<String> nodesIds = new ArrayList<String>();
                for (Collection currentAxis : listAxisWithChildren) {
                    for (NodeDetail axisNode : currentAxis) {
                        String nodeId = axisNode.getId();
                        nodesIds.add(nodeId);
                    }
                }
                ArrayList arrayList = new ArrayList();
                for (int i2 = 1; i2 <= nodesIds.size(); ++i2) {
                    List<String> list = this.coordinateImportExport.coupleIds((List<String>)var35_54, nodesIds, 0, 0, i2, null, nbAxis);
                }
                for (String positionNameId : var35_54) {
                    fileHTML = new File(exportSummaryPath + File.separator + positionNameId);
                    fileWriter = null;
                    try {
                        fileHTML.createNewFile();
                        fileWriter = new OutputStreamWriter((OutputStream)new FileOutputStream(fileHTML.getPath()), Charsets.UTF_8);
                        fileWriter.write(h.toHtmlPublicationsByPositionStart());
                    }
                    finally {
                        try {
                            ((Writer)fileWriter).close();
                        }
                        catch (Exception ex) {
                            SilverLogger.getLogger((Object)this).error(ex.getMessage(), (Throwable)ex);
                        }
                    }
                }
                exportSummaryPath = exportPath = fileExportDir.getPath();
                for (WAAttributeValuePair attValue : itemsToExport) {
                    ArrayList<Object> filesPositionsHTMLToFill = new ArrayList<Object>();
                    String pubId = attValue.getName();
                    componentId = attValue.getValue();
                    gedIE = ImportExportFactory.createGEDImportExport(userDetail, componentId);
                    StringBuilder positionFileNameHTML = new StringBuilder();
                    PublicationType publicationType = gedIE.getPublicationCompleteById(pubId, componentId);
                    pubTypMgr.fillPublicationType(gedIE, publicationType, null);
                    publicationType.setCoordinatesPositionsType(new CoordinatesPositionsType());
                    ArrayList<CoordinatePoint> listCoordinatesPositions = new ArrayList<CoordinatePoint>();
                    Collection<Coordinate> coordinates = gedIE.getPublicationCoordinates(pubId, componentId);
                    for (Coordinate coordinate : coordinates) {
                        void var47_76;
                        positionFileNameHTML.append("index");
                        Collection coordinatesPoints = coordinate.getCoordinatePoints();
                        for (CoordinatePoint coordinatePoint : coordinatesPoints) {
                            positionFileNameHTML.append("-").append(coordinatePoint.getNodeId());
                            listCoordinatesPositions.add(coordinatePoint);
                        }
                        if (!filesPositionsHTMLToFill.contains(positionFileNameHTML + ".html")) {
                            filesPositionsHTMLToFill.add(positionFileNameHTML + ".html");
                        }
                        ArrayList arrayList2 = new ArrayList();
                        StringTokenizer st = new StringTokenizer(positionFileNameHTML.toString(), "-");
                        while (st.hasMoreTokens()) {
                            String nodeId = st.nextToken();
                            if ("index".equals(nodeId)) continue;
                            NodeDetail currentNodeDetail = this.coordinateImportExport.getNodeHeader(new NodePK(String.valueOf(nodeId), componentId));
                            var47_76.add(currentNodeDetail.getId());
                            if (currentNodeDetail.getLevel() >= 3) {
                                List<String> list = this.addNodeToList((List<String>)var47_76, currentNodeDetail);
                                continue;
                            }
                            List axisChildren = this.coordinateImportExport.getAxisChildren(currentNodeDetail.getNodePK(), false);
                            for (NodeDetail nodeDetail : axisChildren) {
                                var47_76.add(nodeDetail.getId());
                            }
                        }
                        List<String> otherPositionsFilesNameHTML = new ArrayList<String>();
                        otherPositionsFilesNameHTML = this.coordinateImportExport.coupleIds(otherPositionsFilesNameHTML, (List<String>)var47_76, 0, 0, nbAxis, null, nbAxis);
                        for (String otherPositionFileNameHTML : otherPositionsFilesNameHTML) {
                            if (filesPositionsHTMLToFill.contains(otherPositionFileNameHTML)) continue;
                            filesPositionsHTMLToFill.add(otherPositionFileNameHTML);
                        }
                    }
                    publicationType.getCoordinatesPositionsType().setCoordinatesPositions(listCoordinatesPositions);
                    publicationFileNameRelativePath = componentLabel + File.separator + pubId + File.separator + "index.html";
                    int nbThemes = pubTypMgr.getNbThemes(gedIE, publicationType, null);
                    HtmlExportPublicationGenerator s = new HtmlExportPublicationGenerator(publicationType, null, publicationFileNameRelativePath, nbThemes);
                    exportReport.addHtmlIndex(pubId, s);
                    for (String string : filesPositionsHTMLToFill) {
                        fileHTML = new File(exportSummaryPath + File.separator + string);
                        fileWriter = null;
                        try {
                            if (!fileHTML.exists()) continue;
                            fileWriter = new OutputStreamWriter((OutputStream)new FileOutputStream(fileHTML.getPath(), true), Charsets.UTF_8);
                            fileWriter.write(s.toHtmlSommairePublication(IFRAME_PUBLICATION));
                        }
                        finally {
                            IOUtils.closeQuietly((Writer)fileWriter);
                        }
                    }
                }
            }
            this.saveToSilverpeasExchangeFile(silverPeasExch, fileExportDir.getPath() + File.separator + "importExport.xml");
            this.createZipFile(fileExportDir, exportReport);
        }
        catch (Exception ex) {
            throw new ImportExportException("importExport", "ImportExport.processExportKmax()", ex);
        }
        return exportReport;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void writeImportToLog(ImportReport importReport, MultiSilverpeasBundle resource) {
        if (importReport != null) {
            String reportLogFile = settings.getString("importExportLogFile");
            File file = new File(reportLogFile);
            OutputStreamWriter fileWriter = null;
            try {
                if (!file.exists()) {
                    file.createNewFile();
                }
                fileWriter = new OutputStreamWriter((OutputStream)new FileOutputStream(file.getPath(), true), Charsets.UTF_8);
                fileWriter.write(importReport.writeToLog(resource));
                IOUtils.closeQuietly((Writer)fileWriter);
            }
            catch (IOException ex) {
                SilverLogger.getLogger((Object)this).error(ex.getMessage(), (Throwable)ex);
            }
            finally {
                IOUtils.closeQuietly(fileWriter);
            }
        }
    }

    private List<String> addNodeToList(List<String> nodesIds, NodeDetail nodeDetail) {
        nodesIds.add(String.valueOf(nodeDetail.getFatherPK().getId()));
        if (nodeDetail.getLevel() >= 4) {
            NodeDetail parentNodeDetail = this.coordinateImportExport.getNodeHeader(nodeDetail.getFatherPK());
            this.addNodeToList(nodesIds, parentNodeDetail);
        }
        return nodesIds;
    }

    private ExportReport processExportOfFilesOnly(UserDetail userDetail, List<WAAttributeValuePair> listItemsToExport, NodePK rootPK, boolean useNameForFolders) throws ImportExportException {
        PublicationsTypeManager pubTypMgr = this.getPublicationsTypeManager();
        ExportReport exportReport = new ExportReport();
        File fileExportDir = this.createExportDir(userDetail);
        try {
            pubTypMgr.processExportOfFilesOnly(exportReport, userDetail, listItemsToExport, fileExportDir.getPath(), rootPK, useNameForFolders);
        }
        catch (IOException e1) {
            throw new ImportExportException("ImportExport", "root.EX_CANT_EXPORT_FILES", e1);
        }
        this.createZipFile(fileExportDir, exportReport);
        return exportReport;
    }

    private ExportReport processExportOfPublicationsOnly(UserDetail userDetail, List<WAAttributeValuePair> listItemsToExport, NodePK rootPK, boolean useNameForFolders) throws ImportExportException {
        PublicationsTypeManager pubTypMgr = this.getPublicationsTypeManager();
        ExportReport exportReport = new ExportReport();
        exportReport.setDateDebut(new Date());
        File fileExportDir = this.createExportDir(userDetail);
        pubTypMgr.processExport(exportReport, userDetail, listItemsToExport, fileExportDir.getPath(), useNameForFolders, rootPK != null, rootPK);
        this.createZipFile(fileExportDir, exportReport);
        return exportReport;
    }

    private PublicationsTypeManager getPublicationsTypeManager() {
        return (PublicationsTypeManager)ServiceProvider.getService(PublicationsTypeManager.class, (Annotation[])new Annotation[0]);
    }
}

