/*
 * Decompiled with CFR 0.152.
 */
package com.sun.portal.container.service.coordination.impl;

import com.sun.portal.container.ContainerException;
import com.sun.portal.container.ContainerLogger;
import com.sun.portal.container.EntityID;
import com.sun.portal.container.PortletEvent;
import com.sun.portal.container.service.EventHolder;
import com.sun.portal.container.service.ServiceAdapter;
import com.sun.portal.container.service.coordination.ContainerEventService;
import com.sun.portal.container.service.coordination.ContainerEventSubscriber;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.servlet.ServletContext;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.xml.namespace.QName;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ContainerEventServiceImpl
extends ServiceAdapter
implements ContainerEventService {
    private static Logger logger = ContainerLogger.getLogger(ContainerEventServiceImpl.class, "CLogMessages");
    private List<ContainerEventSubscriber> subscribers;
    private List<EventHolder> supportedEvents;
    private static final String DESCRIPTION = "Responsible for sending container events to all the registered subscribers";
    private static final String CONTAINER_EVENT_NAMESPACE = "urn:oasis:names:tc:wsrp:v2:types";

    @Override
    public void init(ServletContext context) {
        if (this.subscribers == null) {
            this.subscribers = new CopyOnWriteArrayList<ContainerEventSubscriber>();
        }
        this.supportedEvents = new ArrayList<EventHolder>();
        this.initContainerEvents();
    }

    @Override
    public String getName() {
        return "com.sun.portal.container.service.ContainerEventService";
    }

    @Override
    public String getDescription() {
        return DESCRIPTION;
    }

    @Override
    public void destroy() {
        this.subscribers = null;
    }

    @Override
    public List<EntityID> setEvent(QName eventQName, Serializable value) {
        return this.setContainerEvent(eventQName, value, null);
    }

    @Override
    public void setEvent(QName eventQName, Serializable value, EntityID entityID) {
        this.setContainerEvent(eventQName, value, entityID);
    }

    @Override
    public List<EntityID> setEvent(QName eventQName, Serializable value, HttpServletRequest request, HttpServletResponse response) {
        return this.setContainerEvent(eventQName, value, null, request, response);
    }

    @Override
    public void setEvent(QName eventQName, Serializable value, EntityID entityID, HttpServletRequest request, HttpServletResponse response) {
        this.setContainerEvent(eventQName, value, entityID, request, response);
    }

    @Override
    public List<EventHolder> getSupportedEvents() {
        return this.supportedEvents;
    }

    private List<EntityID> setContainerEvent(QName eventQName, Serializable value, EntityID entityID, HttpServletRequest request, HttpServletResponse response) {
        PortletEvent event = this.getPortletEvent(eventQName, value);
        List<EntityID> portlets = null;
        if (this.supportedEvents.contains(event.getEventHolder())) {
            for (ContainerEventSubscriber containerEventSubscriber : this.subscribers) {
                try {
                    if (request == null && response == null) {
                        portlets = containerEventSubscriber.processContainerEvent(event, entityID);
                        continue;
                    }
                    portlets = containerEventSubscriber.processContainerEvent(event, entityID, request, response);
                }
                catch (ContainerException ex) {
                    if (!logger.isLoggable(Level.WARNING)) continue;
                    logger.log(Level.WARNING, "PSC_CSPCS025", new String[]{ex.toString(), event.getName()});
                }
            }
        }
        return portlets;
    }

    private List<EntityID> setContainerEvent(QName eventQName, Serializable value, EntityID entityID) {
        return this.setContainerEvent(eventQName, value, entityID, null, null);
    }

    private PortletEvent getPortletEvent(QName eventQName, Serializable value) {
        PortletEvent event = new PortletEvent(this.getEventHolder(eventQName, value), eventQName, value);
        return event;
    }

    private EventHolder getEventHolder(QName eventQName, Serializable value) {
        if (eventQName == null) {
            throw new IllegalArgumentException("Event cannot be null");
        }
        String valueType = null;
        if (value != null) {
            valueType = value.getClass().getName();
        }
        EventHolder eventHolder = new EventHolder(Collections.EMPTY_MAP, eventQName, Collections.EMPTY_LIST, valueType);
        return eventHolder;
    }

    @Override
    public void registerSubscriber(ContainerEventSubscriber containerEventSubscriber) {
        if (!this.subscribers.contains(containerEventSubscriber)) {
            this.subscribers.add(containerEventSubscriber);
        }
    }

    private void initContainerEvents() {
        QName qname = new QName(CONTAINER_EVENT_NAMESPACE, "login");
        this.supportedEvents.add(this.getEventHolder(qname, null));
        qname = new QName(CONTAINER_EVENT_NAMESPACE, "logout");
        this.supportedEvents.add(this.getEventHolder(qname, null));
        qname = new QName(CONTAINER_EVENT_NAMESPACE, "eventHandlingFailed");
        this.supportedEvents.add(this.getEventHolder(qname, null));
        qname = new QName(CONTAINER_EVENT_NAMESPACE, "newNavigationalContextScope");
        this.supportedEvents.add(this.getEventHolder(qname, null));
        qname = new QName(CONTAINER_EVENT_NAMESPACE, "newMode");
        this.supportedEvents.add(this.getEventHolder(qname, null));
        qname = new QName(CONTAINER_EVENT_NAMESPACE, "newWindowState");
        this.supportedEvents.add(this.getEventHolder(qname, null));
    }
}

