/*
 * Decompiled with CFR 0.152.
 */
package org.silverpeas.core.workflow.util;

import java.text.ParseException;
import java.util.Arrays;
import java.util.Map;
import java.util.stream.Collectors;
import org.silverpeas.core.contribution.content.form.Field;
import org.silverpeas.core.contribution.content.form.FieldTemplate;
import org.silverpeas.core.util.DateUtil;
import org.silverpeas.core.workflow.api.model.Item;
import org.silverpeas.kernel.logging.SilverLogger;
import org.silverpeas.kernel.util.StringUtil;

public class WorkflowUtil {
    public static final String PROCESS_XML_FILE_NAME = "XMLFileName";
    private static final String SEVERAL_VALUE_DELIMITER = "##";

    private WorkflowUtil() {
    }

    public static Comparable getFieldComparable(Item[] items, FieldTemplate fieldTemplate, Field field, String language) {
        String formattedValue = WorkflowUtil.formatFieldValueAsString(items, fieldTemplate, field, language);
        if ("date".equals(field.getTypeName())) {
            try {
                return StringUtil.isDefined((String)formattedValue) ? DateUtil.getDateInputFormat((String)language).parse(formattedValue) : null;
            }
            catch (ParseException e) {
                SilverLogger.getLogger(WorkflowUtil.class).error((Throwable)e);
            }
        }
        return formattedValue;
    }

    public static String formatFieldValueAsString(Item[] items, FieldTemplate fieldTemplate, Field field, String language) {
        Map<String, String> keyValuePairs;
        String fieldName;
        Item item;
        String fieldValueAsString = StringUtil.defaultStringIfNotDefined((String)field.getValue(language));
        if (!(!fieldValueAsString.isEmpty() && "date".equals(field.getTypeName()) || (item = WorkflowUtil.getItemByName(items, fieldName = fieldTemplate.getFieldName())) == null || (keyValuePairs = item.getKeyValuePairs()) == null || keyValuePairs.isEmpty())) {
            fieldValueAsString = Arrays.stream(fieldValueAsString.split(SEVERAL_VALUE_DELIMITER)).map(keyValuePairs::get).collect(Collectors.joining(", "));
        }
        return fieldValueAsString;
    }

    public static Item getItemByName(Item[] items, String itemName) {
        for (Item item : items) {
            if (!itemName.equals(item.getName())) continue;
            return item;
        }
        return null;
    }
}

