/*
 * Decompiled with CFR 0.152.
 */
package org.silverpeas.core.web.util.viewgenerator.html.datereminder;

import java.util.Date;
import org.silverpeas.core.contribution.publication.datereminder.PublicationNoteReference;
import org.silverpeas.core.contribution.publication.model.PublicationDetail;
import org.silverpeas.core.datereminder.persistence.DateReminderDetail;
import org.silverpeas.core.datereminder.persistence.PersistentResourceDateReminder;
import org.silverpeas.core.datereminder.persistence.service.DateReminderServiceProvider;
import org.silverpeas.core.datereminder.persistence.service.PersistentDateReminderService;
import org.silverpeas.core.util.DateUtil;
import org.silverpeas.kernel.bundle.LocalizationBundle;
import org.silverpeas.kernel.bundle.ResourceLocator;

public class DateReminder {
    private String resourceId;
    private String resourceType;
    private String userId;
    private String language;
    private LocalizationBundle messages;

    public DateReminder(String resourceId, String resourceType, String userId, String language) {
        this.resourceId = resourceId;
        this.resourceType = resourceType;
        this.userId = userId;
        this.language = language;
        this.messages = ResourceLocator.getLocalizationBundle((String)"org.silverpeas.dateReminder.multilang.dateReminder", (String)language);
    }

    public void setResourceId(String resourceId) {
        this.resourceId = resourceId;
    }

    public void setResourceType(String resourceType) {
        this.resourceType = resourceType;
    }

    public void setUserId(String userId) {
        this.userId = userId;
    }

    public void setLanguage(String language) {
        this.language = language;
    }

    public String getResourceId() {
        return this.resourceId;
    }

    public String getResourceType() {
        return this.resourceType;
    }

    public String getUserId() {
        return this.userId;
    }

    public String getLanguage() {
        return this.language;
    }

    public String print() {
        PersistentDateReminderService dateReminderService;
        PersistentResourceDateReminder persistentResourceDateReminder;
        StringBuilder builder = new StringBuilder(100);
        String dateReminder = "";
        String messageReminder = "";
        PublicationNoteReference resource = null;
        if (PublicationDetail.getResourceType().equals(this.getResourceType()) && this.getResourceId() != null) {
            resource = new PublicationNoteReference(this.getResourceId());
        }
        if (resource != null && (persistentResourceDateReminder = (dateReminderService = DateReminderServiceProvider.getDateReminderService()).get(resource)).isDefined()) {
            DateReminderDetail dateReminderDetail = persistentResourceDateReminder.getDateReminder();
            Date dateReminderDate = dateReminderDetail.getDateReminder();
            dateReminder = DateUtil.dateToString((Date)dateReminderDate, (String)this.getLanguage());
            messageReminder = dateReminderDetail.getMessage();
        }
        builder.append("<fieldset id=\"reminder\" class=\"skinFieldset\">").append("\n");
        builder.append("<legend>").append(this.messages.getString("dateReminder.fieldSet")).append("</legend>").append("\n");
        builder.append("<div class=\"fields\">").append("\n");
        builder.append("<div class=\"field\" id=\"dateReminderArea\">").append("\n");
        builder.append("<label for=\"dateReminder\" class=\"txtlibform\">").append(this.messages.getString("dateReminder.date")).append("</label>").append("\n");
        builder.append("<div class=\"champs\">").append("\n");
        builder.append("<input id=\"dateReminder\" type=\"text\" class=\"dateToPick\" name=\"DateReminder\" value=\"").append(dateReminder).append("\" size=\"12\" maxlength=\"10\"/>").append("\n");
        builder.append("</div>").append("\n");
        builder.append("</div>").append("\n");
        builder.append("<div class=\"field\" id=\"messageReminderArea\">").append("\n");
        builder.append("<label for=\"messageReminder\" class=\"txtlibform\">").append(this.messages.getString("dateReminder.message")).append("</label>").append("\n");
        builder.append("<div class=\"champs\">").append("\n");
        builder.append("<textarea rows=\"4\" cols=\"65\" name=\"MessageReminder\" id=\"messageReminder\">").append(messageReminder).append("</textarea>").append("\n");
        builder.append("</div>").append("\n");
        builder.append("</div>").append("\n");
        builder.append("</div>").append("\n");
        builder.append("</fieldset>").append("\n");
        return builder.toString();
    }
}

