/*
 * Decompiled with CFR 0.152.
 */
package org.silverpeas.core.web.mvc.webcomponent;

import javax.servlet.ServletConfig;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.ws.rs.DELETE;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.PUT;
import org.silverpeas.core.web.http.HttpRequest;
import org.silverpeas.core.web.mvc.controller.ComponentContext;
import org.silverpeas.core.web.mvc.controller.MainSessionController;
import org.silverpeas.core.web.mvc.route.ComponentRequestRouter;
import org.silverpeas.core.web.mvc.webcomponent.PathExecutionResponse;
import org.silverpeas.core.web.mvc.webcomponent.WebComponentManager;
import org.silverpeas.core.web.mvc.webcomponent.WebComponentRequestContext;
import org.silverpeas.core.web.mvc.webcomponent.annotation.WebComponentController;

public final class WebComponentRequestRouter<T extends org.silverpeas.core.web.mvc.webcomponent.WebComponentController<R>, R extends WebComponentRequestContext<? extends org.silverpeas.core.web.mvc.webcomponent.WebComponentController<R>>>
extends ComponentRequestRouter<T> {
    private static final long serialVersionUID = -3344222078427488724L;
    private static final String WEB_COMPONENT_CONTROLLER_CLASS_NAME_PARAM = WebComponentController.class.getSimpleName();
    private Class<T> webComponentControllerClass;
    private String webComponentControllerBeanName;

    public void init() throws ServletException {
        ServletConfig servletConfig = this.getServletConfig();
        String webComponentClassName = servletConfig.getInitParameter(WEB_COMPONENT_CONTROLLER_CLASS_NAME_PARAM);
        try {
            this.webComponentControllerClass = Class.forName(webComponentClassName);
            WebComponentController webComponentControllerAnnotation = this.webComponentControllerClass.getAnnotation(WebComponentController.class);
            if (webComponentControllerAnnotation == null) {
                throw new IllegalArgumentException(webComponentClassName + " must specify one, and only one, @WebComponentController annotation");
            }
            this.webComponentControllerBeanName = webComponentControllerAnnotation.value();
        }
        catch (ClassNotFoundException e) {
            throw new ServletException((Throwable)e);
        }
        super.init();
    }

    @Override
    public String getSessionControlBeanName() {
        return this.webComponentControllerBeanName;
    }

    @Override
    public T createComponentSessionController(MainSessionController mainSessionCtrl, ComponentContext componentContext) {
        try {
            return (T)((org.silverpeas.core.web.mvc.webcomponent.WebComponentController)this.webComponentControllerClass.getConstructor(MainSessionController.class, ComponentContext.class).newInstance(mainSessionCtrl, componentContext));
        }
        catch (Exception e) {
            throw new IllegalArgumentException(this.webComponentControllerClass + " does not expose the required constructor.", e);
        }
    }

    protected void doPut(HttpServletRequest request, HttpServletResponse response) {
        WebComponentManager.manageRequestFor(this.webComponentControllerClass, PUT.class, (HttpRequest)request, response);
        super.doPost(request, response);
    }

    protected void doDelete(HttpServletRequest request, HttpServletResponse response) {
        WebComponentManager.manageRequestFor(this.webComponentControllerClass, DELETE.class, (HttpRequest)request, response);
        super.doPost(request, response);
    }

    @Override
    public void doPost(HttpServletRequest request, HttpServletResponse response) {
        WebComponentManager.manageRequestFor(this.webComponentControllerClass, POST.class, (HttpRequest)request, response);
        super.doPost(request, response);
    }

    @Override
    public void doGet(HttpServletRequest request, HttpServletResponse response) {
        WebComponentManager.manageRequestFor(this.webComponentControllerClass, GET.class, (HttpRequest)request, response);
        super.doGet(request, response);
    }

    @Override
    public final String getDestination(String path, T componentSC, HttpRequest request) {
        String destination;
        try {
            PathExecutionResponse response = WebComponentManager.perform(componentSC, path);
            destination = response.produces().orElseGet(() -> response.navigation().orElseThrow(() -> this.forbidden("")).getDestination());
        }
        catch (Exception e) {
            request.setAttribute("javax.servlet.jsp.jspException", (Object)e);
            destination = "/admin/jsp/errorpageMain.jsp";
        }
        return destination;
    }
}

