/*
 * Decompiled with CFR 0.152.
 */
package org.silverpeas.core.web.mvc.webcomponent;

import java.net.URI;
import java.util.ArrayList;
import java.util.List;
import javax.ws.rs.core.UriBuilder;
import org.silverpeas.core.cache.service.CacheAccessorProvider;
import org.silverpeas.core.web.mvc.webcomponent.NavigationContextListener;
import org.silverpeas.core.web.mvc.webcomponent.WebComponentRequestContext;
import org.silverpeas.kernel.cache.model.SimpleCache;

public class NavigationContext<C extends WebComponentRequestContext> {
    private final NavigationStep baseNavigationStep;
    private final List<NavigationContextListener> listeners = new ArrayList<NavigationContextListener>();
    private C webComponentRequestContext;
    private NavigationStep currentNavigationStep;
    private NavigationStep previousNavigationStep;

    NavigationContext(C webComponentRequestContext) {
        this.webComponentRequestContext = webComponentRequestContext;
        this.currentNavigationStep = this.baseNavigationStep = new NavigationStep(null).withSuffixUri("Main");
        this.previousNavigationStep = this.baseNavigationStep;
    }

    public static <T extends WebComponentRequestContext> NavigationContext<T> get(T context) {
        String cacheKey = "NavigationContext@" + context.getComponentUriBase();
        SimpleCache sessionCache = CacheAccessorProvider.getSessionCacheAccessor().getCache();
        NavigationContext<T> navigationContext = (NavigationContext<T>)sessionCache.get((Object)cacheKey, NavigationContext.class);
        if (navigationContext == null) {
            navigationContext = new NavigationContext<T>(context);
            sessionCache.put((Object)cacheKey, navigationContext);
        } else {
            navigationContext.webComponentRequestContext = context;
        }
        return navigationContext;
    }

    public void addListener(NavigationContextListener listener) {
        this.listeners.add(listener);
    }

    public C getWebComponentRequestContext() {
        return this.webComponentRequestContext;
    }

    public NavigationStep getPreviousNavigationStep() {
        return this.previousNavigationStep;
    }

    public NavigationStep getCurrentNavigationStep() {
        return this.currentNavigationStep;
    }

    public NavigationStep getBaseNavigationStep() {
        return this.baseNavigationStep;
    }

    public NavigationStep navigationStepFrom(String stepIdentifier) {
        NavigationStep current = this.findNavigationStepFrom(stepIdentifier);
        if (current != null) {
            this.trashAfter(current);
            this.currentNavigationStep = current;
            this.previousNavigationStep = current.getPrevious();
            for (NavigationContextListener listener : this.listeners) {
                listener.navigationStepReset(this);
            }
        } else {
            this.currentNavigationStep.withNext(new NavigationStep(stepIdentifier));
            this.currentNavigationStep.getNext().withPrevious(this.currentNavigationStep);
            this.currentNavigationStep = this.currentNavigationStep.getNext();
            this.previousNavigationStep = this.currentNavigationStep.getPrevious();
            for (NavigationContextListener listener : this.listeners) {
                listener.navigationStepCreated(this);
            }
        }
        ((WebComponentRequestContext)this.getWebComponentRequestContext()).markNavigationStepContextPerformed();
        return this.currentNavigationStep;
    }

    public NavigationStep insertNewPreviousNavigationStep(String previousStepIdentifier) {
        NavigationStep newPrevious = new NavigationStep(previousStepIdentifier);
        this.previousNavigationStep.withNext(newPrevious);
        newPrevious.withNext(this.currentNavigationStep);
        newPrevious.withPrevious(this.previousNavigationStep);
        this.currentNavigationStep.withPrevious(newPrevious);
        this.previousNavigationStep = this.currentNavigationStep.getPrevious();
        return newPrevious;
    }

    void noNavigationStep() {
        if (!((WebComponentRequestContext)this.getWebComponentRequestContext()).isNavigationStepContextPerformed()) {
            this.previousNavigationStep = this.currentNavigationStep;
            for (NavigationContextListener listener : this.listeners) {
                listener.noNavigationStepPerformed(this);
            }
        }
    }

    public NavigationStep clear() {
        this.trashAfter(this.baseNavigationStep);
        this.currentNavigationStep = this.baseNavigationStep;
        this.previousNavigationStep = this.baseNavigationStep;
        for (NavigationContextListener listener : this.listeners) {
            listener.navigationContextCleared(this);
        }
        return this.currentNavigationStep;
    }

    private void trashAfter(NavigationStep navigationStep) {
        navigationStep.withNext(null);
        for (NavigationStep toTrash = navigationStep.getNext(); toTrash != null; toTrash = toTrash.getNext()) {
            toTrash.withPrevious(null);
            for (NavigationContextListener listener : this.listeners) {
                listener.navigationStepTrashed(toTrash);
            }
        }
    }

    NavigationStep findNavigationStepFrom(String stepIdentifier) {
        NavigationStep current;
        for (current = this.getBaseNavigationStep().getNext(); current != null && !current.getIdentifier().equals(stepIdentifier); current = current.getNext()) {
        }
        return current;
    }

    public class NavigationStep {
        static final String PREVIOUS_PAGE_FULL_URI_ID = "previousPageFullUri";
        private final String identifier;
        private String contextIdentifier;
        private NavigationStep previous;
        private NavigationStep next;
        private URI uri = URI.create("");
        private boolean uriMustBeUsedByBrowseBar = true;
        private String label;

        private NavigationStep(String identifier) {
            this.identifier = identifier;
        }

        public NavigationContext<C> getNavigationContext() {
            return NavigationContext.this;
        }

        public String getIdentifier() {
            return this.identifier;
        }

        public String getContextIdentifier() {
            return this.contextIdentifier;
        }

        public NavigationStep withContextIdentifier(String contextIdentifier) {
            String oldContextIdentifier = this.contextIdentifier;
            this.contextIdentifier = contextIdentifier;
            for (NavigationContextListener listener : NavigationContext.this.listeners) {
                listener.navigationStepContextIdentifierSet(this, oldContextIdentifier);
            }
            return this;
        }

        public String getLabel() {
            return this.label;
        }

        public NavigationStep withLabel(String label) {
            String oldLabel = this.label;
            this.label = label;
            for (NavigationContextListener listener : NavigationContext.this.listeners) {
                listener.navigationStepLabelSet(this, oldLabel);
            }
            return this;
        }

        public URI getUri() {
            return this.uri;
        }

        public NavigationStep withFullUri(String fullUri) {
            this.uri = URI.create(fullUri);
            return this;
        }

        public NavigationStep withSuffixUri(String suffixUri) {
            this.uri = UriBuilder.fromUri((String)((WebComponentRequestContext)NavigationContext.this.webComponentRequestContext).getComponentUriBase()).path(suffixUri).build(new Object[0]);
            return this;
        }

        public NavigationStep getPrevious() {
            return this.previous;
        }

        NavigationStep withPrevious(NavigationStep previous) {
            this.previous = previous;
            return this;
        }

        public NavigationStep getNext() {
            return this.next;
        }

        NavigationStep withNext(NavigationStep next) {
            this.next = next;
            return this;
        }

        public boolean isUriMustBeUsedByBrowseBar() {
            return this.uriMustBeUsedByBrowseBar;
        }

        public NavigationStep setUriMustBeUsedByBrowseBar(boolean uriMustBeUsedByBrowseBar) {
            this.uriMustBeUsedByBrowseBar = uriMustBeUsedByBrowseBar;
            return this;
        }
    }
}

