/*
 * Decompiled with CFR 0.152.
 */
package org.silverpeas.core.web.jstl.view;

import java.lang.annotation.Annotation;
import java.util.Iterator;
import javax.servlet.jsp.JspException;
import javax.servlet.jsp.tagext.TagSupport;
import org.silverpeas.core.contribution.content.wysiwyg.service.WysiwygController;
import org.silverpeas.core.i18n.I18NHelper;
import org.silverpeas.core.util.ServiceProvider;
import org.silverpeas.core.web.glossary.HighlightGlossaryTerms;
import org.silverpeas.kernel.util.StringUtil;

public class WysiwygDisplayerTag
extends TagSupport {
    private static final long serialVersionUID = 1L;
    private String objectId;
    private String componentId;
    private String language;
    private String axisId;
    private boolean highlightFirst;

    public String getObjectId() {
        return this.objectId;
    }

    public void setObjectId(String objectId) {
        this.objectId = objectId;
    }

    public String getComponentId() {
        return this.componentId;
    }

    public void setComponentId(String componentId) {
        this.componentId = componentId;
    }

    public String getLanguage() {
        return this.language;
    }

    public void setLanguage(String language) {
        this.language = language;
    }

    public String getAxisId() {
        return this.axisId;
    }

    public void setAxisId(String axisId) {
        this.axisId = axisId;
    }

    public String getHighlightFirst() {
        return String.valueOf(this.highlightFirst);
    }

    public void setHighlightFirst(String highlightFirst) {
        this.highlightFirst = StringUtil.getBooleanValue((String)highlightFirst);
    }

    public int doStartTag() throws JspException {
        try {
            String currentLang = this.getLanguage();
            String content = WysiwygController.loadForReadOnly((String)this.getComponentId(), (String)this.getObjectId(), (String)currentLang);
            if (!StringUtil.isDefined((String)content) && I18NHelper.isI18nContentActivated) {
                Iterator languages = I18NHelper.getLanguages().iterator();
                while (languages.hasNext() && !StringUtil.isDefined((String)content)) {
                    currentLang = (String)languages.next();
                    content = WysiwygController.loadForReadOnly((String)this.getComponentId(), (String)this.getObjectId(), (String)currentLang);
                }
            }
            if (StringUtil.isDefined((String)this.getAxisId())) {
                HighlightGlossaryTerms highlightGlossaryTerms = (HighlightGlossaryTerms)ServiceProvider.getService(HighlightGlossaryTerms.class, (Annotation[])new Annotation[0]);
                content = highlightGlossaryTerms.searchReplace(content, "highlight-silver", this.getAxisId(), this.highlightFirst, currentLang);
            }
            this.pageContext.getOut().println(content);
        }
        catch (Exception e) {
            throw new JspException("Can't display wysiwyg player", (Throwable)e);
        }
        return 0;
    }
}

