/*
 * Decompiled with CFR 0.152.
 */
package org.silverpeas.core.web.authentication.credentials;

import javax.inject.Inject;
import javax.servlet.http.HttpServletRequest;
import org.silverpeas.core.admin.service.AdminException;
import org.silverpeas.core.admin.user.model.User;
import org.silverpeas.core.admin.user.model.UserDetail;
import org.silverpeas.core.annotation.Service;
import org.silverpeas.core.security.authentication.exception.AuthenticationException;
import org.silverpeas.core.web.authentication.credentials.ChangePasswordFunctionHandler;
import org.silverpeas.core.web.authentication.credentials.ForcePasswordChangeHandler;
import org.silverpeas.kernel.logging.SilverLogger;

@Service
public class EffectiveChangePasswordHandler
extends ChangePasswordFunctionHandler {
    @Inject
    private ForcePasswordChangeHandler forcePasswordChangeHandler;

    @Override
    public String getFunction() {
        return "EffectiveChangePassword";
    }

    @Override
    public String doAction(HttpServletRequest request) {
        try {
            UserDetail ud = this.getRequester(request);
            return this.doPasswordChange(request, ud);
        }
        catch (AdminException e) {
            SilverLogger.getLogger((Object)this).error((Throwable)e);
            return this.forcePasswordChangeHandler.doAction(request);
        }
    }

    private String doPasswordChange(HttpServletRequest request, UserDetail ud) {
        try {
            String newPassword = this.changePassword(request, (User)ud);
            return "/AuthenticationServlet?Login=" + ud.getLogin() + "&Password=" + newPassword + "&DomainId=" + ud.getDomainId();
        }
        catch (AuthenticationException e) {
            SilverLogger.getLogger((Object)this).error((Throwable)e);
            return this.performUrlChangePasswordError(request, this.forcePasswordChangeHandler.doAction(request), ud);
        }
    }
}

