/*
 * Decompiled with CFR 0.152.
 */
package com.sun.portal.portletcontainer.admin;

import com.sun.portal.portletcontainer.admin.PortletRegistryHelper;
import com.sun.portal.portletcontainer.admin.registry.PortletAppRegistryContext;
import com.sun.portal.portletcontainer.admin.registry.PortletWindowPreferenceRegistryContext;
import com.sun.portal.portletcontainer.admin.registry.PortletWindowRegistryContext;
import com.sun.portal.portletcontainer.context.registry.PortletRegistryException;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.logging.Level;
import java.util.logging.LogRecord;
import java.util.logging.Logger;

public class PortletRegistryCache {
    private static Logger logger = Logger.getLogger("com.sun.portal.portletcontainer.admin", "org.silverpeas.portlets.PALogMessages");
    private static PortletAppRegistryContext portletAppRegistryContext;
    private static PortletWindowRegistryContext portletWindowRegistryContext;
    private static PortletWindowPreferenceRegistryContext portletWindowPreferenceRegistryContext;
    private static Object syncObject;
    private static int NUMBER;

    public static void init() {
        PortletRegistryCache.updatePortletRegistryCacheMonitor("portlet-app-registry.xml");
        PortletRegistryCache.updatePortletRegistryCacheMonitor("portlet-window-registry.xml");
        PortletRegistryCache.updatePortletRegistryCacheMonitor("portlet-window-preference-registry.xml");
    }

    public static void refreshPortletAppRegistryCache(boolean refresh) {
        if (refresh) {
            PortletRegistryCache.updatePortletRegistryCacheMonitor("portlet-app-registry.xml");
        } else {
            PortletRegistryCache.clearPortletRegistryCacheMonitor("portlet-app-registry.xml");
        }
    }

    public static boolean readPortletAppRegistryCache() {
        return PortletRegistryCache.readPortletRegistryCacheMonitor("portlet-app-registry.xml");
    }

    public static void refreshPortletWindowRegistryCache(boolean refresh) {
        if (refresh) {
            PortletRegistryCache.updatePortletRegistryCacheMonitor("portlet-window-registry.xml");
        } else {
            PortletRegistryCache.clearPortletRegistryCacheMonitor("portlet-window-registry.xml");
        }
    }

    public static boolean readPortletWindowRegistryCache() {
        return PortletRegistryCache.readPortletRegistryCacheMonitor("portlet-window-registry.xml");
    }

    public static void refreshPortletWindowPreferenceRegistryCache(boolean refresh) {
        if (refresh) {
            PortletRegistryCache.updatePortletRegistryCacheMonitor("portlet-window-preference-registry.xml");
        } else {
            PortletRegistryCache.clearPortletRegistryCacheMonitor("portlet-window-preference-registry.xml");
        }
    }

    public static boolean readPortletWindowPreferenceRegistryCache() {
        return PortletRegistryCache.readPortletRegistryCacheMonitor("portlet-window-preference-registry.xml");
    }

    public static void setPortletAppRegistryContext(PortletAppRegistryContext tmpPortletAppRegistryContext) {
        portletAppRegistryContext = tmpPortletAppRegistryContext;
    }

    public static void setPortletWindowRegistryContext(PortletWindowRegistryContext tmpPortletWindowRegistryContext) {
        portletWindowRegistryContext = tmpPortletWindowRegistryContext;
    }

    public static void setPortletWindowPreferenceRegistryContext(PortletWindowPreferenceRegistryContext tmpPortletWindowPreferenceRegistryContext) {
        portletWindowPreferenceRegistryContext = tmpPortletWindowPreferenceRegistryContext;
    }

    public static PortletAppRegistryContext getPortletAppRegistryContext() {
        return portletAppRegistryContext;
    }

    public static PortletWindowRegistryContext getPortletWindowRegistryContext() {
        return portletWindowRegistryContext;
    }

    public static PortletWindowPreferenceRegistryContext getPortletWindowPreferenceRegistryContext() {
        return portletWindowPreferenceRegistryContext;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void updatePortletRegistryCacheMonitor(String fileName) {
        FileOutputStream out = null;
        try {
            Object object = syncObject;
            synchronized (object) {
                out = new FileOutputStream(PortletRegistryCache.getMonitoredFileName(fileName));
                out.write(NUMBER);
            }
        }
        catch (IOException e) {
            if (logger.isLoggable(Level.INFO)) {
                LogRecord logRecord = new LogRecord(Level.INFO, "PSPL_CSPPAM0015");
                logRecord.setLoggerName(logger.getName());
                logRecord.setParameters(new String[]{PortletRegistryCache.getMonitoredFileName(fileName)});
                logRecord.setThrown(e);
                logger.log(logRecord);
            }
        }
        finally {
            try {
                if (out != null) {
                    out.close();
                }
            }
            catch (Exception exception) {}
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void clearPortletRegistryCacheMonitor(String fileName) {
        FileOutputStream out = null;
        try {
            Object object = syncObject;
            synchronized (object) {
                out = new FileOutputStream(PortletRegistryCache.getMonitoredFileName(fileName));
            }
        }
        catch (IOException e) {
            if (logger.isLoggable(Level.INFO)) {
                LogRecord logRecord = new LogRecord(Level.INFO, "PSPL_CSPPAM0015");
                logRecord.setLoggerName(logger.getName());
                logRecord.setParameters(new String[]{PortletRegistryCache.getMonitoredFileName(fileName)});
                logRecord.setThrown(e);
                logger.log(logRecord);
            }
        }
        finally {
            try {
                if (out != null) {
                    out.close();
                }
            }
            catch (Exception exception) {}
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static boolean readPortletRegistryCacheMonitor(String fileName) {
        int value;
        FileInputStream in = null;
        try {
            Object object = syncObject;
            synchronized (object) {
                in = new FileInputStream(PortletRegistryCache.getMonitoredFileName(fileName));
                value = in.read();
            }
        }
        catch (IOException ignored) {
            value = NUMBER;
        }
        finally {
            try {
                if (in != null) {
                    in.close();
                }
            }
            catch (Exception exception) {}
        }
        return value == -1;
    }

    public static String getMonitoredFileName(String fileName) {
        String registryLocation = null;
        StringBuilder buffer = new StringBuilder();
        try {
            registryLocation = PortletRegistryHelper.getRegistryLocation();
        }
        catch (PortletRegistryException portletRegistryException) {
            // empty catch block
        }
        if (registryLocation != null) {
            buffer.append(registryLocation);
            buffer.append(File.separator);
        }
        buffer.append(".");
        buffer.append(fileName);
        logger.log(Level.FINER, "PSPL_CSPPAM0014", buffer);
        return buffer.toString();
    }

    static {
        syncObject = new Object();
        NUMBER = 100;
    }
}

