/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.atlas.lib;

import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.jena.atlas.iterator.Iter;

public class StreamOps {
    public static <X> Stream<X> stream(Iterator<X> iter) {
        return Iter.asStream(iter);
    }

    public static <X> List<X> toList(Stream<X> stream) {
        return stream.collect(Collectors.toList());
    }

    public static <X> Set<X> toSet(Stream<X> stream) {
        return stream.collect(Collectors.toSet());
    }

    public static <X> X first(Stream<X> stream) {
        return stream.findFirst().orElse(null);
    }

    public static <X> X element(Collection<X> collection) {
        return StreamOps.first(collection.stream());
    }

    public static <X> Stream<X> print(Stream<X> stream) {
        stream = stream.map(item -> {
            System.out.println(item);
            return item;
        });
        return StreamOps.toList(stream).stream();
    }
}

