/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.oak.jcr.version;

import java.io.Closeable;
import java.util.Objects;
import org.apache.jackrabbit.oak.api.PropertyState;
import org.apache.jackrabbit.oak.api.Tree;
import org.apache.jackrabbit.oak.api.Type;
import org.apache.jackrabbit.oak.spi.toggle.Feature;
import org.apache.jackrabbit.oak.spi.whiteboard.Whiteboard;
import org.apache.jackrabbit.oak.stats.Clock;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FrozenNodeLogger
implements Closeable {
    private static final Logger log = LoggerFactory.getLogger(FrozenNodeLogger.class);
    private static final long LOG_INTERVAL = Long.getLong("oak.frozenNodeLogger.minInterval", 1000L);
    private static long NO_MESSAGE_UNTIL = 0L;
    private final Clock clock;
    private final Feature feature;

    public FrozenNodeLogger(@NotNull Clock clock, @NotNull Whiteboard whiteboard) {
        this.clock = Objects.requireNonNull(clock);
        this.feature = Feature.newFeature((String)"OAK-9139_log_frozen_node_lookup", (Whiteboard)whiteboard);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public final void lookupById(@NotNull Tree tree) {
        if (!this.feature.isEnabled()) {
            return;
        }
        PropertyState primaryType = tree.getProperty("jcr:primaryType");
        if (primaryType == null || primaryType.isArray() || !((String)primaryType.getValue(Type.STRING)).equals("nt:frozenNode")) return;
        long now = this.clock.getTime();
        Class<FrozenNodeLogger> clazz = FrozenNodeLogger.class;
        synchronized (FrozenNodeLogger.class) {
            if (now < NO_MESSAGE_UNTIL) return;
            NO_MESSAGE_UNTIL = now + LOG_INTERVAL;
            this.logFrozenNode(tree);
            // ** MonitorExit[var5_4] (shouldn't be in output)
            return;
        }
    }

    @Override
    public void close() {
        this.feature.close();
    }

    protected void logFrozenNode(Tree tree) {
        log.info("Frozen node {} looked up by id", (Object)tree.getPath());
        if (log.isDebugEnabled()) {
            log.debug("Frozen node lookup call stack", (Throwable)new Exception());
        }
    }
}

