/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.jbossts.xts.recovery.participant.ba;

import com.arjuna.ats.arjuna.state.InputObjectState;
import com.arjuna.ats.arjuna.state.OutputObjectState;
import com.arjuna.webservices.logging.WSTLogger;
import com.arjuna.wst.BusinessAgreementWithParticipantCompletionParticipant;
import com.arjuna.wst.PersistableParticipant;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import javax.xml.stream.XMLStreamException;
import org.jboss.jbossts.xts.recovery.participant.ba.BAParticipantHelper;
import org.jboss.jbossts.xts.recovery.participant.ba.XTSBARecoveryModule;

public abstract class BAParticipantRecoveryRecord
implements PersistableParticipant {
    protected BusinessAgreementWithParticipantCompletionParticipant participant;
    protected String id;
    private boolean useSerialization;
    private byte[] recoveryState;
    private boolean recoveryStateValid;
    protected boolean isParticipantCompletion;
    private static final String type = "/XTS/WSBA/ParticipantRecoveryRecord";

    protected BAParticipantRecoveryRecord(String id, BusinessAgreementWithParticipantCompletionParticipant participant, boolean isParticipantCompletion) {
        this.id = id;
        this.participant = participant;
        this.recoveryState = null;
        this.recoveryStateValid = false;
        this.isParticipantCompletion = isParticipantCompletion;
    }

    @Override
    public final boolean saveState(OutputObjectState oos) {
        if (this.participant == null) {
            return false;
        }
        try {
            this.useSerialization = BAParticipantHelper.isSerializable(this.participant);
            this.recoveryState = BAParticipantHelper.getRecoveryState(this.useSerialization, this.participant);
            this.recoveryStateValid = true;
        }
        catch (Exception exception) {
            WSTLogger.i18NLogger.warn_recovery_participant_ba_BAParticipantRecoveryRecord_saveState_1(this.id);
            this.recoveryStateValid = false;
        }
        try {
            oos.packString(this.id);
            this.saveEndpointReference(oos);
            oos.packBoolean(this.recoveryStateValid);
            oos.packBoolean(this.isParticipantCompletion);
            if (this.recoveryStateValid) {
                oos.packBoolean(this.useSerialization);
                if (this.recoveryState != null) {
                    oos.packBoolean(true);
                    oos.packBytes(this.recoveryState);
                } else {
                    oos.packBoolean(false);
                }
            }
        }
        catch (XMLStreamException xmle) {
            WSTLogger.i18NLogger.warn_recovery_participant_ba_BAParticipantRecoveryRecord_saveState_2(this.id, xmle);
            return false;
        }
        catch (IOException ioe) {
            WSTLogger.i18NLogger.warn_recovery_participant_ba_BAParticipantRecoveryRecord_saveState_3(this.id, ioe);
            return false;
        }
        return true;
    }

    @Override
    public boolean restoreState(InputObjectState ios) {
        try {
            this.id = ios.unpackString();
            this.restoreEndpointReference(ios);
            this.recoveryStateValid = ios.unpackBoolean();
            this.isParticipantCompletion = ios.unpackBoolean();
            if (this.recoveryStateValid) {
                this.useSerialization = ios.unpackBoolean();
                this.recoveryState = (byte[])(ios.unpackBoolean() ? ios.unpackBytes() : null);
            }
        }
        catch (XMLStreamException xmle) {
            WSTLogger.i18NLogger.warn_recovery_participant_ba_BAParticipantRecoveryRecord_restoreState_1(this.id, xmle);
            return false;
        }
        catch (IOException ioe) {
            WSTLogger.i18NLogger.warn_recovery_participant_ba_BAParticipantRecoveryRecord_restoreState_2(this.id, ioe);
            return false;
        }
        return true;
    }

    public boolean restoreParticipant(XTSBARecoveryModule module) throws Exception {
        if (this.participant != null) {
            return false;
        }
        if (this.recoveryStateValid) {
            if (this.useSerialization) {
                ByteArrayInputStream bais = new ByteArrayInputStream(this.recoveryState);
                ObjectInputStream ois = new ObjectInputStream(bais);
                this.participant = this.isParticipantCompletion ? module.deserializeParticipantCompletionParticipant(this.getId(), ois) : module.deserializeCoordinatorCompletionParticipant(this.getId(), ois);
            } else {
                this.participant = this.isParticipantCompletion ? module.recreateParticipantCompletionParticipant(this.getId(), this.recoveryState) : module.recreateCoordinatorCompletionParticipant(this.getId(), this.recoveryState);
            }
            return this.participant != null;
        }
        String mesg = WSTLogger.i18NLogger.get_recovery_participant_ba_BAParticipantRecoveryRecord_restoreParticipant_1(this.id);
        throw new Exception(mesg);
    }

    public String getId() {
        return this.id;
    }

    public static String type() {
        return type;
    }

    protected abstract void saveEndpointReference(OutputObjectState var1) throws IOException, XMLStreamException;

    protected abstract void restoreEndpointReference(InputObjectState var1) throws IOException, XMLStreamException;

    public abstract void activate();

    public abstract boolean isActive();
}

