/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.messaging.jms;

import org.jboss.as.controller.AttributeDefinition;
import org.jboss.as.controller.ModelOnlyAddStepHandler;
import org.jboss.as.controller.ModelOnlyResourceDefinition;
import org.jboss.as.controller.OperationFailedException;
import org.jboss.as.controller.PathElement;
import org.jboss.as.controller.PrimitiveListAttributeDefinition;
import org.jboss.as.controller.SimpleAttributeDefinition;
import org.jboss.as.controller.SimpleAttributeDefinitionBuilder;
import org.jboss.as.controller.SimpleListAttributeDefinition;
import org.jboss.as.controller.SimpleMapAttributeDefinition;
import org.jboss.as.controller.registry.AttributeAccess;
import org.jboss.as.messaging.AlternativeAttributeCheckHandler;
import org.jboss.as.messaging.CommonAttributes;
import org.jboss.as.messaging.MessagingExtension;
import org.jboss.as.messaging.jms.ConnectionFactoryAttribute;
import org.jboss.as.messaging.jms.ConnectionFactoryAttributes;
import org.jboss.dmr.ModelNode;

public class PooledConnectionFactoryDefinition
extends ModelOnlyResourceDefinition {
    public static final PathElement PATH = PathElement.pathElement((String)"pooled-connection-factory");
    public static final ConnectionFactoryAttribute[] ATTRIBUTES = PooledConnectionFactoryDefinition.define(ConnectionFactoryAttributes.Pooled.ATTRIBUTES, ConnectionFactoryAttributes.Common.ATTRIBUTES);
    public static final AttributeDefinition[] ATTRIBUTES_ADDED_IN_1_2_0 = new AttributeDefinition[]{ConnectionFactoryAttributes.Pooled.INITIAL_CONNECT_ATTEMPTS, ConnectionFactoryAttributes.Pooled.INITIAL_MESSAGE_PACKET_SIZE, ConnectionFactoryAttributes.Common.COMPRESS_LARGE_MESSAGES, ConnectionFactoryAttributes.Pooled.USE_AUTO_RECOVERY};
    public static final AttributeDefinition[] ATTRIBUTES_WITH_EXPRESSION_ALLOWED_IN_1_2_0 = new AttributeDefinition[]{ConnectionFactoryAttributes.Common.ENTRIES, CommonAttributes.CALL_TIMEOUT, ConnectionFactoryAttributes.Common.AUTO_GROUP, ConnectionFactoryAttributes.Common.BLOCK_ON_ACKNOWLEDGE, ConnectionFactoryAttributes.Common.BLOCK_ON_DURABLE_SEND, ConnectionFactoryAttributes.Common.BLOCK_ON_NON_DURABLE_SEND, ConnectionFactoryAttributes.Common.CACHE_LARGE_MESSAGE_CLIENT, ConnectionFactoryAttributes.Common.CLIENT_FAILURE_CHECK_PERIOD, CommonAttributes.CLIENT_ID, ConnectionFactoryAttributes.Common.CONFIRMATION_WINDOW_SIZE, ConnectionFactoryAttributes.Common.CONNECTION_TTL, ConnectionFactoryAttributes.Common.CONSUMER_MAX_RATE, ConnectionFactoryAttributes.Common.CONSUMER_WINDOW_SIZE, ConnectionFactoryAttributes.Common.DUPS_OK_BATCH_SIZE, ConnectionFactoryAttributes.Common.FAILOVER_ON_INITIAL_CONNECTION, ConnectionFactoryAttributes.Common.GROUP_ID, CommonAttributes.HA, ConnectionFactoryAttributes.Common.MAX_RETRY_INTERVAL, ConnectionFactoryAttributes.Common.MIN_LARGE_MESSAGE_SIZE, ConnectionFactoryAttributes.Common.PRE_ACKNOWLEDGE, ConnectionFactoryAttributes.Common.PRODUCER_MAX_RATE, ConnectionFactoryAttributes.Common.PRODUCER_WINDOW_SIZE, ConnectionFactoryAttributes.Common.RETRY_INTERVAL, ConnectionFactoryAttributes.Common.RETRY_INTERVAL_MULTIPLIER, ConnectionFactoryAttributes.Common.TRANSACTION_BATCH_SIZE, ConnectionFactoryAttributes.Common.USE_GLOBAL_POOLS, ConnectionFactoryAttributes.Pooled.JNDI_PARAMS, ConnectionFactoryAttributes.Pooled.RECONNECT_ATTEMPTS, ConnectionFactoryAttributes.Pooled.SETUP_ATTEMPTS, ConnectionFactoryAttributes.Pooled.SETUP_INTERVAL, ConnectionFactoryAttributes.Pooled.TRANSACTION, ConnectionFactoryAttributes.Pooled.USE_JNDI, ConnectionFactoryAttributes.Pooled.USE_LOCAL_TX};
    public static final PooledConnectionFactoryDefinition INSTANCE = new PooledConnectionFactoryDefinition();

    private static ConnectionFactoryAttribute[] define(ConnectionFactoryAttribute[] specific, ConnectionFactoryAttribute ... common) {
        int size = common.length + specific.length;
        ConnectionFactoryAttribute[] result = new ConnectionFactoryAttribute[size];
        System.arraycopy(specific, 0, result, 0, specific.length);
        for (int i = 0; i < common.length; ++i) {
            ConnectionFactoryAttribute newAttr;
            AttributeDefinition copy;
            ConnectionFactoryAttribute attr = common[i];
            AttributeDefinition definition = attr.getDefinition();
            if (definition == ConnectionFactoryAttributes.Common.RECONNECT_ATTEMPTS) {
                copy = PooledConnectionFactoryDefinition.copy(ConnectionFactoryAttributes.Pooled.RECONNECT_ATTEMPTS, AttributeAccess.Flag.RESTART_ALL_SERVICES);
                newAttr = ConnectionFactoryAttribute.create(copy, "reconnectAttempts", true);
            } else {
                copy = PooledConnectionFactoryDefinition.copy(definition, AttributeAccess.Flag.RESTART_ALL_SERVICES);
                newAttr = ConnectionFactoryAttribute.create(copy, attr.getPropertyName(), attr.isResourceAdapterProperty(), attr.isInboundConfig());
            }
            result[specific.length + i] = newAttr;
        }
        return result;
    }

    private static AttributeDefinition copy(AttributeDefinition attribute, AttributeAccess.Flag flag) {
        SimpleListAttributeDefinition.Builder builder;
        if (attribute instanceof SimpleListAttributeDefinition) {
            builder = new SimpleListAttributeDefinition.Builder((SimpleListAttributeDefinition)attribute);
            builder.setListValidator(attribute.getValidator());
        } else if (attribute instanceof SimpleMapAttributeDefinition) {
            builder = new SimpleMapAttributeDefinition.Builder((SimpleMapAttributeDefinition)attribute);
        } else if (attribute instanceof PrimitiveListAttributeDefinition) {
            builder = new PrimitiveListAttributeDefinition.Builder((PrimitiveListAttributeDefinition)attribute);
            ((PrimitiveListAttributeDefinition.Builder)builder).setListValidator(attribute.getValidator());
        } else {
            builder = new SimpleAttributeDefinitionBuilder((SimpleAttributeDefinition)attribute);
        }
        builder.setFlags(new AttributeAccess.Flag[]{flag});
        return builder.build();
    }

    private PooledConnectionFactoryDefinition() {
        super(PATH, MessagingExtension.getResourceDescriptionResolver("pooled-connection-factory"), new ModelOnlyAddStepHandler(ConnectionFactoryAttribute.getDefinitions(ATTRIBUTES)){

            protected void populateModel(ModelNode operation, ModelNode model) throws OperationFailedException {
                super.populateModel(operation, model);
                AlternativeAttributeCheckHandler.checkAlternatives(operation, ConnectionFactoryAttributes.Common.CONNECTOR.getName(), ConnectionFactoryAttributes.Common.DISCOVERY_GROUP_NAME.getName(), false);
            }
        }, ConnectionFactoryAttribute.getDefinitions(ATTRIBUTES));
        this.setDeprecated(MessagingExtension.DEPRECATED_SINCE);
    }
}

