/*
 * Decompiled with CFR 0.152.
 */
package io.smallrye.jwt.auth.principal;

import io.smallrye.jwt.JsonUtils;
import io.smallrye.jwt.auth.principal.JWTCallerPrincipal;
import io.smallrye.jwt.auth.principal.PrincipalLogging;
import java.util.Collection;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import org.eclipse.microprofile.jwt.Claims;
import org.jose4j.jwt.JwtClaims;
import org.jose4j.jwt.MalformedClaimException;

public class DefaultJWTCallerPrincipal
extends JWTCallerPrincipal {
    private final JwtClaims claimsSet;

    public DefaultJWTCallerPrincipal(String rawToken, String tokenType, JwtClaims claimsSet) {
        super(rawToken, tokenType);
        this.claimsSet = claimsSet;
        this.fixJoseTypes();
    }

    public DefaultJWTCallerPrincipal(String tokenType, JwtClaims claimsSet) {
        this(DefaultJWTCallerPrincipal.getRawToken(claimsSet), tokenType, claimsSet);
    }

    public DefaultJWTCallerPrincipal(JwtClaims claimsSet) {
        this("JWT", claimsSet);
    }

    protected static String getRawToken(JwtClaims claimsSet) {
        Object rawToken = claimsSet.getClaimValue(Claims.raw_token.name());
        return rawToken != null ? rawToken.toString() : null;
    }

    public Set<String> getAudience() {
        LinkedHashSet audSet = null;
        if (this.claimsSet.hasAudience()) {
            try {
                audSet = new LinkedHashSet(this.claimsSet.getAudience());
            }
            catch (MalformedClaimException e) {
                PrincipalLogging.log.getAudienceFailure(e);
            }
        }
        return audSet;
    }

    public Set<String> getGroups() {
        HashSet<String> groups = new HashSet<String>();
        try {
            List globalGroups = this.claimsSet.getStringListClaimValue(Claims.groups.name());
            if (globalGroups != null) {
                groups.addAll(globalGroups);
            }
        }
        catch (MalformedClaimException e) {
            PrincipalLogging.log.getGroupsFailure(e);
        }
        return groups;
    }

    @Override
    protected Collection<String> doGetClaimNames() {
        return this.claimsSet.getClaimNames();
    }

    @Override
    protected Object getClaimValue(String claimName) {
        Claims claimType = this.getClaimType(claimName);
        Object claim = null;
        switch (claimType) {
            case exp: 
            case iat: 
            case auth_time: 
            case nbf: 
            case updated_at: {
                try {
                    claim = this.claimsSet.getClaimValue(claimType.name(), Long.class);
                    if (claim != null) break;
                    claim = 0L;
                }
                catch (MalformedClaimException e) {
                    PrincipalLogging.log.getGroupsFailure(claimName, e);
                }
                break;
            }
            case groups: {
                claim = this.getGroups();
                break;
            }
            case aud: {
                claim = this.getAudience();
                break;
            }
            case UNKNOWN: {
                claim = this.claimsSet.getClaimValue(claimName);
                break;
            }
            default: {
                claim = this.claimsSet.getClaimValue(claimType.name());
            }
        }
        return claim;
    }

    private void fixJoseTypes() {
        if (this.claimsSet.hasClaim(Claims.address.name())) {
            this.replaceClaimValueWithJsonValue(Claims.address.name());
        }
        if (this.claimsSet.hasClaim(Claims.jwk.name())) {
            this.replaceClaimValueWithJsonValue(Claims.jwk.name());
        }
        if (this.claimsSet.hasClaim(Claims.sub_jwk.name())) {
            this.replaceClaimValueWithJsonValue(Claims.sub_jwk.name());
        }
        Set<String> customClaimNames = this.filterCustomClaimNames(this.claimsSet.getClaimNames());
        for (String name : customClaimNames) {
            this.replaceClaimValueWithJsonValue(name);
        }
    }

    protected Set<String> filterCustomClaimNames(Collection<String> claimNames) {
        HashSet<String> customNames = new HashSet<String>(claimNames);
        for (Claims claim : Claims.values()) {
            customNames.remove(claim.name());
        }
        return customNames;
    }

    protected void replaceClaimValueWithJsonValue(String name) {
        try {
            Object object = this.claimsSet.getClaimValue(name, Object.class);
            if (!(object instanceof String)) {
                this.claimsSet.setClaim(name, (Object)JsonUtils.wrapValue(object));
            }
        }
        catch (MalformedClaimException e) {
            PrincipalLogging.log.replaceClaimValueWithJsonFailure(name, e);
        }
    }
}

