/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.modcluster;

import java.io.Serializable;
import java.security.cert.CRLException;
import java.util.Arrays;
import java.util.Locale;
import org.jboss.modcluster.ModClusterMessages;
import org.jboss.modcluster.container.Host;

public class ModClusterMessages_$bundle
implements ModClusterMessages,
Serializable {
    private static final long serialVersionUID = 1L;
    public static final ModClusterMessages_$bundle INSTANCE = new ModClusterMessages_$bundle();
    private static final Locale LOCALE = Locale.ROOT;

    protected ModClusterMessages_$bundle() {
    }

    protected Object readResolve() {
        return INSTANCE;
    }

    protected Locale getLoggingLocale() {
        return LOCALE;
    }

    protected String hostNotFound$str() {
        return "MODCLUSTER000100: Unable to locate host %s";
    }

    @Override
    public final IllegalArgumentException hostNotFound(String host) {
        IllegalArgumentException result = new IllegalArgumentException(String.format(this.getLoggingLocale(), this.hostNotFound$str(), host));
        ModClusterMessages_$bundle._copyStackTraceMinusOne(result);
        return result;
    }

    private static void _copyStackTraceMinusOne(Throwable e) {
        StackTraceElement[] st = e.getStackTrace();
        e.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
    }

    protected String contextNotFound$str() {
        return "MODCLUSTER000101: Unable to locate context %s within %s";
    }

    @Override
    public final IllegalArgumentException contextNotFound(String context, Host host) {
        IllegalArgumentException result = new IllegalArgumentException(String.format(this.getLoggingLocale(), this.contextNotFound$str(), context, host));
        ModClusterMessages_$bundle._copyStackTraceMinusOne(result);
        return result;
    }

    protected String invalidWeight$str() {
        return "MODCLUSTER000102: Load metric weight must be greater than or equal to zero.";
    }

    @Override
    public final IllegalArgumentException invalidWeight() {
        IllegalArgumentException result = new IllegalArgumentException(String.format(this.getLoggingLocale(), this.invalidWeight$str(), new Object[0]));
        ModClusterMessages_$bundle._copyStackTraceMinusOne(result);
        return result;
    }

    protected String invalidCapacity$str() {
        return "MODCLUSTER000103: Load metric capacity must be greater than zero.";
    }

    @Override
    public final IllegalArgumentException invalidCapacity() {
        IllegalArgumentException result = new IllegalArgumentException(String.format(this.getLoggingLocale(), this.invalidCapacity$str(), new Object[0]));
        ModClusterMessages_$bundle._copyStackTraceMinusOne(result);
        return result;
    }

    protected String crlNotSupported$str() {
        return "MODCLUSTER000104: %s algorithm does not support certificate revocation lists.";
    }

    @Override
    public final CRLException crlNotSupported(String algorithm) {
        CRLException result = new CRLException(String.format(this.getLoggingLocale(), this.crlNotSupported$str(), algorithm));
        ModClusterMessages_$bundle._copyStackTraceMinusOne(result);
        return result;
    }
}

