/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.jca.core.security.picketbox;

import java.io.IOException;
import java.io.Serializable;
import java.util.Arrays;
import javax.security.auth.callback.CallbackHandler;
import javax.security.auth.callback.UnsupportedCallbackException;
import org.jboss.jca.core.CoreLogger;
import org.jboss.jca.core.spi.security.Callback;
import org.jboss.logging.Logger;
import org.jboss.security.auth.callback.JASPICallbackHandler;

public class PicketBoxCallbackHandler
implements CallbackHandler,
Serializable {
    private static final long serialVersionUID = 1L;
    private static CoreLogger log = (CoreLogger)Logger.getMessageLogger(CoreLogger.class, (String)PicketBoxCallbackHandler.class.getName());
    private Callback mappings;

    public PicketBoxCallbackHandler() {
        this(null);
    }

    public PicketBoxCallbackHandler(Callback mappings) {
        this.mappings = mappings;
    }

    @Override
    public void handle(javax.security.auth.callback.Callback[] callbacks) throws UnsupportedCallbackException, IOException {
        if (log.isTraceEnabled()) {
            log.tracef("handle(%s)", Arrays.toString(callbacks));
        }
        if (callbacks != null && callbacks.length > 0) {
            if (this.mappings != null && this.mappings.isMappingRequired()) {
                callbacks = this.mappings.mapCallbacks(callbacks);
            }
            JASPICallbackHandler jaspi = new JASPICallbackHandler();
            jaspi.handle(callbacks);
        }
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("PicketBoxCallbackHandler@").append(Integer.toHexString(System.identityHashCode(this)));
        sb.append("[mappings=").append(this.mappings);
        sb.append("]");
        return sb.toString();
    }
}

