/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.ee.security;

import java.security.AccessController;
import java.security.PrivilegedAction;
import org.jboss.modules.Module;
import org.jboss.modules.ModuleClassLoader;
import org.jboss.modules.ModuleIdentifier;
import org.jboss.modules.ModuleLoadException;
import org.jboss.modules.ModuleLoader;
import org.wildfly.security.manager.WildFlySecurityManager;
import org.wildfly.security.manager.action.GetModuleClassLoaderAction;

class SecurityActions {
    SecurityActions() {
    }

    static ModuleClassLoader getModuleClassLoader(String moduleSpec) throws ModuleLoadException {
        ModuleLoader loader = Module.getCallerModuleLoader();
        Module module = loader.loadModule(ModuleIdentifier.fromString((String)moduleSpec));
        GetModuleClassLoaderAction action = new GetModuleClassLoaderAction(module);
        return WildFlySecurityManager.isChecking() ? (ModuleClassLoader)AccessController.doPrivileged(action) : action.run();
    }

    static ClassLoader setThreadContextClassLoader(ClassLoader toSet) {
        return SecurityActions.classLoaderActions().setThreadContextClassLoader(toSet);
    }

    private static ClassLoaderActions classLoaderActions() {
        return WildFlySecurityManager.isChecking() ? ClassLoaderActions.PRIVILEGED : ClassLoaderActions.NON_PRIVILEGED;
    }

    private static interface ClassLoaderActions {
        public static final ClassLoaderActions NON_PRIVILEGED = new ClassLoaderActions(){

            @Override
            public ClassLoader setThreadContextClassLoader(ClassLoader toSet) {
                Thread currentThread = Thread.currentThread();
                ClassLoader previous = currentThread.getContextClassLoader();
                currentThread.setContextClassLoader(toSet);
                return previous;
            }
        };
        public static final ClassLoaderActions PRIVILEGED = new ClassLoaderActions(){

            @Override
            public ClassLoader setThreadContextClassLoader(final ClassLoader toSet) {
                return AccessController.doPrivileged(new PrivilegedAction<ClassLoader>(){

                    @Override
                    public ClassLoader run() {
                        return NON_PRIVILEGED.setThreadContextClassLoader(toSet);
                    }
                });
            }
        };

        public ClassLoader setThreadContextClassLoader(ClassLoader var1);
    }
}

