/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.security.identity.extensions;

import java.security.Principal;
import java.security.acl.Group;
import org.jboss.security.identity.IdentityFactory;
import org.jboss.security.identity.Role;
import org.jboss.security.identity.extensions.CredentialIdentity;

public class CredentialIdentityFactory
extends IdentityFactory {
    public static final CredentialIdentity NULL_IDENTITY = CredentialIdentityFactory.createIdentity(null, null, null);
    private static CredentialIdentityFactory _instance = null;

    protected CredentialIdentityFactory() {
    }

    public static CredentialIdentityFactory getInstance() {
        if (_instance == null) {
            _instance = new CredentialIdentityFactory();
        }
        return _instance;
    }

    public static CredentialIdentity<Object> createIdentity(Principal principal, Object cred) {
        if (principal == null && cred == null) {
            return NULL_IDENTITY;
        }
        return CredentialIdentityFactory.createIdentity(principal, cred, null);
    }

    public static CredentialIdentity<Object> createIdentity(final Principal principal, final Object cred, final Role roles) {
        return new CredentialIdentity<Object>(){
            private static final long serialVersionUID = 1L;

            @Override
            public Object getCredential() {
                return cred;
            }

            @Override
            public void setCredential(Object credential) {
            }

            @Override
            public Group asGroup() {
                return null;
            }

            @Override
            public Principal asPrincipal() {
                return principal;
            }

            @Override
            public String getName() {
                if (principal != null) {
                    return principal.getName();
                }
                return null;
            }

            @Override
            public Role getRole() {
                return roles;
            }

            public int hashCode() {
                int prime = 31;
                int result = 1;
                result = 31 * result + (cred == null ? 0 : cred.hashCode());
                result = 31 * result + (principal == null ? 0 : principal.hashCode());
                result = 31 * result + (roles == null ? 0 : roles.hashCode());
                return result;
            }

            public boolean equals(Object obj) {
                if (this == obj) {
                    return true;
                }
                if (obj == null) {
                    return false;
                }
                if (this.getClass() != obj.getClass()) {
                    return false;
                }
                CredentialIdentity other = (CredentialIdentity)obj;
                if (cred == null ? other.getCredential() != null : !cred.equals(other.getCredential())) {
                    return false;
                }
                if (principal == null ? other.asPrincipal() != null : !principal.equals(other.asPrincipal())) {
                    return false;
                }
                return !(roles == null ? other.getRole() != null : !roles.equals(other.getRole()));
            }

            public String toString() {
                StringBuilder builder = new StringBuilder();
                builder.append("CredentialIdentity[principal=").append(principal);
                builder.append(";roles=").append(roles).append("]");
                return builder.toString();
            }
        };
    }
}

