/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.service;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.Collections;
import java.util.List;
import java.util.ListIterator;
import java.util.concurrent.ExecutorService;
import java.util.function.Consumer;
import java.util.function.Supplier;
import org.jboss.as.server.deployment.SetupAction;
import org.jboss.msc.Service;
import org.jboss.msc.service.LifecycleContext;
import org.jboss.msc.service.StartContext;
import org.jboss.msc.service.StopContext;
import org.wildfly.security.manager.WildFlySecurityManager;

abstract class AbstractService
implements Service {
    protected final Object mBeanInstance;
    private final List<SetupAction> setupActions;
    private final ClassLoader mbeanContextClassLoader;
    private final Consumer<Object> mBeanInstanceConsumer;
    protected final Supplier<ExecutorService> executorSupplier;

    protected AbstractService(Object mBeanInstance, List<SetupAction> setupActions, ClassLoader mbeanContextClassLoader, Consumer<Object> mBeanInstanceConsumer, Supplier<ExecutorService> executorSupplier) {
        this.mBeanInstance = mBeanInstance;
        this.setupActions = setupActions;
        this.mbeanContextClassLoader = mbeanContextClassLoader;
        this.mBeanInstanceConsumer = mBeanInstanceConsumer;
        this.executorSupplier = executorSupplier;
    }

    public void start(StartContext context) {
        this.mBeanInstanceConsumer.accept(this.mBeanInstance);
    }

    public void stop(StopContext context) {
        this.mBeanInstanceConsumer.accept(null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void invokeLifecycleMethod(Method method, LifecycleContext context) throws InvocationTargetException, IllegalAccessException {
        if (method != null) {
            try {
                for (SetupAction action : this.setupActions) {
                    action.setup(Collections.emptyMap());
                }
                ClassLoader old = WildFlySecurityManager.setCurrentContextClassLoaderPrivileged((ClassLoader)this.mbeanContextClassLoader);
                try {
                    method.invoke(this.mBeanInstance, new Object[0]);
                }
                finally {
                    WildFlySecurityManager.setCurrentContextClassLoaderPrivileged((ClassLoader)old);
                }
            }
            finally {
                ListIterator<SetupAction> it = this.setupActions.listIterator(this.setupActions.size());
                while (it.hasPrevious()) {
                    SetupAction action;
                    action = it.previous();
                    action.teardown(Collections.emptyMap());
                }
            }
        }
    }
}

