/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.cli.commands.tools;

import io.airlift.airline.Command;
import io.airlift.airline.Option;
import java.io.File;
import java.io.PrintStream;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.Executor;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ThreadFactory;
import org.apache.activemq.artemis.api.core.ActiveMQBuffer;
import org.apache.activemq.artemis.api.core.ActiveMQBuffers;
import org.apache.activemq.artemis.api.core.SimpleString;
import org.apache.activemq.artemis.cli.Artemis;
import org.apache.activemq.artemis.cli.commands.ActionContext;
import org.apache.activemq.artemis.cli.commands.tools.DBOption;
import org.apache.activemq.artemis.core.config.Configuration;
import org.apache.activemq.artemis.core.journal.Journal;
import org.apache.activemq.artemis.core.journal.RecordInfo;
import org.apache.activemq.artemis.core.message.impl.CoreMessagePersister;
import org.apache.activemq.artemis.core.paging.PagedMessage;
import org.apache.activemq.artemis.core.paging.PagingManager;
import org.apache.activemq.artemis.core.paging.PagingStore;
import org.apache.activemq.artemis.core.paging.PagingStoreFactory;
import org.apache.activemq.artemis.core.paging.cursor.PagePosition;
import org.apache.activemq.artemis.core.paging.cursor.impl.PagePositionImpl;
import org.apache.activemq.artemis.core.paging.impl.Page;
import org.apache.activemq.artemis.core.paging.impl.PageTransactionInfoImpl;
import org.apache.activemq.artemis.core.paging.impl.PagingManagerImpl;
import org.apache.activemq.artemis.core.paging.impl.PagingStoreFactoryNIO;
import org.apache.activemq.artemis.core.persistence.Persister;
import org.apache.activemq.artemis.core.persistence.StorageManager;
import org.apache.activemq.artemis.core.persistence.impl.journal.DescribeJournal;
import org.apache.activemq.artemis.core.persistence.impl.journal.codec.CursorAckRecordEncoding;
import org.apache.activemq.artemis.core.persistence.impl.journal.codec.PageUpdateTXEncoding;
import org.apache.activemq.artemis.core.persistence.impl.nullpm.NullStorageManager;
import org.apache.activemq.artemis.core.server.impl.FileLockNodeManager;
import org.apache.activemq.artemis.core.settings.HierarchicalRepository;
import org.apache.activemq.artemis.core.settings.impl.AddressSettings;
import org.apache.activemq.artemis.core.settings.impl.HierarchicalObjectRepository;
import org.apache.activemq.artemis.spi.core.protocol.MessagePersister;
import org.apache.activemq.artemis.utils.ActiveMQThreadFactory;
import org.apache.activemq.artemis.utils.ExecutorFactory;
import org.apache.activemq.artemis.utils.actors.ArtemisExecutor;

@Command(name="print", description="Print data records information (WARNING: don't use while a production server is running)")
public class PrintData
extends DBOption {
    @Option(name={"--safe"}, description="It will print your data structure without showing your data")
    private boolean safe = false;
    @Option(name={"--reclaimed"}, description="This option will try to print as many records as possible from reclaimed files")
    private boolean reclaimed = false;
    private static final String BINDINGS_BANNER = "B I N D I N G S  J O U R N A L";
    private static final String MESSAGES_BANNER = "M E S S A G E S   J O U R N A L";

    @Override
    public Object execute(ActionContext context) throws Exception {
        super.execute(context);
        Configuration configuration = this.getParameterConfiguration();
        try {
            if (configuration.isJDBC()) {
                this.printDataJDBC(configuration, context.out);
            } else {
                PrintData.printData(new File(this.getBinding()), new File(this.getJournal()), new File(this.getPaging()), context.out, this.safe, this.reclaimed);
            }
        }
        catch (Exception e) {
            this.treatError(e, "data", "print");
        }
        return null;
    }

    public void printDataJDBC(Configuration configuration, PrintStream out) throws Exception {
        this.initializeJournal(configuration);
        Artemis.printBanner(out);
        PrintData.printBanner(out, BINDINGS_BANNER);
        DescribeJournal.printSurvivingRecords((Journal)this.storageManager.getBindingsJournal(), (PrintStream)out, (boolean)this.safe);
        PrintData.printBanner(out, MESSAGES_BANNER);
        DescribeJournal describeJournal = DescribeJournal.printSurvivingRecords((Journal)this.storageManager.getMessageJournal(), (PrintStream)out, (boolean)this.safe);
        PrintData.printPages(describeJournal, (StorageManager)this.storageManager, this.pagingmanager, out, this.safe);
        this.cleanup();
    }

    public static void printData(File bindingsDirectory, File messagesDirectory, File pagingDirectory) throws Exception {
        PrintData.printData(bindingsDirectory, messagesDirectory, pagingDirectory, false);
    }

    public static void printData(File bindingsDirectory, File messagesDirectory, File pagingDirectory, boolean secret) throws Exception {
        PrintData.printData(bindingsDirectory, messagesDirectory, pagingDirectory, System.out, secret, false);
    }

    public static void printData(File bindingsDirectory, File messagesDirectory, File pagingDirectory, PrintStream out, boolean secret) throws Exception {
        PrintData.printData(bindingsDirectory, messagesDirectory, pagingDirectory, out, secret, false);
    }

    public static void printData(File bindingsDirectory, File messagesDirectory, File pagingDirectory, PrintStream out, boolean safe, boolean reclaimed) throws Exception {
        Artemis.printBanner(out);
        File serverLockFile = new File(messagesDirectory, "server.lock");
        if (serverLockFile.isFile()) {
            try {
                FileLockNodeManager fileLock = new FileLockNodeManager(messagesDirectory, false);
                fileLock.start();
                PrintData.printBanner(out, "Server's ID=" + fileLock.getNodeId().toString());
                fileLock.stop();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        PrintData.printBanner(out, BINDINGS_BANNER);
        PrintData.printBindings(bindingsDirectory, out, safe, true, true, reclaimed);
        PrintData.printBanner(out, MESSAGES_BANNER);
        DescribeJournal describeJournal = null;
        describeJournal = PrintData.printMessages(messagesDirectory, out, safe, true, true, reclaimed);
        if (describeJournal == null) {
            return;
        }
        try {
            PrintData.printBanner(out, "P A G I N G");
            PrintData.printPages(pagingDirectory, describeJournal, out, safe);
        }
        catch (Exception e) {
            e.printStackTrace();
            return;
        }
    }

    public static DescribeJournal printMessages(File messagesDirectory, PrintStream out, boolean safe, boolean printRecords, boolean printSurviving, boolean reclaimed) {
        DescribeJournal describeJournal;
        try {
            describeJournal = DescribeJournal.describeMessagesJournal((File)messagesDirectory, (PrintStream)out, (boolean)safe, (boolean)printRecords, (boolean)printSurviving, (boolean)reclaimed);
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
        return describeJournal;
    }

    public static void printBindings(File bindingsDirectory, PrintStream out, boolean safe, boolean printRecords, boolean printSurviving, boolean reclaimed) {
        try {
            DescribeJournal.describeBindingsJournal((File)bindingsDirectory, (PrintStream)out, (boolean)safe, (boolean)printRecords, (boolean)printSurviving, (boolean)reclaimed);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    protected static void printBanner(PrintStream out, String x2) {
        out.println();
        out.println("********************************************");
        out.println(x2);
        out.println("********************************************");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void printPages(File pageDirectory, DescribeJournal describeJournal, PrintStream out, boolean safe) {
        ActiveMQThreadFactory daemonFactory = new ActiveMQThreadFactory("cli", true, PrintData.class.getClassLoader());
        ScheduledExecutorService scheduled = Executors.newScheduledThreadPool(1, (ThreadFactory)daemonFactory);
        final ExecutorService executor = Executors.newFixedThreadPool(10, (ThreadFactory)daemonFactory);
        ExecutorFactory execfactory = new ExecutorFactory(){

            public ArtemisExecutor getExecutor() {
                return ArtemisExecutor.delegate((Executor)executor);
            }
        };
        try {
            NullStorageManager sm = new NullStorageManager();
            PagingStoreFactoryNIO pageStoreFactory = new PagingStoreFactoryNIO((StorageManager)sm, pageDirectory, 1000L, scheduled, execfactory, false, null);
            HierarchicalObjectRepository addressSettingsRepository = new HierarchicalObjectRepository();
            addressSettingsRepository.setDefault((Object)new AddressSettings());
            PagingManagerImpl manager = new PagingManagerImpl((PagingStoreFactory)pageStoreFactory, (HierarchicalRepository)addressSettingsRepository);
            PrintData.printPages(describeJournal, (StorageManager)sm, (PagingManager)manager, out, safe);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        finally {
            executor.shutdownNow();
            scheduled.shutdownNow();
        }
    }

    private static void printPages(DescribeJournal describeJournal, StorageManager sm, PagingManager manager, PrintStream out, boolean safe) throws Exception {
        SimpleString[] stores;
        PageCursorsInfo cursorACKs = PrintData.calculateCursorsInfo(describeJournal.getRecords());
        Set<Long> pgTXs = cursorACKs.getPgTXs();
        manager.start();
        for (SimpleString store : stores = manager.getStoreNames()) {
            PagingStore pgStore = manager.getPageStore(store);
            File folder = null;
            if (pgStore == null) continue;
            folder = pgStore.getFolder();
            out.println("####################################################################################################");
            out.println("Exploring store " + store + " folder = " + folder);
            int pgid = (int)pgStore.getFirstPage();
            for (int pg = 0; pg < pgStore.getNumberOfPages(); ++pg) {
                out.println("*******   Page " + pgid);
                Page page = pgStore.createPage(pgid);
                page.open();
                List msgs = page.read(sm);
                page.close(false, false);
                int msgID = 0;
                for (PagedMessage msg : msgs) {
                    msg.initMessage(sm);
                    if (safe) {
                        try {
                            out.print("pg=" + pgid + ", msg=" + msgID + ",pgTX=" + msg.getTransactionID() + ", msg=" + msg.getMessage().getClass().getSimpleName() + "(safe data, size=" + msg.getMessage().getPersistentSize() + ")");
                        }
                        catch (Exception e) {
                            out.print("pg=" + pgid + ", msg=" + msgID + ",pgTX=" + msg.getTransactionID() + ", msg=" + msg.getMessage().getClass().getSimpleName() + "(safe data)");
                        }
                    } else {
                        out.print("pg=" + pgid + ", msg=" + msgID + ",pgTX=" + msg.getTransactionID() + ",userMessageID=" + (msg.getMessage().getUserID() != null ? msg.getMessage().getUserID() : "") + ", msg=" + msg.getMessage());
                    }
                    out.print(",Queues = ");
                    long[] q = msg.getQueueIDs();
                    for (int i = 0; i < q.length; ++i) {
                        out.print(q[i]);
                        PagePositionImpl posCheck = new PagePositionImpl((long)pgid, msgID);
                        boolean acked = false;
                        Set<PagePosition> positions = cursorACKs.getCursorRecords().get(q[i]);
                        if (positions != null) {
                            acked = positions.contains(posCheck);
                        }
                        if (acked) {
                            out.print(" (ACK)");
                        }
                        if (cursorACKs.getCompletePages(q[i]).contains(pgid)) {
                            out.print(" (PG-COMPLETE)");
                        }
                        if (i + 1 >= q.length) continue;
                        out.print(",");
                    }
                    if (msg.getTransactionID() >= 0L && !pgTXs.contains(msg.getTransactionID())) {
                        out.print(", **PG_TX_NOT_FOUND**");
                    }
                    out.println();
                    ++msgID;
                }
                ++pgid;
            }
        }
    }

    private static PageCursorsInfo calculateCursorsInfo(List<RecordInfo> records) throws Exception {
        PageCursorsInfo cursorInfo = new PageCursorsInfo();
        for (RecordInfo record : records) {
            CursorAckRecordEncoding encoding;
            byte[] data = record.data;
            ActiveMQBuffer buff = ActiveMQBuffers.wrappedBuffer((byte[])data);
            if (record.userRecordType == 39) {
                encoding = new CursorAckRecordEncoding();
                encoding.decode(buff);
                Set<PagePosition> set = cursorInfo.getCursorRecords().get(encoding.queueID);
                if (set == null) {
                    set = new HashSet<PagePosition>();
                    cursorInfo.getCursorRecords().put(encoding.queueID, set);
                }
                set.add(encoding.position);
                continue;
            }
            if (record.userRecordType == 42) {
                encoding = new CursorAckRecordEncoding();
                encoding.decode(buff);
                Long queueID = encoding.queueID;
                Long pageNR = encoding.position.getPageNr();
                if (cursorInfo.getCompletePages(queueID).add(pageNR)) continue;
                System.err.println("Page " + pageNR + " has been already set as complete on queue " + queueID);
                continue;
            }
            if (record.userRecordType != 35) continue;
            if (record.isUpdate) {
                PageUpdateTXEncoding pageUpdate = new PageUpdateTXEncoding();
                pageUpdate.decode(buff);
                cursorInfo.getPgTXs().add(pageUpdate.pageTX);
                continue;
            }
            PageTransactionInfoImpl pageTransactionInfo = new PageTransactionInfoImpl();
            pageTransactionInfo.decode(buff);
            pageTransactionInfo.setRecordID(record.id);
            cursorInfo.getPgTXs().add(pageTransactionInfo.getTransactionID());
        }
        return cursorInfo;
    }

    static {
        MessagePersister.registerPersister((Persister)CoreMessagePersister.getInstance());
    }

    private static class PageCursorsInfo {
        private final Map<Long, Set<PagePosition>> cursorRecords = new HashMap<Long, Set<PagePosition>>();
        private final Set<Long> pgTXs = new HashSet<Long>();
        private final Map<Long, Set<Long>> completePages = new HashMap<Long, Set<Long>>();

        private PageCursorsInfo() {
        }

        Set<Long> getPgTXs() {
            return this.pgTXs;
        }

        Map<Long, Set<PagePosition>> getCursorRecords() {
            return this.cursorRecords;
        }

        Set<Long> getCompletePages(Long queueID) {
            Set<Long> completePagesSet = this.completePages.get(queueID);
            if (completePagesSet == null) {
                completePagesSet = new HashSet<Long>();
                this.completePages.put(queueID, completePagesSet);
            }
            return completePagesSet;
        }
    }
}

