/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.oak.segment.tool;

import java.io.File;
import java.util.Iterator;
import java.util.Objects;
import org.apache.jackrabbit.oak.commons.conditions.Validate;
import org.apache.jackrabbit.oak.segment.file.tar.LocalJournalFile;
import org.apache.jackrabbit.oak.segment.file.tooling.RevisionHistory;
import org.apache.jackrabbit.oak.segment.spi.persistence.JournalFile;

public class History {
    private final File path;
    private final JournalFile journal;
    private final String node;
    private final int depth;

    public static Builder builder() {
        return new Builder();
    }

    private History(Builder builder) {
        this.path = builder.path;
        this.journal = new LocalJournalFile(builder.journal);
        this.node = builder.node;
        this.depth = builder.depth;
    }

    public int run() {
        try {
            this.run(new RevisionHistory(this.path).getHistory(this.journal, this.node));
            return 0;
        }
        catch (Exception e) {
            e.printStackTrace(System.err);
            return 1;
        }
    }

    private void run(Iterator<RevisionHistory.HistoryElement> history) {
        while (history.hasNext()) {
            System.out.println(history.next().toString(this.depth));
        }
    }

    public static class Builder {
        private File path;
        private File journal;
        private String node;
        private int depth;

        private Builder() {
        }

        public Builder withPath(File path) {
            this.path = Objects.requireNonNull(path);
            return this;
        }

        public Builder withJournal(File journal) {
            this.journal = Objects.requireNonNull(journal);
            return this;
        }

        public Builder withNode(String node) {
            this.node = Objects.requireNonNull(node);
            return this;
        }

        public Builder withDepth(int depth) {
            Validate.checkArgument((depth >= 0 ? 1 : 0) != 0);
            this.depth = depth;
            return this;
        }

        public History build() {
            Objects.requireNonNull(this.path);
            Objects.requireNonNull(this.journal);
            Objects.requireNonNull(this.node);
            return new History(this);
        }
    }
}

