/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.oak.segment;

import java.security.SecureRandom;
import java.util.HashSet;
import java.util.Objects;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.jackrabbit.oak.segment.SegmentId;
import org.apache.jackrabbit.oak.segment.SegmentIdFactory;
import org.apache.jackrabbit.oak.segment.SegmentIdProvider;
import org.apache.jackrabbit.oak.segment.SegmentIdTable;
import org.jetbrains.annotations.NotNull;

public class SegmentTracker
implements SegmentIdProvider {
    private static final long MSB_MASK = -61441L;
    private static final long VERSION = 16384L;
    private static final long LSB_MASK = 0xFFFFFFFFFFFFFFFL;
    private static final long DATA = -6917529027641081856L;
    private static final long BULK = -5764607523034234880L;
    @NotNull
    private final SecureRandom random = new SecureRandom();
    @NotNull
    private final SegmentIdTable[] tables = new SegmentIdTable[32];
    @NotNull
    private final AtomicInteger segmentCounter = new AtomicInteger();
    @NotNull
    private final SegmentIdFactory segmentIdFactory;

    public SegmentTracker(@NotNull SegmentIdFactory segmentIdFactory) {
        this.segmentIdFactory = Objects.requireNonNull(segmentIdFactory);
        for (int i = 0; i < this.tables.length; ++i) {
            this.tables[i] = new SegmentIdTable();
        }
    }

    @Override
    public int getSegmentIdCount() {
        return this.segmentCounter.get();
    }

    public synchronized Set<SegmentId> getReferencedSegmentIds() {
        HashSet<SegmentId> ids = new HashSet<SegmentId>();
        for (SegmentIdTable table : this.tables) {
            table.collectReferencedIds(ids);
        }
        return ids;
    }

    @Override
    @NotNull
    public SegmentId newSegmentId(long msb, long lsb) {
        int index = (int)msb & this.tables.length - 1;
        return this.tables[index].newSegmentId(msb, lsb, this.segmentIdFactory);
    }

    @Override
    @NotNull
    public SegmentId newDataSegmentId() {
        return this.newSegmentId(-6917529027641081856L);
    }

    @Override
    @NotNull
    public SegmentId newBulkSegmentId() {
        return this.newSegmentId(-5764607523034234880L);
    }

    @NotNull
    private SegmentId newSegmentId(long type) {
        this.segmentCounter.incrementAndGet();
        long msb = this.random.nextLong() & 0xFFFFFFFFFFFF0FFFL | 0x4000L;
        long lsb = this.random.nextLong() & 0xFFFFFFFFFFFFFFFL | type;
        return this.newSegmentId(msb, lsb);
    }

    public synchronized void clearSegmentIdTables(@NotNull Set<UUID> reclaimed, @NotNull String gcInfo) {
        for (SegmentIdTable table : this.tables) {
            table.clearSegmentIdTables(reclaimed, gcInfo);
        }
    }
}

