/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.social.linkedin.api.impl;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.databind.Module;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.SerializationFeature;
import java.io.IOException;
import java.net.URI;
import java.util.List;
import org.springframework.http.HttpRequest;
import org.springframework.http.client.ClientHttpRequestExecution;
import org.springframework.http.client.ClientHttpRequestFactory;
import org.springframework.http.client.ClientHttpRequestInterceptor;
import org.springframework.http.client.ClientHttpResponse;
import org.springframework.http.converter.HttpMessageConverter;
import org.springframework.http.converter.json.MappingJackson2HttpMessageConverter;
import org.springframework.social.linkedin.api.CommunicationOperations;
import org.springframework.social.linkedin.api.CompanyOperations;
import org.springframework.social.linkedin.api.ConnectionOperations;
import org.springframework.social.linkedin.api.GroupOperations;
import org.springframework.social.linkedin.api.JobOperations;
import org.springframework.social.linkedin.api.LinkedIn;
import org.springframework.social.linkedin.api.NetworkUpdateOperations;
import org.springframework.social.linkedin.api.ProfileOperations;
import org.springframework.social.linkedin.api.impl.CommunicationTemplate;
import org.springframework.social.linkedin.api.impl.CompanyTemplate;
import org.springframework.social.linkedin.api.impl.ConnectionTemplate;
import org.springframework.social.linkedin.api.impl.GroupTemplate;
import org.springframework.social.linkedin.api.impl.JobTemplate;
import org.springframework.social.linkedin.api.impl.JsonFormatHeaderRequestFactory;
import org.springframework.social.linkedin.api.impl.LinkedInErrorHandler;
import org.springframework.social.linkedin.api.impl.NetworkUpdateTemplate;
import org.springframework.social.linkedin.api.impl.ProfileTemplate;
import org.springframework.social.linkedin.api.impl.json.LinkedInModule;
import org.springframework.social.oauth2.AbstractOAuth2ApiBinding;
import org.springframework.social.support.HttpRequestDecorator;
import org.springframework.util.Assert;
import org.springframework.util.ClassUtils;
import org.springframework.web.client.ResponseErrorHandler;
import org.springframework.web.client.RestOperations;
import org.springframework.web.client.RestTemplate;

public class LinkedInTemplate
extends AbstractOAuth2ApiBinding
implements LinkedIn {
    private NetworkUpdateOperations networkUpdateOperations;
    private ProfileOperations profileOperations;
    private ConnectionOperations connectionOperations;
    private CompanyOperations companyOperations;
    private CommunicationOperations communicationOperations;
    private JobOperations jobOperations;
    private GroupOperations groupOperations;
    private ObjectMapper objectMapper;
    private static boolean interceptorsSupported = ClassUtils.isPresent((String)"org.springframework.http.client.ClientHttpRequestInterceptor", (ClassLoader)LinkedInTemplate.class.getClassLoader());
    static final String BASE_URL = "https://api.linkedin.com/v1/people/";

    public LinkedInTemplate(String accessToken) {
        super(accessToken);
        Assert.hasLength((String)accessToken, (String)"Access token cannot be null or empty.");
        this.registerOAuth2Interceptor(accessToken);
        this.registerLinkedInJsonModule();
        this.registerJsonFormatInterceptor();
        this.initSubApis();
    }

    private void registerOAuth2Interceptor(String accessToken) {
        List interceptors = this.getRestTemplate().getInterceptors();
        interceptors.add(new OAuth2TokenParameterRequestInterceptor(accessToken));
        this.getRestTemplate().setInterceptors(interceptors);
    }

    public ConnectionOperations connectionOperations() {
        return this.connectionOperations;
    }

    public NetworkUpdateOperations networkUpdateOperations() {
        return this.networkUpdateOperations;
    }

    public ProfileOperations profileOperations() {
        return this.profileOperations;
    }

    public CompanyOperations companyOperations() {
        return this.companyOperations;
    }

    public CommunicationOperations communicationOperations() {
        return this.communicationOperations;
    }

    public JobOperations jobOperations() {
        return this.jobOperations;
    }

    public GroupOperations groupOperations() {
        return this.groupOperations;
    }

    public RestOperations restOperations() {
        return this.getRestTemplate();
    }

    protected void configureRestTemplate(RestTemplate restTemplate) {
        restTemplate.setErrorHandler((ResponseErrorHandler)new LinkedInErrorHandler());
    }

    private void registerLinkedInJsonModule() {
        List converters = this.getRestTemplate().getMessageConverters();
        for (HttpMessageConverter converter : converters) {
            if (!(converter instanceof MappingJackson2HttpMessageConverter)) continue;
            MappingJackson2HttpMessageConverter jsonConverter = (MappingJackson2HttpMessageConverter)converter;
            this.objectMapper = new ObjectMapper();
            this.objectMapper.registerModule((Module)new LinkedInModule());
            this.objectMapper.configure(SerializationFeature.WRITE_ENUMS_USING_TO_STRING, true);
            this.objectMapper.configure(JsonParser.Feature.ALLOW_NUMERIC_LEADING_ZEROS, true);
            this.objectMapper.setSerializationInclusion(JsonInclude.Include.NON_NULL);
            jsonConverter.setObjectMapper(this.objectMapper);
        }
    }

    private void registerJsonFormatInterceptor() {
        RestTemplate restTemplate = this.getRestTemplate();
        if (interceptorsSupported) {
            List interceptors = restTemplate.getInterceptors();
            interceptors.add(new JsonFormatInterceptor());
        } else {
            ClientHttpRequestFactory originalRequestFactory = restTemplate.getRequestFactory();
            JsonFormatHeaderRequestFactory newRequestFactory = new JsonFormatHeaderRequestFactory(originalRequestFactory);
            restTemplate.setRequestFactory((ClientHttpRequestFactory)newRequestFactory);
        }
    }

    private void initSubApis() {
        this.connectionOperations = new ConnectionTemplate((RestOperations)this.getRestTemplate());
        this.networkUpdateOperations = new NetworkUpdateTemplate((RestOperations)this.getRestTemplate());
        this.profileOperations = new ProfileTemplate((RestOperations)this.getRestTemplate(), this.objectMapper);
        this.companyOperations = new CompanyTemplate((RestOperations)this.getRestTemplate(), this.objectMapper);
        this.communicationOperations = new CommunicationTemplate((RestOperations)this.getRestTemplate());
        this.jobOperations = new JobTemplate((RestOperations)this.getRestTemplate(), this.objectMapper);
        this.groupOperations = new GroupTemplate((RestOperations)this.getRestTemplate());
    }

    private static final class OAuth2TokenParameterRequestInterceptor
    implements ClientHttpRequestInterceptor {
        private final String accessToken;

        public OAuth2TokenParameterRequestInterceptor(String accessToken) {
            this.accessToken = accessToken;
        }

        public ClientHttpResponse intercept(HttpRequest request, byte[] body, ClientHttpRequestExecution execution) throws IOException {
            HttpRequestDecorator protectedResourceRequest = new HttpRequestDecorator(request){

                public URI getURI() {
                    return URI.create(super.getURI().toString() + (super.getURI().getQuery() == null ? "?" : "&") + "oauth2_access_token=" + OAuth2TokenParameterRequestInterceptor.this.accessToken);
                }
            };
            protectedResourceRequest.getHeaders().remove((Object)"Authorization");
            return execution.execute((HttpRequest)protectedResourceRequest, body);
        }
    }

    private static final class JsonFormatInterceptor
    implements ClientHttpRequestInterceptor {
        private JsonFormatInterceptor() {
        }

        public ClientHttpResponse intercept(HttpRequest request, byte[] body, ClientHttpRequestExecution execution) throws IOException {
            HttpRequestDecorator contentTypeResourceRequest = new HttpRequestDecorator(request);
            contentTypeResourceRequest.getHeaders().add("x-li-format", "json");
            return execution.execute((HttpRequest)contentTypeResourceRequest, body);
        }
    }
}

