/*
 * Decompiled with CFR 0.152.
 */
package org.netpreserve.jwarc.tools;

import java.io.IOException;
import java.net.URI;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import org.netpreserve.jwarc.HttpRequest;
import org.netpreserve.jwarc.ParsingException;
import org.netpreserve.jwarc.URIs;
import org.netpreserve.jwarc.WarcCaptureRecord;
import org.netpreserve.jwarc.WarcReader;
import org.netpreserve.jwarc.WarcRecord;
import org.netpreserve.jwarc.WarcRequest;
import org.netpreserve.jwarc.WarcResource;
import org.netpreserve.jwarc.WarcResponse;
import org.netpreserve.jwarc.cdx.CdxFormat;
import org.netpreserve.jwarc.cdx.CdxRequestEncoder;

public class CdxTool {
    public static void main(String[] args) throws IOException {
        boolean printHeader = true;
        boolean postAppend = false;
        CdxFormat cdxFormat = CdxFormat.CDX11;
        ArrayList<Path> files = new ArrayList<Path>();
        for (int i = 0; i < args.length; ++i) {
            if (args[i].startsWith("-")) {
                block14 : switch (args[i]) {
                    case "-f": 
                    case "--format": {
                        String format;
                        switch (format = args[++i]) {
                            case "CDX9": {
                                cdxFormat = CdxFormat.CDX9;
                                break block14;
                            }
                            case "CDX10": {
                                cdxFormat = CdxFormat.CDX10;
                                break block14;
                            }
                            case "CDX11": {
                                cdxFormat = CdxFormat.CDX11;
                                break block14;
                            }
                        }
                        cdxFormat = new CdxFormat(format);
                        break;
                    }
                    case "-h": 
                    case "--help": {
                        System.out.println("Usage: jwarc cdx [--format LEGEND] warc-files...");
                        System.out.println();
                        System.out.println("  -f, --format LEGEND  CDX format may be CDX9, CDX11 or a custom legend");
                        System.out.println("      --no-header      Don't print the CDX header line");
                        return;
                    }
                    case "--no-header": {
                        printHeader = false;
                        break;
                    }
                    case "-p": 
                    case "--post-append": {
                        postAppend = true;
                        break;
                    }
                    default: {
                        System.err.println("Unrecognized option: " + args[i]);
                        System.err.println("Usage: jwarc cdx [--format LEGEND] warc-files...");
                        System.exit(1);
                        return;
                    }
                }
                continue;
            }
            files.add(Paths.get(args[i], new String[0]));
        }
        if (printHeader) {
            System.out.println(" CDX " + cdxFormat.legend());
        }
        for (Path file : files) {
            WarcReader reader = new WarcReader(file);
            Throwable throwable = null;
            try {
                reader.onWarning(System.err::println);
                WarcRecord record = reader.next().orElse(null);
                String filename = file.getFileName().toString();
                while (record != null) {
                    try {
                        if ((record instanceof WarcResponse || record instanceof WarcResource) && ((WarcCaptureRecord)record).payload().isPresent()) {
                            long position = reader.position();
                            WarcCaptureRecord capture = (WarcCaptureRecord)record;
                            URI id = record.version().getProtocol().equals("ARC") ? null : record.id();
                            record = reader.next().orElse(null);
                            long length = reader.position() - position;
                            String urlKey = null;
                            if (postAppend) {
                                while (urlKey == null && record instanceof WarcCaptureRecord && ((WarcCaptureRecord)record).concurrentTo().contains(id)) {
                                    HttpRequest httpRequest;
                                    String encodedRequest;
                                    if (record instanceof WarcRequest && (encodedRequest = CdxRequestEncoder.encode(httpRequest = ((WarcRequest)record).http())) != null) {
                                        String rawUrlKey = capture.target() + (capture.target().contains("?") ? (char)'&' : '?') + encodedRequest;
                                        urlKey = URIs.toNormalizedSurt(rawUrlKey);
                                    }
                                    record = reader.next().orElse(null);
                                }
                            }
                            System.out.println(cdxFormat.format(capture, filename, position, length, urlKey));
                            continue;
                        }
                        record = reader.next().orElse(null);
                    }
                    catch (ParsingException e) {
                        System.err.println("ParsingException at record " + reader.position() + ": " + e.getMessage());
                        record = reader.next().orElse(null);
                    }
                }
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
            finally {
                if (reader == null) continue;
                if (throwable != null) {
                    try {
                        reader.close();
                    }
                    catch (Throwable throwable3) {
                        throwable.addSuppressed(throwable3);
                    }
                    continue;
                }
                reader.close();
            }
        }
    }
}

