/*
 * Decompiled with CFR 0.152.
 */
package org.silverpeas.core.chat.servers;

import java.lang.annotation.Annotation;
import org.silverpeas.core.admin.user.model.User;
import org.silverpeas.core.chat.ChatSettings;
import org.silverpeas.core.chat.ChatUser;
import org.silverpeas.core.chat.servers.DefaultChatServer;
import org.silverpeas.core.util.ServiceProvider;
import org.silverpeas.kernel.util.StringUtil;

public interface ChatServer {
    public static ChatServer get() {
        return (ChatServer)ServiceProvider.getService(ChatServer.class, (Annotation[])new Annotation[]{DefaultChatServer.Literal.INSTANCE});
    }

    public static ChatSettings getChatSettings() {
        return ChatSettings.get();
    }

    public static boolean isEnabled() {
        return ChatServer.getChatSettings().isChatEnabled();
    }

    public void createUser(User var1);

    public void deleteUser(User var1);

    public void createRelationShip(User var1, User var2);

    public void deleteRelationShip(User var1, User var2);

    public boolean isUserExisting(User var1);

    default public boolean isUserDomainSupported(String domainId) {
        ChatSettings settings = ChatServer.getChatSettings();
        return StringUtil.isDefined((String)settings.getMappedXmppDomain(domainId));
    }

    default public boolean isAllowed(User user) {
        ChatUser chatUser = ChatUser.fromUser(user);
        return !user.isAnonymous() && !user.isAccessGuest() && chatUser.isChatEnabled();
    }
}

