/*
 * Decompiled with CFR 0.152.
 */
package com.novell.ldap.rfc2251;

import com.novell.ldap.asn1.ASN1Decoder;
import com.novell.ldap.asn1.ASN1Enumerated;
import com.novell.ldap.asn1.ASN1Identifier;
import com.novell.ldap.asn1.ASN1OctetString;
import com.novell.ldap.asn1.ASN1Sequence;
import com.novell.ldap.asn1.ASN1Tagged;
import com.novell.ldap.rfc2251.RfcLDAPDN;
import com.novell.ldap.rfc2251.RfcLDAPString;
import com.novell.ldap.rfc2251.RfcReferral;
import com.novell.ldap.rfc2251.RfcResponse;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;

public class RfcLDAPResult
extends ASN1Sequence
implements RfcResponse {
    public static final int REFERRAL = 3;

    public RfcLDAPResult(ASN1Enumerated resultCode, RfcLDAPDN matchedDN, RfcLDAPString errorMessage) {
        this(resultCode, matchedDN, errorMessage, null);
    }

    public RfcLDAPResult(ASN1Enumerated resultCode, RfcLDAPDN matchedDN, RfcLDAPString errorMessage, RfcReferral referral) {
        super(4);
        this.add(resultCode);
        this.add(matchedDN);
        this.add(errorMessage);
        if (referral != null) {
            this.add(referral);
        }
    }

    public RfcLDAPResult(ASN1Decoder dec, InputStream in, int len) throws IOException {
        super(dec, in, len);
        ASN1Tagged obj;
        ASN1Identifier id;
        if (this.size() > 3 && (id = (obj = (ASN1Tagged)this.get(3)).getIdentifier()).getTag() == 3) {
            byte[] content = ((ASN1OctetString)obj.taggedValue()).byteValue();
            ByteArrayInputStream bais = new ByteArrayInputStream(content);
            this.set(3, new RfcReferral(dec, bais, content.length));
        }
    }

    public final ASN1Enumerated getResultCode() {
        return (ASN1Enumerated)this.get(0);
    }

    public final RfcLDAPDN getMatchedDN() {
        return new RfcLDAPDN(((ASN1OctetString)this.get(1)).byteValue());
    }

    public final RfcLDAPString getErrorMessage() {
        return new RfcLDAPString(((ASN1OctetString)this.get(2)).byteValue());
    }

    public final RfcReferral getReferral() {
        return this.size() > 3 ? (RfcReferral)this.get(3) : null;
    }
}

