/*
 * Decompiled with CFR 0.152.
 */
package com.sun.portal.container.service;

import com.sun.portal.container.ContainerLogger;
import com.sun.portal.container.service.PortletDescriptorHolder;
import com.sun.portal.container.service.ServiceFinder;
import java.util.logging.Level;
import java.util.logging.LogRecord;
import java.util.logging.Logger;

public class PortletDescriptorHolderFactory {
    private static Logger logger = ContainerLogger.getLogger(PortletDescriptorHolderFactory.class, "CLogMessages");
    private static String DEFAULT_IMPL = "com.sun.portal.portletcontainer.appengine.impl.PortletDescriptorHolderImpl";
    private static PortletDescriptorHolder portletDescriptorHolder = null;

    private PortletDescriptorHolderFactory() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static PortletDescriptorHolder getPortletDescriptorHolder() throws Exception {
        if (portletDescriptorHolder != null) return portletDescriptorHolder;
        Class<PortletDescriptorHolderFactory> clazz = PortletDescriptorHolderFactory.class;
        synchronized (PortletDescriptorHolderFactory.class) {
            if (portletDescriptorHolder != null) return portletDescriptorHolder;
            Object serviceEntry = null;
            try {
                Object implObject = ServiceFinder.getServiceImplementationInstance(PortletDescriptorHolder.class.getName());
                portletDescriptorHolder = implObject != null ? (PortletDescriptorHolder)implObject : (PortletDescriptorHolder)PortletDescriptorHolderFactory.getInstance(DEFAULT_IMPL);
            }
            catch (Exception ex) {
                if (logger.isLoggable(Level.SEVERE)) {
                    LogRecord logRecord = new LogRecord(Level.SEVERE, "PSC_CSPCS008");
                    logRecord.setLoggerName(logger.getName());
                    logRecord.setParameters(new String[]{serviceEntry});
                    logRecord.setThrown(ex);
                    logger.log(logRecord);
                }
                portletDescriptorHolder = (PortletDescriptorHolder)PortletDescriptorHolderFactory.getInstance(DEFAULT_IMPL);
            }
            return portletDescriptorHolder;
        }
    }

    private static Object getInstance(String serviceEntry) throws Exception {
        Class<?> implementationClass = Thread.currentThread().getContextClassLoader().loadClass(serviceEntry);
        return implementationClass.newInstance();
    }
}

