/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.jcetaglib.test;

import java.io.BufferedReader;
import java.io.DataOutputStream;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import junit.framework.Assert;
import junit.framework.TestCase;
import net.sourceforge.jcetaglib.lib.PBECrypt;
import net.sourceforge.jcetaglib.test.RunTest;

public class PBETest
extends TestCase {
    private StringBuffer ciphertext = null;
    private StringBuffer plaintext = null;

    protected void setUp() throws IOException {
        FileOutputStream outStr = new FileOutputStream("C:/tmp/readable.txt");
        DataOutputStream dataStr = new DataOutputStream(outStr);
        dataStr.writeBytes("This is a readable string inside a file");
        dataStr.flush();
        dataStr.close();
        outStr.close();
    }

    public void testPBE() throws Exception {
        for (int i = 0; i < RunTest.pbealg.length; ++i) {
            for (int j = 0; j < RunTest.text.length; ++j) {
                this.ciphertext = PBECrypt.encrypt(RunTest.text[j], new StringBuffer("password"), RunTest.pbealg[i]);
                this.plaintext = PBECrypt.decrypt(this.ciphertext, new StringBuffer("password"), RunTest.pbealg[i]);
                Assert.assertEquals((String)this.plaintext.toString(), (String)RunTest.text[j].toString());
            }
        }
    }

    public void testFilePBE() throws Exception {
        for (int i = 0; i < RunTest.pbealg.length; ++i) {
            int c;
            PBECrypt.encryptFile("C:/tmp/readable.txt", "C:/tmp/readable.txt.encrypted", new StringBuffer("password"), RunTest.pbealg[i]);
            PBECrypt.decryptFile("C:/tmp/readable.txt.encrypted", "C:/tmp/readable.txt.decrypted", new StringBuffer("password"), RunTest.pbealg[i]);
            BufferedReader reader = new BufferedReader(new InputStreamReader(new FileInputStream("C:/tmp/readable.txt.decrypted")));
            StringBuffer line = new StringBuffer();
            while ((c = reader.read()) != -1) {
                line.append((char)c);
            }
            reader.close();
            String t = line.toString();
            Assert.assertEquals((String)"This is a readable string inside a file", (String)t);
        }
    }
}

