/*
 * Decompiled with CFR 0.152.
 */
package org.silverpeas.core.webapi.workflow;

import java.net.URI;
import java.time.LocalDate;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlRootElement;
import org.silverpeas.core.admin.user.model.User;
import org.silverpeas.core.admin.user.model.UserDetail;
import org.silverpeas.core.web.rs.WebEntity;
import org.silverpeas.core.webapi.util.UserEntity;
import org.silverpeas.core.workflow.api.user.Replacement;

@XmlRootElement
@XmlAccessorType(value=XmlAccessType.FIELD)
public class ReplacementEntity
implements WebEntity {
    @XmlElement(nillable=true)
    private URI uri;
    @XmlElement(required=true)
    private UserEntity incumbent;
    @XmlElement(required=true)
    private UserEntity substitute;
    @XmlElement(required=true)
    private String startDate;
    @XmlElement(required=true)
    private String endDate;
    @XmlElement(required=true)
    private String workflowId;

    <T extends Replacement<T>> ReplacementEntity(Replacement<T> replacement) {
        this.incumbent = new UserEntity((User)this.asUserDetail(replacement.getIncumbent()));
        this.substitute = new UserEntity((User)this.asUserDetail(replacement.getSubstitute()));
        this.startDate = replacement.getPeriod().getStartDate().toString();
        this.endDate = replacement.getPeriod().getEndDate().toString();
        this.workflowId = replacement.getWorkflowInstanceId();
    }

    protected ReplacementEntity() {
    }

    public static ReplacementEntity asWebEntity(Replacement<?> replacement, URI uri) {
        ReplacementEntity entity = new ReplacementEntity(replacement);
        entity.uri = uri;
        return entity;
    }

    public URI getURI() {
        return this.uri;
    }

    public UserEntity getIncumbent() {
        return this.incumbent;
    }

    public UserEntity getSubstitute() {
        return this.substitute;
    }

    public LocalDate getStartDate() {
        return LocalDate.parse(this.startDate);
    }

    public LocalDate getEndDate() {
        return LocalDate.parse(this.endDate);
    }

    public String getWorkflowInstanceId() {
        return this.workflowId;
    }

    private UserDetail asUserDetail(org.silverpeas.core.workflow.api.user.User user) {
        return UserDetail.getById((String)user.getUserId());
    }

    public void setSubstitute(org.silverpeas.core.workflow.api.user.User substitute) {
        this.substitute = new UserEntity((User)this.asUserDetail(substitute));
    }

    public void setStartDate(LocalDate date) {
        this.startDate = date.toString();
    }

    public void setEndDate(LocalDate date) {
        this.endDate = date.toString();
    }
}

