/*
 * Decompiled with CFR 0.152.
 */
package org.silverpeas.core.webapi.sharing;

import java.text.ParseException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import javax.ws.rs.Consumes;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.WebApplicationException;
import javax.ws.rs.core.Response;
import org.silverpeas.core.admin.PaginationPage;
import org.silverpeas.core.admin.user.model.User;
import org.silverpeas.core.admin.user.model.UserDetail;
import org.silverpeas.core.annotation.WebService;
import org.silverpeas.core.sharing.model.Ticket;
import org.silverpeas.core.sharing.services.SharingServiceProvider;
import org.silverpeas.core.sharing.services.SharingTicketService;
import org.silverpeas.core.util.CollectionUtil;
import org.silverpeas.core.util.SilverpeasList;
import org.silverpeas.core.web.rs.RESTWebService;
import org.silverpeas.core.web.rs.UserPrivilegeValidation;
import org.silverpeas.core.web.rs.annotation.Authenticated;
import org.silverpeas.core.web.sharing.bean.SharingNotificationVO;
import org.silverpeas.core.web.sharing.notification.FileSharingUserNotification;
import org.silverpeas.core.webapi.sharing.TicketEntity;

@WebService
@Path(value="mytickets")
@Authenticated
public class TicketResource
extends RESTWebService {
    static final String PATH = "mytickets";
    private String componentId = null;

    protected String getResourceBasePath() {
        return PATH;
    }

    public String getComponentId() {
        return this.componentId;
    }

    @GET
    @Produces(value={"application/json"})
    public List<TicketEntity> getMyTickets(@QueryParam(value="page") String page) {
        PaginationPage pagination = this.fromPage(page);
        SilverpeasList sharingTickets = SharingServiceProvider.getSharingTicketService().getTicketsByUser(this.getUser().getId(), pagination, null);
        if (CollectionUtil.isEmpty((Collection)sharingTickets)) {
            throw new WebApplicationException(Response.Status.NOT_FOUND);
        }
        ArrayList<TicketEntity> tickets = new ArrayList<TicketEntity>(sharingTickets.size());
        for (Ticket ticket : sharingTickets) {
            tickets.add(TicketEntity.fromTicket(ticket, this.getUri().getWebResourcePathBuilder().path(ticket.getToken()).build(new Object[0])));
        }
        return tickets;
    }

    @POST
    @Path(value="{componentId}")
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    public Response addTicket(@PathParam(value="componentId") String componentId, TicketEntity ticketEntity) {
        Ticket ticket;
        this.validateUserAuthorizationOn(componentId);
        try {
            ticket = ticketEntity.toTicket(UserDetail.from((User)this.getUser()));
        }
        catch (ParseException e) {
            return Response.serverError().build();
        }
        if (ticket == null) {
            return Response.status((Response.Status)Response.Status.FORBIDDEN).build();
        }
        String keyFile = this.getFileSharingService().createTicket(ticket);
        ticket.setToken(keyFile);
        ticketEntity.setToken(keyFile);
        ticketEntity.setUrl(ticket.getUrl(this.getHttpServletRequest()));
        SharingNotificationVO sharingParam = new SharingNotificationVO(ticketEntity.getUsers(), ticketEntity.getExternalEmails(), ticketEntity.getAdditionalMessage(), ticketEntity.getUrl());
        FileSharingUserNotification.notify(ticket, sharingParam);
        return Response.ok((Object)ticketEntity).build();
    }

    private void validateUserAuthorizationOn(String componentId) {
        this.componentId = componentId;
        UserPrivilegeValidation validation = UserPrivilegeValidation.get();
        this.validateUserAuthorization(validation);
        if (this.getUser().isAnonymous() || this.getUser().isAccessGuest()) {
            throw new WebApplicationException("anonymous or guest user not allowed", Response.Status.FORBIDDEN);
        }
    }

    private SharingTicketService getFileSharingService() {
        return SharingServiceProvider.getSharingTicketService();
    }
}

