/*
 * Decompiled with CFR 0.152.
 */
package org.silverpeas.core.webapi.profile;

import java.lang.annotation.Annotation;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.servlet.ServletContext;
import javax.validation.constraints.NotNull;
import javax.validation.constraints.Size;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlRootElement;
import org.owasp.encoder.Encode;
import org.silverpeas.core.admin.user.constant.UserAccessLevel;
import org.silverpeas.core.admin.user.model.User;
import org.silverpeas.core.admin.user.model.UserDetail;
import org.silverpeas.core.personalization.UserPreferences;
import org.silverpeas.core.ui.DisplayI18NHelper;
import org.silverpeas.core.util.ServiceProvider;
import org.silverpeas.core.util.URLUtil;
import org.silverpeas.core.web.rs.WebEntity;
import org.silverpeas.core.webapi.profile.ProfileResourceBaseURIs;
import org.silverpeas.kernel.util.StringUtil;

@XmlRootElement
@XmlAccessorType(value=XmlAccessType.NONE)
public class UserProfileEntity
extends UserDetail
implements WebEntity {
    private static final long serialVersionUID = -5011846708353591604L;
    private final transient ServletContext context = (ServletContext)ServiceProvider.getService(ServletContext.class, (Annotation[])new Annotation[0]);
    private final UserDetail user;
    @XmlElement(required=true)
    private URI uri;
    @XmlElement
    private URI contactsUri;
    @XmlElement
    private String webPage;
    @XmlElement(required=true)
    @NotNull
    @Size(min=1)
    private @NotNull @Size(min=1) String avatar;
    @XmlElement
    private String domainName;
    @XmlElement(required=true, defaultValue="")
    @NotNull
    private String fullName = "";
    @XmlElement(defaultValue="")
    private String language = "";
    @XmlElement(defaultValue="false")
    private boolean connected = false;
    @XmlElement(defaultValue="false")
    private boolean anonymous = false;
    @XmlElement(defaultValue="false")
    private boolean system = false;

    protected UserProfileEntity() {
        this.user = new UserDetail();
    }

    protected UserProfileEntity(UserDetail user) {
        this.user = user;
        this.system = user.isSystem();
        UserPreferences prefs = this.getUserPreferences();
        this.language = prefs != null ? prefs.getLanguage() : DisplayI18NHelper.getDefaultLanguage();
        this.domainName = user.getDomain() == null ? "" : user.getDomain().getName();
        this.fullName = user.getDisplayedName();
        this.avatar = this.getAvatarURI();
        this.connected = this.user.isConnected();
        this.webPage = this.getUserProfileWebPageURI();
        this.anonymous = user.isAnonymous();
    }

    public static UserProfileEntity fromUser(User user) {
        return new UserProfileEntity(UserDetail.from((User)user));
    }

    public static UserProfileEntity[] fromUsers(List<? extends UserDetail> users, URI usersUri) {
        UserProfileEntity[] selectableUsers = new UserProfileEntity[users.size()];
        String fromUsersUri = usersUri.toString();
        int i = 0;
        for (UserDetail userDetail : users) {
            selectableUsers[i++] = UserProfileEntity.fromUser((User)userDetail).withAsUri(ProfileResourceBaseURIs.uriOfUser(userDetail, fromUsersUri));
        }
        return selectableUsers;
    }

    @XmlElement(required=true)
    public String getId() {
        return this.user.getId();
    }

    @XmlElement(required=true)
    public UserAccessLevel getAccessLevel() {
        return this.user.getAccessLevel();
    }

    @XmlElement
    public String getDomainId() {
        return this.user.getDomainId();
    }

    @XmlElement(required=true)
    public String getFirstName() {
        return this.user.getFirstName();
    }

    @XmlElement(required=true)
    public String getLastName() {
        return this.user.getLastName();
    }

    @XmlElement
    public String getEmailAddress() {
        return Encode.forHtml((String)this.user.getEmailAddress());
    }

    @XmlElement
    public boolean isBlockedState() {
        return this.user.isBlockedState();
    }

    @XmlElement
    public boolean isExpiredState() {
        return this.user.isExpiredState();
    }

    @XmlElement
    public boolean isDeletedState() {
        return this.user.isDeletedState();
    }

    @XmlElement
    public boolean isRemovedState() {
        return this.user.isRemovedState();
    }

    @XmlElement
    public boolean isDeactivatedState() {
        return this.user.isDeactivatedState();
    }

    public String getLanguage() {
        return this.language;
    }

    public void setAccessLevel(UserAccessLevel accessLevel) {
        this.user.setAccessLevel(accessLevel);
    }

    public void setDomainId(String sDomainId) {
        this.user.setDomainId(sDomainId);
        this.domainName = this.user.getDomain().getId();
    }

    public void setFirstName(String sFirstName) {
        this.user.setFirstName(sFirstName);
        this.fullName = this.user.getDisplayedName();
    }

    public void setLastName(String sLastName) {
        this.user.setLastName(sLastName);
        this.fullName = this.user.getDisplayedName();
    }

    public void setEmailAddress(String emailAddress) {
        this.user.setEmailAddress(emailAddress);
    }

    public String getAvatar() {
        if (!StringUtil.isDefined((String)this.avatar)) {
            this.avatar = this.getAvatarURI();
        }
        return this.avatar;
    }

    public String getWebPage() {
        if (!StringUtil.isDefined((String)this.webPage)) {
            this.webPage = this.getUserProfileWebPageURI();
        }
        return this.webPage;
    }

    public String getFullName() {
        return this.fullName;
    }

    public boolean isConnected() {
        return this.connected;
    }

    public String getSpecificId() {
        return this.user.getSpecificId();
    }

    public void setSpecificId(String sSpecificId) {
        this.user.setSpecificId(sSpecificId);
    }

    public String getLogin() {
        return this.user.getLogin();
    }

    public void setLogin(String sLogin) {
        this.user.setLogin(sLogin);
    }

    @XmlElement(defaultValue="")
    public String getStatus() {
        return this.user.getStatus();
    }

    public String getDomainName() {
        return this.domainName;
    }

    public boolean isAnonymous() {
        return this.anonymous;
    }

    public boolean isSystem() {
        return this.system;
    }

    public UserProfileEntity withAsUri(URI userUri) {
        this.uri = userUri;
        try {
            this.contactsUri = new URI(this.uri.toString() + "/contacts");
        }
        catch (URISyntaxException ex) {
            Logger.getLogger(((Object)((Object)this)).getClass().getSimpleName()).log(Level.SEVERE, ex.getMessage(), ex);
        }
        return this;
    }

    public void setId(String id) {
        this.user.setId(id);
    }

    public boolean equals(Object other) {
        if (other instanceof UserProfileEntity) {
            return this.user.equals((Object)((UserProfileEntity)((Object)other)).user);
        }
        return this.user.equals(other);
    }

    public int hashCode() {
        return this.user.hashCode();
    }

    public URI getURI() {
        return this.uri;
    }

    public URI getContactsURI() {
        return this.contactsUri;
    }

    private String getAvatarURI() {
        Object avatarURI = this.user.getSmallAvatar();
        if (this.context != null) {
            avatarURI = this.context.getContextPath() + (String)avatarURI;
        }
        return avatarURI;
    }

    private String getUserProfileWebPageURI() {
        String pageUri = "/Rprofil/jsp/Main?userId=" + this.user.getId();
        pageUri = this.context != null ? this.context.getContextPath() + pageUri : URLUtil.getApplicationURL() + pageUri;
        return pageUri;
    }
}

