/*
 * Decompiled with CFR 0.152.
 */
package org.silverpeas.core.webapi.admin.scim;

import java.lang.annotation.Annotation;
import java.text.MessageFormat;
import java.util.Arrays;
import javax.servlet.http.HttpServletRequest;
import javax.ws.rs.WebApplicationException;
import javax.ws.rs.core.Response;
import org.silverpeas.core.admin.domain.model.Domain;
import org.silverpeas.core.admin.service.AdminController;
import org.silverpeas.core.admin.service.AdminException;
import org.silverpeas.core.admin.service.Administration;
import org.silverpeas.core.admin.user.model.User;
import org.silverpeas.core.util.ServiceProvider;
import org.silverpeas.core.web.WebResourceUri;
import org.silverpeas.core.web.rs.ProtectedWebResource;
import org.silverpeas.core.web.rs.UserPrivilegeValidation;
import org.silverpeas.core.webapi.admin.scim.ScimLogger;
import org.silverpeas.core.webapi.admin.scim.ScimRequestContext;
import org.silverpeas.kernel.util.StringUtil;

public interface ScimProtectedWebResource
extends ProtectedWebResource {
    public ScimRequestContext getSilverpeasContext();

    default public void validateUserAuthorization(UserPrivilegeValidation validation) {
        Domain domain;
        try {
            domain = Administration.get().getDomain(this.getSilverpeasContext().getDomainId());
        }
        catch (AdminException e) {
            throw new WebApplicationException((Throwable)e, Response.Status.NOT_FOUND);
        }
        String authorizedUserIds = domain.getSettings().getString("push.silverpeas.authorized.admin.ids");
        if (StringUtil.isNotDefined((String)authorizedUserIds)) {
            String error = MessageFormat.format("Please verify the variable {0} into SCIM domain property file", "push.silverpeas.authorized.admin.ids");
            ScimLogger.logger().error(error, new Object[0]);
            throw new WebApplicationException(error, Response.Status.FORBIDDEN);
        }
        User currentUser = this.getSilverpeasContext().getUser();
        String currentUserId = currentUser.getId();
        if (Arrays.stream(authorizedUserIds.split("[ ,;]")).noneMatch(i -> i.trim().equals(currentUserId))) {
            String error = MessageFormat.format("user with id {0} is not authorized to accept push from SCIM client {1}", currentUserId, this.getSilverpeasContext().getRequest().getRemoteHost());
            ScimLogger.logger().error(error, new Object[0]);
            throw new WebApplicationException(error, Response.Status.FORBIDDEN);
        }
        if (!currentUser.isAccessAdmin()) {
            String error = MessageFormat.format("user with id {0} must have admin access level", currentUserId);
            ScimLogger.logger().error(error, new Object[0]);
            throw new WebApplicationException(error, Response.Status.FORBIDDEN);
        }
    }

    default public AdminController getAdminController() {
        return (AdminController)ServiceProvider.getService(AdminController.class, (Annotation[])new Annotation[0]);
    }

    default public HttpServletRequest getHttpRequest() {
        return this.getSilverpeasContext().getRequest();
    }

    default public WebResourceUri getUri() {
        return null;
    }

    default public String getComponentId() {
        return null;
    }
}

