/*
 * Decompiled with CFR 0.152.
 */
package org.silverpeas.core.web.mvc.webcomponent;

import java.lang.annotation.Annotation;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.ConcurrentHashMap;
import javax.servlet.http.HttpServletResponse;
import javax.ws.rs.DELETE;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.PUT;
import javax.ws.rs.Produces;
import javax.ws.rs.WebApplicationException;
import javax.ws.rs.core.Response;
import javax.ws.rs.core.UriBuilder;
import org.silverpeas.core.cache.service.CacheAccessorProvider;
import org.silverpeas.core.util.annotation.ClassAnnotationUtil;
import org.silverpeas.core.web.http.HttpRequest;
import org.silverpeas.core.web.mvc.controller.AbstractComponentSessionController;
import org.silverpeas.core.web.mvc.webcomponent.HttpMethodPaths;
import org.silverpeas.core.web.mvc.webcomponent.Navigation;
import org.silverpeas.core.web.mvc.webcomponent.NavigationContext;
import org.silverpeas.core.web.mvc.webcomponent.Path;
import org.silverpeas.core.web.mvc.webcomponent.PathExecutionResponse;
import org.silverpeas.core.web.mvc.webcomponent.ResponseContentProducer;
import org.silverpeas.core.web.mvc.webcomponent.WebComponentController;
import org.silverpeas.core.web.mvc.webcomponent.WebComponentRequestContext;
import org.silverpeas.core.web.mvc.webcomponent.annotation.Homepage;
import org.silverpeas.core.web.mvc.webcomponent.annotation.Invokable;
import org.silverpeas.core.web.mvc.webcomponent.annotation.InvokeAfter;
import org.silverpeas.core.web.mvc.webcomponent.annotation.InvokeBefore;
import org.silverpeas.core.web.mvc.webcomponent.annotation.LowestRoleAccess;
import org.silverpeas.core.web.mvc.webcomponent.annotation.NavigationStep;
import org.silverpeas.core.web.mvc.webcomponent.annotation.RedirectTo;
import org.silverpeas.core.web.mvc.webcomponent.annotation.RedirectToInternal;
import org.silverpeas.core.web.mvc.webcomponent.annotation.RedirectToInternalJsp;
import org.silverpeas.core.web.mvc.webcomponent.annotation.RedirectToNavigationStep;
import org.silverpeas.core.web.mvc.webcomponent.annotation.RedirectToPreviousNavigationStep;
import org.silverpeas.kernel.cache.model.SimpleCache;
import org.silverpeas.kernel.logging.SilverLogger;
import org.silverpeas.kernel.util.StringUtil;

public class WebComponentManager {
    static final Map<String, WebComponentManager> managedWebComponentRouters = new ConcurrentHashMap<String, WebComponentManager>();
    private Path defaultPath = null;
    private final Map<String, HttpMethodPaths> httpMethodPaths = new HashMap<String, HttpMethodPaths>();
    private final Map<String, Method> invokables = new HashMap<String, Method>();

    public static <T extends WebComponentController<R>, R extends WebComponentRequestContext> void manageRequestFor(Class<T> webComponentControllerClass, Class<? extends Annotation> httpMethodClass, HttpRequest request, HttpServletResponse response) {
        SimpleCache cache = CacheAccessorProvider.getThreadCacheAccessor().getCache();
        if (cache.get((Object)WebComponentRequestContext.class.getName()) == null) {
            WebComponentManager webComponentManager = managedWebComponentRouters.get(webComponentControllerClass.getName());
            if (webComponentManager == null) {
                webComponentManager = WebComponentManager.initialize(webComponentControllerClass);
                managedWebComponentRouters.put(webComponentControllerClass.getName(), webComponentManager);
            }
            Class webComponentContextClass = ClassAnnotationUtil.searchParameterizedTypeFrom(WebComponentRequestContext.class, webComponentControllerClass);
            try {
                WebComponentRequestContext webComponentContext = (WebComponentRequestContext)webComponentContextClass.getConstructor(new Class[0]).newInstance(new Object[0]);
                webComponentContext.setHttpMethodClass(httpMethodClass);
                webComponentContext.setRequest(request);
                webComponentContext.setResponse(response);
                cache.put((Object)WebComponentRequestContext.class.getName(), (Object)webComponentContext);
            }
            catch (Exception e) {
                throw new IllegalArgumentException("Constructor (Class, HttpRequest, HttpServletResponse) doesn't exist...", e);
            }
        }
    }

    private static <C> WebComponentManager initialize(Class<C> webComponentControllerClass) {
        WebComponentManager webComponentManager = new WebComponentManager();
        ArrayList<Path> allRegisteredPaths = new ArrayList<Path>();
        for (Method resourceMethod : webComponentControllerClass.getMethods()) {
            Class<?>[] parameterTypes = resourceMethod.getParameterTypes();
            if (parameterTypes.length != 1 || !WebComponentRequestContext.class.isAssignableFrom(parameterTypes[0])) continue;
            LinkedHashSet<Class> httpMethods = new LinkedHashSet<Class>();
            LinkedHashSet<javax.ws.rs.Path> paths = new LinkedHashSet<javax.ws.rs.Path>();
            LowestRoleAccess lowestRoleAccess = null;
            boolean isDefaultPath = false;
            Annotation redirectTo = null;
            Produces produces = null;
            Invokable invokable = null;
            InvokeBefore invokeBefore = null;
            InvokeAfter invokeAfter = null;
            NavigationStep navigationStep = null;
            for (Annotation annotation : resourceMethod.getDeclaredAnnotations()) {
                if (annotation instanceof GET) {
                    httpMethods.add(GET.class);
                    continue;
                }
                if (annotation instanceof POST) {
                    httpMethods.add(POST.class);
                    continue;
                }
                if (annotation instanceof PUT) {
                    httpMethods.add(PUT.class);
                    continue;
                }
                if (annotation instanceof DELETE) {
                    httpMethods.add(DELETE.class);
                    continue;
                }
                if (annotation instanceof javax.ws.rs.Path) {
                    paths.add((javax.ws.rs.Path)annotation);
                    continue;
                }
                if (annotation instanceof NavigationStep) {
                    navigationStep = (NavigationStep)annotation;
                    continue;
                }
                if (annotation instanceof LowestRoleAccess) {
                    if (lowestRoleAccess != null) {
                        throw new IllegalArgumentException("Only one lowest Silverpeas Role must be specified for method: " + resourceMethod.getName());
                    }
                    lowestRoleAccess = (LowestRoleAccess)annotation;
                    continue;
                }
                if (annotation instanceof Homepage) {
                    isDefaultPath = true;
                    continue;
                }
                if (annotation instanceof RedirectTo || annotation instanceof RedirectToInternal || annotation instanceof RedirectToInternalJsp || annotation instanceof RedirectToNavigationStep || annotation instanceof RedirectToPreviousNavigationStep) {
                    if (redirectTo != null) {
                        throw new IllegalArgumentException("One, and only one, redirection must be specified for method " + resourceMethod.getName());
                    }
                    redirectTo = annotation;
                    continue;
                }
                if (annotation instanceof Produces) {
                    produces = (Produces)annotation;
                    String[] toProduce = produces.value();
                    if (toProduce.length == 1 && toProduce[0].equals("application/json")) continue;
                    throw new IllegalArgumentException("@Produces into WebComponentController can just handle application/json data for now (method " + resourceMethod.getName() + ")");
                }
                if (annotation instanceof Invokable) {
                    if (invokable != null) {
                        throw new IllegalArgumentException("@Invokable must be specified one time for method " + resourceMethod.getName());
                    }
                    invokable = (Invokable)annotation;
                    continue;
                }
                if (annotation instanceof InvokeBefore) {
                    if (invokeBefore != null) {
                        throw new IllegalArgumentException("@InvokeBefore must be specified one time for method " + resourceMethod.getName());
                    }
                    invokeBefore = (InvokeBefore)annotation;
                    continue;
                }
                if (!(annotation instanceof InvokeAfter)) continue;
                if (invokeAfter != null) {
                    throw new IllegalArgumentException("@InvokeAfter must be specified one time for method " + resourceMethod.getName());
                }
                invokeAfter = (InvokeAfter)annotation;
            }
            if (!httpMethods.isEmpty()) {
                if (invokable != null) {
                    throw new IllegalArgumentException("Http Method " + resourceMethod.getName() + " can not be annotated with @Invokable");
                }
                int nbOutIndicated = 0;
                if (redirectTo != null) {
                    ++nbOutIndicated;
                }
                if (resourceMethod.getReturnType().isAssignableFrom(Navigation.class)) {
                    ++nbOutIndicated;
                }
                if (produces != null) {
                    ++nbOutIndicated;
                }
                if (nbOutIndicated != 1) {
                    throw new IllegalArgumentException(resourceMethod.getName() + " method must, either return a Navigation instance, either be annotated by @Produces, either be annotated by one of @RedirectTo... annotation");
                }
                for (Class httpMethodClass : httpMethods) {
                    HttpMethodPaths httpMethodPaths = webComponentManager.httpMethodPaths.get(httpMethodClass.getName());
                    if (httpMethodPaths == null) {
                        httpMethodPaths = new HttpMethodPaths(httpMethodClass);
                        webComponentManager.httpMethodPaths.put(httpMethodClass.getName(), httpMethodPaths);
                    }
                    List<Path> registeredPaths = httpMethodPaths.addPaths(paths, lowestRoleAccess, resourceMethod, navigationStep, redirectTo, produces, invokeBefore, invokeAfter);
                    if (isDefaultPath) {
                        if (webComponentManager.defaultPath != null) {
                            throw new IllegalArgumentException("@Homepage is specified several times while it should be once");
                        }
                        webComponentManager.defaultPath = registeredPaths.get(0);
                    }
                    allRegisteredPaths.addAll(registeredPaths);
                }
            }
            if (invokable == null) continue;
            if (webComponentManager.invokables.containsKey(invokable.value())) {
                throw new IllegalArgumentException(invokable.value() + " invokable identifier has already been set");
            }
            webComponentManager.invokables.put(invokable.value(), resourceMethod);
        }
        if (webComponentManager.defaultPath == null) {
            throw new IllegalArgumentException("The homepage method must be specified with @Homepage");
        }
        for (Path path : allRegisteredPaths) {
            for (String invokableIdentifier : path.getInvokeBeforeIdentifiers()) {
                if (webComponentManager.invokables.containsKey(invokableIdentifier)) continue;
                throw new IllegalArgumentException("method behind '" + invokableIdentifier + "' invokable identifier must be performed before the execution of HTTP method " + path.getResourceMethod().getName() + ", but it is not registered");
            }
            for (String invokableIdentifier : path.getInvokeAfterIdentifiers()) {
                if (webComponentManager.invokables.containsKey(invokableIdentifier)) continue;
                throw new IllegalArgumentException("method behind '" + invokableIdentifier + "' invokable identifier must be performed after the execution of HTTP method " + path.getResourceMethod().getName() + ", but it is not registered");
            }
        }
        return webComponentManager;
    }

    public static <T extends WebComponentController<R>, R extends WebComponentRequestContext> PathExecutionResponse perform(T webComponentController, String path) throws Exception {
        WebComponentRequestContext webComponentRequestContext = (WebComponentRequestContext)CacheAccessorProvider.getThreadCacheAccessor().getCache().get((Object)WebComponentRequestContext.class.getName());
        Objects.requireNonNull(webComponentRequestContext).setController(webComponentController);
        if (!((WebComponentController)webComponentController).onCreationCalled) {
            ((WebComponentController)webComponentController).onInstantiation((WebComponentRequestContext)webComponentRequestContext);
            ((WebComponentController)webComponentController).onCreationCalled = true;
        }
        WebComponentManager webComponentManager = managedWebComponentRouters.get(webComponentController.getClass().getName());
        try {
            return webComponentManager.executePath(webComponentController, path, webComponentRequestContext);
        }
        catch (WebApplicationException e) {
            webComponentRequestContext.getResponse().sendError(e.getResponse().getStatus(), e.getMessage());
            throw e;
        }
        catch (InvocationTargetException e) {
            if (e.getTargetException() instanceof WebApplicationException) {
                webComponentRequestContext.getResponse().sendError(((WebApplicationException)e.getTargetException()).getResponse().getStatus());
            }
            throw e;
        }
    }

    private <T extends WebComponentController<R>, R extends WebComponentRequestContext> PathExecutionResponse executePath(T webComponentController, String path, R webComponentContext) throws Exception {
        PathExecutionResponse response;
        Path pathToPerform = null;
        HttpMethodPaths methodPaths = this.httpMethodPaths.get(webComponentContext.isComingFromRedirect() ? GET.class.getName() : webComponentContext.getHttpMethodClass().getName());
        if (methodPaths != null && (pathToPerform = methodPaths.findPath(path, true, webComponentContext)) == null) {
            pathToPerform = methodPaths.findPath(path, false, webComponentContext);
        }
        if (pathToPerform == null) {
            SilverLogger.getLogger((Object)this).error("[{0}] The path ''{1}'' in the URL ''{2}'' for the HTTP method {3} isn''t taken in charge by the controller", new Object[]{((AbstractComponentSessionController)webComponentController).getComponentName(), path, webComponentContext.getRequest().getRequestURI(), webComponentContext.getRequest().getMethod()});
            webComponentContext.getMessager().addError(webComponentContext.getMultilang().getStringWithParams("GML.url.path.notFound", new Object[]{path}), new Object[0]);
            pathToPerform = this.defaultPath;
        }
        webComponentContext.beforeRequestProcessing();
        ((WebComponentController)webComponentController).beforeRequestProcessing(webComponentContext);
        if (pathToPerform == this.defaultPath) {
            webComponentContext.getNavigationContext().clear();
        }
        if (!(pathToPerform.getLowestRoleAccess() == null || webComponentContext.getHighestUserRole() != null && webComponentContext.getHighestUserRole().isGreaterThanOrEquals(pathToPerform.getLowestRoleAccess().value()))) {
            RedirectTo redirectTo = pathToPerform.getLowestRoleAccess().onError();
            if (StringUtil.isNotDefined((String)redirectTo.value())) {
                throw new WebApplicationException("User id " + webComponentContext.getUser().getId() + " has not access right to " + webComponentContext.getRequest().getRequestURI(), Response.Status.FORBIDDEN);
            }
            return PathExecutionResponse.navigateTo(webComponentContext.redirectTo(redirectTo));
        }
        for (String invokeBeforeId : pathToPerform.getInvokeBeforeIdentifiers()) {
            this.invokables.get(invokeBeforeId).invoke(webComponentController, webComponentContext);
        }
        if (pathToPerform.getProduces() != null) {
            ResponseContentProducer.produce(webComponentContext, pathToPerform);
            response = PathExecutionResponse.hasProduced(pathToPerform.getProduces());
        } else if (pathToPerform.getResourceMethod().getReturnType().isAssignableFrom(Navigation.class)) {
            response = PathExecutionResponse.navigateTo((Navigation)pathToPerform.getResourceMethod().invoke(webComponentController, webComponentContext));
        } else {
            pathToPerform.getResourceMethod().invoke(webComponentController, webComponentContext);
            response = PathExecutionResponse.navigateTo(webComponentContext.redirectTo(pathToPerform.getRedirectTo()));
        }
        for (String invokeAfterId : pathToPerform.getInvokeAfterIdentifiers()) {
            this.invokables.get(invokeAfterId).invoke(webComponentController, webComponentContext);
        }
        NavigationContext navigationContext = webComponentContext.getNavigationContext();
        if (response.navigation().isPresent()) {
            NavigationStep navigationStepIdentifier = pathToPerform.getNavigationStep();
            if (navigationStepIdentifier != null) {
                NavigationContext.NavigationStep navigationStep = navigationContext.navigationStepFrom(navigationStepIdentifier.identifier());
                UriBuilder fullUriBuilder = UriBuilder.fromUri((String)webComponentContext.getComponentUriBase()).path(path);
                for (Map.Entry entry : webComponentContext.getRequest().getParameterMap().entrySet()) {
                    fullUriBuilder.queryParam((String)entry.getKey(), (Object[])entry.getValue());
                }
                navigationStep.withFullUri(fullUriBuilder.build(new Object[0]).toString());
                navigationStep.withContextIdentifier(navigationStepIdentifier.contextIdentifier());
            } else {
                navigationContext.noNavigationStep();
            }
            String previousPageFullUri = webComponentContext.getRequest().getParameter("previousPageFullUri");
            if (StringUtil.isDefined((String)previousPageFullUri)) {
                if (!"previousPageFullUri".equals(navigationContext.getPreviousNavigationStep().getIdentifier())) {
                    navigationContext.insertNewPreviousNavigationStep("previousPageFullUri");
                }
                navigationContext.getPreviousNavigationStep().withFullUri(previousPageFullUri);
            }
        }
        webComponentContext.getRequest().setAttribute("navigationContext", (Object)navigationContext);
        return response;
    }
}

