/*
 * Decompiled with CFR 0.152.
 */
package org.silverpeas.core.web.filter;

import java.io.BufferedInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ReadListener;
import javax.servlet.ServletException;
import javax.servlet.ServletInputStream;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.ws.rs.InternalServerErrorException;
import javax.ws.rs.core.UriBuilder;
import org.apache.commons.lang3.time.DurationFormatUtils;
import org.silverpeas.core.admin.user.model.User;
import org.silverpeas.core.cache.service.CacheAccessorProvider;
import org.silverpeas.core.persistence.jdbc.DBUtil;
import org.silverpeas.core.util.URLUtil;
import org.silverpeas.core.util.security.SecuritySettings;
import org.silverpeas.core.web.SilverpeasWebResource;
import org.silverpeas.core.web.filter.exception.WebSecurityException;
import org.silverpeas.core.web.filter.exception.WebSqlInjectionSecurityException;
import org.silverpeas.core.web.filter.exception.WebXssInjectionSecurityException;
import org.silverpeas.core.web.http.HttpRequest;
import org.silverpeas.kernel.annotation.NonNull;
import org.silverpeas.kernel.logging.SilverLogger;
import org.silverpeas.kernel.util.StringUtil;

public class MassiveWebSecurityFilter
implements Filter {
    private static final SilverLogger logger = SilverLogger.getLogger((String)"silverpeas.core.security");
    private static final String WEB_SERVICES_URI_PREFIX = SilverpeasWebResource.getBasePathBuilder().build(new Object[0]).toString();
    private static final String WEB_PAGES_URI_PREFIX = UriBuilder.fromUri((String)URLUtil.getApplicationURL()).path("RwebPages").build(new Object[0]).toString();
    private static final String CMIS_URI_PREFIX = UriBuilder.fromPath((String)URLUtil.getApplicationURL()).path("cmis").build(new Object[0]).toString();
    private static final List<Pattern> SQL_SKIPPED_PARAMETER_PATTERNS;
    private static final List<Pattern> XSS_SKIPPED_PARAMETER_PATTERNS;
    private static final List<Pattern> SQL_PATTERNS;
    private static final List<Pattern> XSS_PATTERNS;
    private static final Pattern ENDS_WITH_WORD_CHARACTER_OR_NUMERIC_PATTERN;
    private static final Pattern SQL_SELECT_FROM_PATTERN;
    private static final Pattern SQL_INSERT_VALUES_PATTERN;
    private static final Pattern SQL_UPDATE_PATTERN;
    private static final Pattern SQL_DELETE_PATTERN;
    private static String sqlSelectPatternInspectDeeplyCacheKey;

    public void doFilter(ServletRequest request, ServletResponse response, FilterChain chain) throws IOException, ServletException {
        HttpRequest httpRequest = MassiveWebSecurityFilter.isWebEntityEmbodiedIn(request) ? BufferedHttpRequest.decorate(request) : HttpRequest.decorate((ServletRequest)request);
        HttpServletResponse httpResponse = (HttpServletResponse)response;
        try {
            this.setDefaultSecurity((HttpServletRequest)httpRequest, httpResponse);
            this.checkSecurity(httpRequest, httpResponse);
            chain.doFilter((ServletRequest)httpRequest, (ServletResponse)httpResponse);
        }
        catch (WebSecurityException wse) {
            logger.error("The request for path {0} (uid={1}) isn''t valid: {2}", new Object[]{this.pathOf((HttpServletRequest)httpRequest), Optional.ofNullable(User.getCurrentRequester()).map(User::getId).orElse("N/A"), wse.getMessage()});
            httpResponse.sendError(403, wse.getMessage());
        }
    }

    private void setDefaultSecurity(HttpServletRequest request, HttpServletResponse response) {
        response.setHeader("X-Content-Type-Options", "nosniff");
        if (request.isSecure() && SecuritySettings.isStrictTransportSecurityEnabled()) {
            response.setHeader("Strict-Transport-Security", "max-age=" + SecuritySettings.getStrictTransportSecurityExpirationTime() + "; preload");
        }
    }

    private void checkSecurity(HttpRequest httpRequest, HttpServletResponse httpResponse) throws WebSqlInjectionSecurityException, WebXssInjectionSecurityException {
        boolean isWebPageMultiPart;
        String requestURI = httpRequest.getRequestURI();
        boolean isCmisService = requestURI.startsWith(CMIS_URI_PREFIX);
        boolean isWebServiceMultipart = requestURI.startsWith(WEB_SERVICES_URI_PREFIX) && httpRequest.isContentInMultipart();
        boolean bl = isWebPageMultiPart = requestURI.startsWith(WEB_PAGES_URI_PREFIX) && httpRequest.isContentInMultipart();
        if (!(isCmisService || isWebServiceMultipart || isWebPageMultiPart)) {
            this.checkWebInjection(httpRequest, httpResponse);
            this.setUpSecurityContentPolicy(httpRequest, httpResponse);
        }
    }

    private void setUpSecurityContentPolicy(HttpRequest httpRequest, HttpServletResponse httpResponse) {
        boolean isCSPEnabled = SecuritySettings.isWebContentInjectionSecurityEnabled();
        if (isCSPEnabled) {
            User currentUser = User.getCurrentRequester();
            String secure = " https: " + (httpRequest.isSecure() ? "spwebdavs: " : "spwebdav: ");
            String ws = " " + URLUtil.getCurrentServerURL().replaceFirst("^http", "ws") + " ";
            String font = currentUser == null ? "" : "; font-src * data:";
            String img2 = currentUser == null ? "" : "; img-src * data: blob:";
            httpResponse.setHeader("Content-Security-Policy", "default-src 'self' blob: mailto: " + secure + ws + SecuritySettings.getAllowedDefaultSourcesInCSP() + font + img2 + "; script-src 'self' blob: 'unsafe-inline' 'unsafe-eval' " + secure + SecuritySettings.getAllowedScriptSourcesInCSP() + "; style-src 'self' 'unsafe-inline' " + secure + SecuritySettings.getAllowedStyleSourcesInCSP() + "; style-src-elem 'self' blob: 'unsafe-inline' " + SecuritySettings.getAllowedStyleSourcesInCSP());
        }
    }

    private void checkWebInjection(HttpRequest httpRequest, HttpServletResponse httpResponse) throws WebSqlInjectionSecurityException, WebXssInjectionSecurityException {
        boolean isWebSqlInjectionSecurityEnabled = SecuritySettings.isWebSqlInjectionSecurityEnabled();
        boolean isWebXssInjectionSecurityEnabled = SecuritySettings.isWebXssInjectionSecurityEnabled();
        if (isWebSqlInjectionSecurityEnabled || isWebXssInjectionSecurityEnabled) {
            if (isWebXssInjectionSecurityEnabled) {
                httpResponse.setHeader("X-XSS-Protection", "1");
            }
            this.checkRequestEntityForInjection(httpRequest);
            this.checkRequestParametersForInjection(httpRequest, isWebSqlInjectionSecurityEnabled, isWebXssInjectionSecurityEnabled);
        }
    }

    private void checkRequestEntityForInjection(HttpRequest request) throws WebSqlInjectionSecurityException, WebXssInjectionSecurityException {
        long start = System.currentTimeMillis();
        try {
            boolean hasSupportedWebEntity = MassiveWebSecurityFilter.isWebEntityEmbodiedIn((ServletRequest)request);
            if (hasSupportedWebEntity) {
                String charset = request.getCharacterEncoding() == null ? "UTF-8" : request.getCharacterEncoding();
                ServletInputStream body2 = request.getInputStream();
                if (body2.markSupported()) {
                    body2.mark(Integer.MAX_VALUE);
                    String entity = new String(body2.readAllBytes(), charset);
                    this.checkValueForInjection(entity, true, true);
                    body2.reset();
                }
            }
        }
        catch (IOException e) {
            throw new InternalServerErrorException((Throwable)e);
        }
        finally {
            long end = System.currentTimeMillis();
            logger.debug("Massive Web Security Verify on request entity: " + DurationFormatUtils.formatDurationHMS((long)(end - start)), new Object[0]);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void checkRequestParametersForInjection(HttpRequest httpRequest, boolean isWebSqlInjectionSecurityEnabled, boolean isWebXssInjectionSecurityEnabled) throws WebSqlInjectionSecurityException, WebXssInjectionSecurityException {
        long start = System.currentTimeMillis();
        try {
            for (Map.Entry<String, String[]> entry : httpRequest.getParameterMap().entrySet()) {
                boolean xssInjectionToVerify;
                boolean sqlInjectionToVerify = isWebSqlInjectionSecurityEnabled && this.mustTheParameterBeVerifiedForSqlVerifications((String)entry.getKey());
                boolean bl = xssInjectionToVerify = isWebXssInjectionSecurityEnabled && this.mustTheParameterBeVerifiedForXssVerifications((String)entry.getKey());
                if (!sqlInjectionToVerify && !xssInjectionToVerify) continue;
                this.checkParameterValues(entry, sqlInjectionToVerify, xssInjectionToVerify);
            }
        }
        finally {
            long end = System.currentTimeMillis();
            logger.debug("Massive Web Security Verify on request parameters: " + DurationFormatUtils.formatDurationHMS((long)(end - start)), new Object[0]);
        }
    }

    private void checkParameterValues(Map.Entry<String, String[]> parameterEntry, boolean sqlInjectionToVerify, boolean xssInjectionToVerify) throws WebSqlInjectionSecurityException, WebXssInjectionSecurityException {
        for (String parameterValue : parameterEntry.getValue()) {
            this.checkValueForInjection(parameterValue, sqlInjectionToVerify, xssInjectionToVerify);
        }
    }

    private void checkValueForInjection(String value, boolean sqlInjectionToVerify, boolean xssInjectionToVerify) throws WebSqlInjectionSecurityException, WebXssInjectionSecurityException {
        Matcher patternMatcherFound;
        value = value.replaceAll("\\s+", " ");
        if (sqlInjectionToVerify && (patternMatcherFound = this.findPatternMatcherFromString(SQL_PATTERNS, value, true)) != null) {
            if (!this.verifySqlDeeply(patternMatcherFound, value)) {
                patternMatcherFound = null;
            }
            if (patternMatcherFound != null) {
                throw new WebSqlInjectionSecurityException();
            }
        }
        if (xssInjectionToVerify && this.findPatternMatcherFromString(XSS_PATTERNS, value, false) != null) {
            throw new WebXssInjectionSecurityException();
        }
    }

    private boolean verifySqlDeeply(Matcher matcherFound, String statement) {
        boolean isVerified;
        block1: {
            isVerified = true;
            if (matcherFound.pattern() != SQL_SELECT_FROM_PATTERN && matcherFound.pattern() != SQL_INSERT_VALUES_PATTERN && matcherFound.pattern() != SQL_UPDATE_PATTERN && matcherFound.pattern() != SQL_DELETE_PATTERN) break block1;
            isVerified = false;
            Pattern tableNamesPattern = this.getSqlTableNamesPattern();
            Matcher tableNameMatcher = tableNamesPattern.matcher(statement);
            while (tableNameMatcher.find() && !(isVerified = tableNamesPattern.matcher(this.extractTableNameWholeWord(tableNameMatcher, statement)).matches())) {
            }
        }
        return isVerified;
    }

    private String extractTableNameWholeWord(Matcher matcher, String matchedString) {
        int index;
        StringBuilder tableName = new StringBuilder(matchedString.substring(matcher.start(), matcher.end()));
        for (index = matcher.start() - 1; index >= 0 && ENDS_WITH_WORD_CHARACTER_OR_NUMERIC_PATTERN.matcher(String.valueOf(matchedString.charAt(index))).matches(); --index) {
            tableName.insert(0, matchedString.charAt(index));
        }
        for (index = matcher.end(); index < matchedString.length() && ENDS_WITH_WORD_CHARACTER_OR_NUMERIC_PATTERN.matcher(String.valueOf(matchedString.charAt(index))).matches(); ++index) {
            tableName.append(matchedString.charAt(index));
        }
        return tableName.toString();
    }

    private synchronized Pattern getSqlTableNamesPattern() {
        Pattern pattern;
        Pattern pattern2 = pattern = sqlSelectPatternInspectDeeplyCacheKey != null ? (Pattern)CacheAccessorProvider.getApplicationCacheAccessor().getCache().get((Object)sqlSelectPatternInspectDeeplyCacheKey, Pattern.class) : null;
        if (pattern == null) {
            StringBuilder sbPattern = new StringBuilder("(");
            for (String tableName : DBUtil.getAllTableNames()) {
                if (sbPattern.length() > 1) {
                    sbPattern.append("|");
                }
                sbPattern.append(tableName);
            }
            sbPattern.append(")");
            pattern = Pattern.compile("(?i)" + sbPattern);
            sqlSelectPatternInspectDeeplyCacheKey = CacheAccessorProvider.getApplicationCacheAccessor().getCache().add((Object)pattern);
        }
        return pattern;
    }

    private boolean mustTheParameterBeVerifiedForSqlVerifications(String parameterName) {
        return this.findPatternMatcherFromString(SQL_SKIPPED_PARAMETER_PATTERNS, parameterName, false) == null;
    }

    private boolean mustTheParameterBeVerifiedForXssVerifications(String parameterName) {
        return this.findPatternMatcherFromString(XSS_SKIPPED_PARAMETER_PATTERNS, parameterName, false) == null;
    }

    private Matcher findPatternMatcherFromString(List<Pattern> patterns, String string, boolean startsAndEndsByWholeWord) {
        Matcher isMatcherFound = null;
        for (Pattern pattern : patterns) {
            Matcher matcher = pattern.matcher(string);
            if (!matcher.find() || startsAndEndsByWholeWord && (!this.verifyMatcherStartingByAWord(matcher, string) || !this.verifyMatcherEndingByAWord(matcher, string))) continue;
            isMatcherFound = matcher;
            break;
        }
        return isMatcherFound;
    }

    private boolean verifyMatcherStartingByAWord(Matcher matcher, String matchedString) {
        return matcher.start() == 0 || !ENDS_WITH_WORD_CHARACTER_OR_NUMERIC_PATTERN.matcher(matchedString.substring(0, matcher.start())).find();
    }

    private boolean verifyMatcherEndingByAWord(Matcher matcher, String matchedString) {
        return matcher.end(0) == matchedString.length() || !ENDS_WITH_WORD_CHARACTER_OR_NUMERIC_PATTERN.matcher(String.valueOf(matchedString.charAt(matcher.end(0)))).find();
    }

    private String pathOf(HttpServletRequest request) {
        return request.getRequestURI();
    }

    public void init(FilterConfig filterConfig) throws ServletException {
    }

    public void destroy() {
    }

    private static boolean isWebEntityEmbodiedIn(ServletRequest request) {
        String contentType = request.getContentType();
        if (StringUtil.isDefined((String)contentType)) {
            return (contentType = contentType.toLowerCase()).contains("json") || contentType.contains("xml");
        }
        return false;
    }

    static {
        ENDS_WITH_WORD_CHARACTER_OR_NUMERIC_PATTERN = Pattern.compile("(?ui)[a-z\\d\\-_\u00e9\u00e8\u00e7\u00e0\u00eb\u00e4\u00fc\u00ef\u00f6\u00e2\u00ea\u00fb\u00ee\u00f4\u00b5\u00f9]$");
        SQL_SELECT_FROM_PATTERN = Pattern.compile("(?i)select.*from");
        SQL_INSERT_VALUES_PATTERN = Pattern.compile("(?i)insert.*into.*values");
        SQL_UPDATE_PATTERN = Pattern.compile("(?i)update.*set");
        SQL_DELETE_PATTERN = Pattern.compile("(?i)delete.*from");
        sqlSelectPatternInspectDeeplyCacheKey = null;
        SQL_SKIPPED_PARAMETER_PATTERNS = new ArrayList<Pattern>(1);
        if (StringUtil.isDefined((String)SecuritySettings.skippedParametersAboutWebSqlInjectionSecurity())) {
            SQL_SKIPPED_PARAMETER_PATTERNS.add(Pattern.compile(SecuritySettings.skippedParametersAboutWebSqlInjectionSecurity()));
        }
        XSS_SKIPPED_PARAMETER_PATTERNS = new ArrayList<Pattern>(1);
        if (StringUtil.isDefined((String)SecuritySettings.skippedParametersAboutWebXssInjectionSecurity())) {
            XSS_SKIPPED_PARAMETER_PATTERNS.add(Pattern.compile(SecuritySettings.skippedParametersAboutWebXssInjectionSecurity()));
        }
        SQL_PATTERNS = new ArrayList<Pattern>(6);
        SQL_PATTERNS.add(Pattern.compile("(?i)grant(([\\s/*]+.*\\s*)(select|insert|update|delete))+([\\s/*]+.*\\s*)on([\\s/*]+.*\\s*)to"));
        SQL_PATTERNS.add(Pattern.compile("(?i)revoke(([\\s/*]+.*\\s*)(select|insert|update|delete))+([\\s/*]+.*\\s*)on([\\s/*]+.*\\s*)from"));
        SQL_PATTERNS.add(Pattern.compile("(?i)grant(([\\s/*]+.*\\s*)(references|alter|index|all))+([\\s/*]+.*\\s*)on([\\s/*]+.*\\s*)to"));
        SQL_PATTERNS.add(Pattern.compile("(?i)revoke(([\\s/*]+.*\\s*)(references|alter|index|all))+([\\s/*]+.*\\s*)on([\\s/*]+.*\\s*)from"));
        SQL_PATTERNS.add(Pattern.compile("(?i)(create|drop|alter)([\\s/*]+.*\\s*)(table|database|schema)"));
        SQL_PATTERNS.add(SQL_SELECT_FROM_PATTERN);
        SQL_PATTERNS.add(SQL_INSERT_VALUES_PATTERN);
        SQL_PATTERNS.add(SQL_UPDATE_PATTERN);
        SQL_PATTERNS.add(SQL_DELETE_PATTERN);
        XSS_PATTERNS = new ArrayList<Pattern>(1);
        XSS_PATTERNS.add(Pattern.compile("(?i)<[\\s/]*(script|iframe)"));
    }

    private static class BufferedHttpRequest
    extends HttpRequest {
        private BufferedServletInputStream input;

        public static HttpRequest decorate(ServletRequest request) {
            if (request instanceof BufferedHttpRequest) {
                return (BufferedHttpRequest)request;
            }
            if (request instanceof HttpRequest) {
                return new BufferedHttpRequest((HttpRequest)request);
            }
            return HttpRequest.decorate((HttpServletRequest)new BufferedHttpRequest(request));
        }

        private BufferedHttpRequest(ServletRequest request) {
            super((HttpServletRequest)request);
        }

        private BufferedHttpRequest(HttpRequest request) {
            super(request);
        }

        public ServletInputStream getInputStream() throws IOException {
            if (this.input == null) {
                this.input = new BufferedServletInputStream(super.getInputStream());
            }
            return this.input;
        }

        private static class BufferedServletInputStream
        extends ServletInputStream {
            private final ServletInputStream inputStream;
            private final BufferedInputStream buffer;

            private BufferedServletInputStream(ServletInputStream inputStream) {
                this.inputStream = inputStream;
                this.buffer = new BufferedInputStream((InputStream)inputStream);
            }

            public boolean isFinished() {
                return this.inputStream.isFinished();
            }

            public boolean isReady() {
                return this.inputStream.isReady();
            }

            public void setReadListener(ReadListener readListener) {
                this.inputStream.setReadListener(readListener);
            }

            public int read() throws IOException {
                return this.buffer.read();
            }

            public int read(@NonNull byte[] b, int off, int len) throws IOException {
                return this.buffer.read(b, off, len);
            }

            public long skip(long n) throws IOException {
                return this.buffer.skip(n);
            }

            public int available() throws IOException {
                return this.buffer.available();
            }

            public synchronized void mark(int readLimit) {
                this.buffer.mark(readLimit);
            }

            public synchronized void reset() throws IOException {
                this.buffer.reset();
            }

            public boolean markSupported() {
                return this.buffer.markSupported();
            }

            public void close() throws IOException {
                this.buffer.close();
            }

            public int read(@NonNull byte[] b) throws IOException {
                return this.buffer.read(b);
            }

            public byte[] readAllBytes() throws IOException {
                return this.buffer.readAllBytes();
            }

            public byte[] readNBytes(int len) throws IOException {
                return this.buffer.readNBytes(len);
            }

            public int readNBytes(byte[] b, int off, int len) throws IOException {
                return this.buffer.readNBytes(b, off, len);
            }

            public long transferTo(OutputStream out) throws IOException {
                return this.buffer.transferTo(out);
            }
        }
    }
}

