/*
 * Decompiled with CFR 0.152.
 */
package com.sun.portal.portletcontainer.invoker.util;

import com.sun.portal.container.ChannelMode;
import com.sun.portal.container.ChannelState;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class PortletWindowRules {
    public static final int MINIMIZE = 1;
    public static final int NORMAL = 2;
    public static final int MAXIMIZE = 3;
    public static final int NOT_DEFINED = -1;
    private static final Map<Integer, ChannelState> windowStateMap = PortletWindowRules.getWindowStateMap();
    private static final Map<ChannelState, Integer> windowStateReverseMap = PortletWindowRules.getWindowStateReverseMap();
    private static List<ChannelMode> portletWindowModeALL = new ArrayList<ChannelMode>();
    private static List<ChannelMode> portletWindowModeV = new ArrayList<ChannelMode>();
    private static List<ChannelState> windowStateMN = new ArrayList<ChannelState>();
    private static List<ChannelState> windowStateALL = new ArrayList<ChannelState>();

    private static Map<Integer, ChannelState> getWindowStateMap() {
        HashMap<Integer, ChannelState> windowStateMap = new HashMap<Integer, ChannelState>();
        windowStateMap.put(1, ChannelState.MINIMIZED);
        windowStateMap.put(3, ChannelState.MAXIMIZED);
        windowStateMap.put(2, ChannelState.NORMAL);
        return windowStateMap;
    }

    private static Map<ChannelState, Integer> getWindowStateReverseMap() {
        HashMap<ChannelState, Integer> windowStateReverseMap = new HashMap<ChannelState, Integer>();
        windowStateReverseMap.put(ChannelState.MINIMIZED, 1);
        windowStateReverseMap.put(ChannelState.MAXIMIZED, 3);
        windowStateReverseMap.put(ChannelState.NORMAL, 2);
        return windowStateReverseMap;
    }

    public static List<ChannelMode> getAllowablePortletWindowModes(ChannelMode mode, boolean authless) {
        if (mode == null) {
            throw new IllegalArgumentException("mode passed is null in getAllowablePortletWindowModes.");
        }
        if (authless) {
            if (mode.equals((Object)ChannelMode.VIEW)) {
                return portletWindowModeV;
            }
            if (mode.equals((Object)ChannelMode.EDIT)) {
                throw new AssertionError((Object)"Authless should not be in edit mode ever.");
            }
        }
        return portletWindowModeALL;
    }

    public static List<ChannelState> getDefaultAllowableWindowStates(ChannelMode mode) {
        if (mode == null) {
            throw new RuntimeException("mode passed is null in getAllowableWindowStates.");
        }
        if (mode.equals((Object)ChannelMode.VIEW)) {
            return windowStateALL;
        }
        if (mode.equals((Object)ChannelMode.EDIT)) {
            return windowStateMN;
        }
        if (mode.equals((Object)ChannelMode.HELP)) {
            return windowStateMN;
        }
        return null;
    }

    public static boolean validateWindowStateChange(ChannelMode portletWindowMode, ChannelState windowState) {
        boolean validState = true;
        if (portletWindowMode == null || windowState == null) {
            return true;
        }
        if ((portletWindowMode.equals((Object)ChannelMode.EDIT) || portletWindowMode.equals((Object)ChannelMode.HELP)) && windowState.equals((Object)ChannelState.MINIMIZED)) {
            validState = false;
        }
        return validState;
    }

    public static List<ChannelState> mapToStandards(int[] portalWindowStates) {
        ArrayList<ChannelState> newList = new ArrayList<ChannelState>();
        for (int i = 0; portalWindowStates != null && i < portalWindowStates.length; ++i) {
            ChannelState winState = windowStateMap.get(portalWindowStates[i]);
            if (winState == null) continue;
            newList.add(winState);
        }
        return newList;
    }

    public static ChannelState mapToStandards(int portalWindowState) {
        ChannelState winState = windowStateMap.get(portalWindowState);
        return winState;
    }

    public static int mapToPortletWindow(ChannelState windowState) {
        int winState = windowStateReverseMap.get(windowState);
        return winState;
    }

    public static ChannelState getDefaultWindowState(ChannelMode portletWindowMode) {
        if (ChannelMode.VIEW.equals((Object)portletWindowMode)) {
            return ChannelState.NORMAL;
        }
        if (ChannelMode.HELP.equals((Object)portletWindowMode)) {
            return ChannelState.MAXIMIZED;
        }
        if (ChannelMode.EDIT.equals((Object)portletWindowMode)) {
            return ChannelState.MAXIMIZED;
        }
        return ChannelState.NORMAL;
    }

    static {
        portletWindowModeALL.add(ChannelMode.VIEW);
        portletWindowModeALL.add(ChannelMode.EDIT);
        portletWindowModeALL.add(ChannelMode.HELP);
        portletWindowModeV.add(ChannelMode.VIEW);
        windowStateMN.add(ChannelState.MAXIMIZED);
        windowStateMN.add(ChannelState.NORMAL);
        windowStateALL.add(ChannelState.NORMAL);
        windowStateALL.add(ChannelState.MAXIMIZED);
        windowStateALL.add(ChannelState.MINIMIZED);
    }
}

