/*
 * Decompiled with CFR 0.152.
 */
package com.sun.portal.portletcontainer.admin.registry;

import com.sun.portal.portletcontainer.admin.PortletRegistryElement;
import com.sun.portal.portletcontainer.admin.PortletRegistryHelper;
import com.sun.portal.portletcontainer.admin.PortletRegistryObject;
import com.sun.portal.portletcontainer.admin.PortletRegistryWriter;
import com.sun.portal.portletcontainer.admin.registry.PortletAppRegistryContext;
import com.sun.portal.portletcontainer.admin.registry.PortletAppRegistryReader;
import com.sun.portal.portletcontainer.admin.registry.PortletAppRegistryWriter;
import com.sun.portal.portletcontainer.context.registry.PortletRegistryException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class PortletAppRegistryContextImpl
implements PortletAppRegistryContext {
    PortletRegistryObject portletAppRegistry;

    public PortletAppRegistryContextImpl() throws PortletRegistryException {
        String registryLocation = PortletRegistryHelper.getRegistryLocation();
        PortletAppRegistryReader portletAppRegistryReader = new PortletAppRegistryReader(registryLocation);
        this.portletAppRegistry = portletAppRegistryReader.readDocument();
    }

    @Override
    public List<String> getMarkupTypes(String portletName) throws PortletRegistryException {
        PortletRegistryElement portletRegistryElement = this.getRegistryElement(portletName);
        Map<String, Object> map = portletRegistryElement.getCollectionProperty("supportedContentTypes");
        List<String> markupTypes = null;
        if (map != null) {
            markupTypes = this.mapValuesToList(map);
        }
        return markupTypes;
    }

    @Override
    public String getDescription(String portletName, String desiredLocale) throws PortletRegistryException {
        PortletRegistryElement portletRegistryElement = this.getRegistryElement(portletName);
        Map<String, Object> map = portletRegistryElement.getCollectionProperty("descriptionMap");
        String description = null;
        if (map != null) {
            description = (String)map.get(desiredLocale);
        }
        return description;
    }

    @Override
    public String getShortTitle(String portletName, String desiredLocale) throws PortletRegistryException {
        PortletRegistryElement portletRegistryElement = this.getRegistryElement(portletName);
        String shortTitle = portletRegistryElement.getStringProperty("title");
        return shortTitle;
    }

    @Override
    public String getTitle(String portletName, String desiredLocale) throws PortletRegistryException {
        PortletRegistryElement portletRegistryElement = this.getRegistryElement(portletName);
        String title = portletRegistryElement.getStringProperty("title");
        return title;
    }

    @Override
    public List<String> getKeywords(String portletName, String desiredLocale) throws PortletRegistryException {
        PortletRegistryElement portletRegistryElement = this.getRegistryElement(portletName);
        Map<String, Object> map = portletRegistryElement.getCollectionProperty("keywords");
        List<String> keywords = null;
        if (map != null) {
            keywords = this.mapValuesToList(map);
        }
        return keywords;
    }

    @Override
    public String getDisplayName(String portletName, String desiredLocale) throws PortletRegistryException {
        PortletRegistryElement portletRegistryElement = this.getRegistryElement(portletName);
        Map<String, Object> map = portletRegistryElement.getCollectionProperty("displayNameMap");
        String displayName = null;
        if (map != null) {
            displayName = (String)map.get(desiredLocale);
        }
        return displayName;
    }

    @Override
    public Map<String, Object> getRoleMap(String portletName) throws PortletRegistryException {
        PortletRegistryElement portletRegistryElement = this.getRegistryElement(portletName);
        Map<String, Object> roleMap = portletRegistryElement.getCollectionProperty("roleMap");
        return roleMap;
    }

    @Override
    public Map<String, Object> getUserInfoMap(String portletName) throws PortletRegistryException {
        PortletRegistryElement portletRegistryElement = this.getRegistryElement(portletName);
        Map<String, Object> userInfoMap = portletRegistryElement.getCollectionProperty("userInfoMap");
        return userInfoMap;
    }

    @Override
    public void removePortlet(String portletName) throws PortletRegistryException {
        List<PortletRegistryElement> portletApps = this.portletAppRegistry.getRegistryElements();
        ArrayList<PortletRegistryElement> removeablePortletApps = new ArrayList<PortletRegistryElement>();
        boolean remove = false;
        for (PortletRegistryElement portletApp : portletApps) {
            if (!portletApp.getPortletName().equals(portletName)) continue;
            remove = true;
            removeablePortletApps.add(portletApp);
        }
        for (PortletRegistryElement portletApp : removeablePortletApps) {
            this.portletAppRegistry.removeRegistryElement(portletApp);
        }
        if (remove) {
            this.writeDocument(this.portletAppRegistry);
        }
    }

    @Override
    public boolean hasView(String portletName) throws PortletRegistryException {
        return true;
    }

    @Override
    public boolean hasEdit(String portletName) throws PortletRegistryException {
        List<String> list = this.getSupportedPortletModes(portletName);
        return list.contains("EDIT");
    }

    @Override
    public boolean hasHelp(String portletName) throws PortletRegistryException {
        List<String> list = this.getSupportedPortletModes(portletName);
        return list.contains("HELP");
    }

    @Override
    public List<String> getAvailablePortlets() throws PortletRegistryException {
        List<PortletRegistryElement> portlets = this.portletAppRegistry.getRegistryElements();
        ArrayList<String> availablePortlets = new ArrayList<String>();
        for (PortletRegistryElement portletApp : portlets) {
            String portletName = portletApp.getPortletName();
            availablePortlets.add(portletName);
        }
        return availablePortlets;
    }

    private List<String> getSupportedPortletModes(String portletName) throws PortletRegistryException {
        PortletRegistryElement portletRegistryElement = this.getRegistryElement(portletName);
        Map<String, Object> map = portletRegistryElement.getCollectionProperty("supportsMap");
        ArrayList<String> list = new ArrayList<String>();
        Set<Map.Entry<String, Object>> entries = map.entrySet();
        for (Map.Entry<String, Object> mapEntry : entries) {
            List value = (List)mapEntry.getValue();
            for (String s : value) {
                list.add(s);
            }
        }
        return list;
    }

    private PortletRegistryElement getRegistryElement(String name) throws PortletRegistryException {
        PortletRegistryElement portletRegistryElement = this.portletAppRegistry.getRegistryElement(name);
        if (portletRegistryElement == null) {
            throw new PortletRegistryException(name + " does not exist");
        }
        return portletRegistryElement;
    }

    private List<String> mapValuesToList(Map<String, Object> map) {
        ArrayList<String> list = new ArrayList<String>();
        Set<String> keys = map.keySet();
        for (String key : keys) {
            list.add((String)map.get(key));
        }
        return list;
    }

    private PortletRegistryWriter getPortletRegistryWriter() throws PortletRegistryException {
        String registryLocation = PortletRegistryHelper.getRegistryLocation();
        return new PortletAppRegistryWriter(registryLocation);
    }

    private void writeDocument(PortletRegistryObject portletAppRegistry) throws PortletRegistryException {
        PortletRegistryWriter portletAppRegistryWriter = this.getPortletRegistryWriter();
        List<PortletRegistryElement> portletAppElementList = portletAppRegistry.getRegistryElements();
        try {
            portletAppRegistryWriter.writeDocument(portletAppElementList);
        }
        catch (Exception e) {
            throw new PortletRegistryException(e);
        }
    }
}

