/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.oak.jcr.query;

import javax.jcr.Node;
import javax.jcr.RepositoryException;
import javax.jcr.Value;
import javax.jcr.query.Row;
import org.apache.jackrabbit.oak.api.PropertyValue;
import org.apache.jackrabbit.oak.api.ResultRow;
import org.apache.jackrabbit.oak.api.Type;
import org.apache.jackrabbit.oak.jcr.query.QueryResultImpl;
import org.apache.jackrabbit.oak.plugins.memory.PropertyValues;

public class RowImpl
implements Row {
    private final QueryResultImpl result;
    private final ResultRow row;
    private final String pathSelector;

    public RowImpl(QueryResultImpl result, ResultRow row, String pathSelector) {
        this.result = result;
        this.row = row;
        this.pathSelector = pathSelector;
    }

    public Node getNode() throws RepositoryException {
        return this.getNode(null);
    }

    public Node getNode(String selectorName) throws RepositoryException {
        return this.result.getNode(this.row.getTree(selectorName));
    }

    public String getPath() throws RepositoryException {
        try {
            return this.row.getPath(this.pathSelector);
        }
        catch (IllegalArgumentException e) {
            throw new RepositoryException((Throwable)e);
        }
    }

    public String getPath(String selectorName) throws RepositoryException {
        try {
            return this.row.getPath(selectorName);
        }
        catch (IllegalArgumentException e) {
            throw new RepositoryException((Throwable)e);
        }
    }

    public String toString() {
        return this.row.toString();
    }

    public double getScore() throws RepositoryException {
        return 0.01;
    }

    public double getScore(String selectorName) throws RepositoryException {
        return 0.01;
    }

    public Value getValue(String columnName) throws RepositoryException {
        try {
            return this.result.createValue(this.row.getValue(columnName));
        }
        catch (IllegalArgumentException e) {
            throw new RepositoryException((Throwable)e);
        }
    }

    public Value[] getValues() throws RepositoryException {
        PropertyValue[] values = this.row.getValues();
        int len = values.length;
        Value[] v2 = new Value[values.length];
        for (int i = 0; i < len; ++i) {
            v2[i] = values[i] != null && values[i].isArray() ? this.result.createValue(RowImpl.mvpToString(values[i])) : this.result.createValue(values[i]);
        }
        return v2;
    }

    private static PropertyValue mvpToString(PropertyValue pv) {
        String v = String.join((CharSequence)" ", (Iterable)pv.getValue(Type.STRINGS));
        return PropertyValues.newString((String)v);
    }
}

