/*
 * Decompiled with CFR 0.152.
 */
package org.silverpeas.core.socialnetwork.connectors;

import javax.annotation.PostConstruct;
import javax.inject.Singleton;
import javax.servlet.http.HttpServletRequest;
import org.silverpeas.core.annotation.Service;
import org.silverpeas.core.socialnetwork.connectors.AbstractSocialNetworkConnector;
import org.silverpeas.core.socialnetwork.qualifiers.Facebook;
import org.silverpeas.core.socialnetwork.service.AccessToken;
import org.silverpeas.core.util.URLUtil;
import org.springframework.social.facebook.api.impl.FacebookTemplate;
import org.springframework.social.facebook.connect.FacebookConnectionFactory;
import org.springframework.social.oauth2.AccessGrant;

@Facebook
@Service
@Singleton
public class FacebookConnector
extends AbstractSocialNetworkConnector {
    private FacebookConnectionFactory connectionFactory = null;
    private String consumerKey = null;
    private String secretKey = null;

    @Override
    @PostConstruct
    void init() {
        super.init();
        this.consumerKey = this.getSettings().getString("facebook.consumerKey");
        this.secretKey = this.getSettings().getString("facebook.secretKey");
        this.connectionFactory = new FacebookConnectionFactory(this.consumerKey, this.secretKey);
    }

    @Override
    public String getUserProfileId(AccessToken authorizationToken) {
        AccessGrant accessGrant = authorizationToken.getAccessGrant();
        return ((org.springframework.social.facebook.api.Facebook)this.getConnectionFactory().createConnection(accessGrant).getApi()).userOperations().getUserProfile().getId();
    }

    @Override
    public void updateStatus(AccessToken authorizationToken, String status) {
        FacebookTemplate facebook = new FacebookTemplate(authorizationToken.getAccessGrant().getAccessToken());
        facebook.feedOperations().updateStatus(status);
    }

    @Override
    public void setJavascriptAttributes(HttpServletRequest request) {
        request.setAttribute("FB_loadSDK", (Object)this.getSDKLoadingScript(request));
    }

    protected FacebookConnectionFactory getConnectionFactory() {
        return this.connectionFactory;
    }

    private String getSDKLoadingScript(HttpServletRequest request) {
        StringBuilder code = new StringBuilder();
        code.append("<div id=\"fb-root\"></div>\n");
        code.append("<script>\n");
        code.append(" window.fbAsyncInit = function() {\n");
        code.append("   FB.init({\n");
        code.append("     appId      : '").append(this.consumerKey).append("', // App ID\n");
        code.append("     channelUrl : '").append(this.getChannelURL(request)).append("', // Channel File\n");
        code.append("     status     : true, // check login status\n");
        code.append("     cookie     : true, // enable cookies to allow the server to access the session\n");
        code.append("     xfbml      : true  // parse XFBML\n");
        code.append("   });\n");
        code.append("   if (initFB) { initFB() };\n");
        code.append(" };\n");
        code.append(" // Load the SDK Asynchronously\n");
        code.append(" (function(d){\n");
        code.append("     var js, id = 'facebook-jssdk'; if (d.getElementById(id)) {return;}\n");
        code.append("     js = d.createElement('script'); js.id = id; js.async = true;\n");
        code.append("     js.src = '//connect.facebook.net/en_US/all.js';\n");
        code.append("     d.getElementsByTagName('head')[0].appendChild(js);\n");
        code.append("  }(document));\n");
        code.append("</script>\n");
        return code.toString();
    }

    private String getChannelURL(HttpServletRequest request) {
        String fullURL = URLUtil.getFullApplicationURL(request);
        fullURL = fullURL.substring(fullURL.indexOf("//"));
        return fullURL + "/socialNetwork/jsp/channelFB.html";
    }
}

