/*
 * Decompiled with CFR 0.152.
 */
package org.silverpeas.core.security.encryption;

import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.nio.file.Path;
import java.security.KeyPair;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import net.sourceforge.jcetaglib.lib.X509Cert;
import org.silverpeas.core.admin.user.model.User;
import org.silverpeas.core.security.authentication.password.encryption.UnixDESEncryption;
import org.silverpeas.kernel.SilverpeasRuntimeException;
import org.silverpeas.kernel.bundle.ResourceLocator;
import org.silverpeas.kernel.bundle.SettingBundle;
import org.silverpeas.kernel.logging.SilverLogger;
import org.silverpeas.kernel.util.SystemWrapper;

public class X509Factory {
    private static X509Factory instance;
    private final String truststoreFile;
    private final String truststorePwd;
    private final String p12Dir;
    private final String p12Salt;
    private final int validity;
    private final String subjectDNSuffix;

    public static synchronized X509Factory getFactory() {
        if (instance == null) {
            instance = new X509Factory();
        }
        return instance;
    }

    private X509Factory() {
        SettingBundle settings = ResourceLocator.getSettingBundle((String)"org.silverpeas.util.security");
        String home = SystemWrapper.getInstance().getenv("SILVERPEAS_HOME");
        Path defaultTrustStorePath = Path.of(home, "configuration", "security", "servercert");
        Path defaultP12DirPath = Path.of(home, "configuration", "security", "p12");
        this.truststoreFile = settings.getString("x509.TruststoreFile", "server.truststore");
        this.truststorePwd = settings.getString("x509.TruststorePwd", defaultTrustStorePath.toString());
        String ou = settings.getString("x509.DN_OU", "silverpeas.com");
        String o = settings.getString("x509.DN_O", "Silverpeas");
        String l = settings.getString("x509.DN_L", "Grenoble");
        String c = settings.getString("x509.DN_C", "FR");
        this.subjectDNSuffix = "C=" + c + ", L=" + l + ", O=" + o + ", OU=" + ou;
        this.validity = Integer.parseInt(settings.getString("x509.Validity", "365"));
        this.p12Dir = settings.getString("p12.dir", defaultP12DirPath.toString());
        this.p12Salt = settings.getString("p12.salt", "SP");
    }

    public void buildP12(User user) {
        X509Certificate myCert;
        KeyPair keyPair;
        String userId = user.getId();
        String login = user.getLogin();
        String userFirstName = user.getFirstName();
        String userLastName = user.getLastName();
        String domainId = user.getDomainId();
        try {
            keyPair = X509Cert.generateKeyPair((String)"RSA", (int)1024, (byte[])new byte[0]);
        }
        catch (Exception e) {
            throw new SilverpeasRuntimeException("Cannot generate key pair", (Throwable)e);
        }
        PrivateKey privateKey = keyPair.getPrivate();
        PublicKey publicKey = keyPair.getPublic();
        String firstName = userFirstName == null ? "" : userFirstName;
        String subjectDN = this.subjectDNSuffix + ", CN=" + firstName + " " + userLastName;
        try {
            myCert = X509Cert.selfsign((PrivateKey)privateKey, (PublicKey)publicKey, (String)"MD5WithRSAEncryption", (long)this.validity, (String)subjectDN, (boolean)false, (String)"client");
        }
        catch (CertificateException e) {
            throw new SilverpeasRuntimeException("Cannot create self-signed X509 certificate", (Throwable)e);
        }
        KeyStore keyStore = this.getKeyStore();
        try {
            keyStore.setCertificateEntry(userId, myCert);
        }
        catch (KeyStoreException e) {
            throw new SilverpeasRuntimeException("Cannot store X509 certificate into the truststore", (Throwable)e);
        }
        this.writeKeyStore(keyStore);
        String p12File = this.p12Dir + login + "_" + domainId + ".p12";
        UnixDESEncryption desEncryption = new UnixDESEncryption();
        String password = desEncryption.encrypt(login, this.p12Salt.getBytes());
        try {
            X509Cert.saveAsP12((X509Certificate)myCert, null, (PrivateKey)privateKey, (String)p12File, (String)userId, (StringBuffer)new StringBuffer(password));
        }
        catch (Exception e) {
            throw new SilverpeasRuntimeException("Cannot create PKCS12 file", (Throwable)e);
        }
    }

    public void revokeUserCertificate(String userId) {
        KeyStore keyStore = this.getKeyStore();
        if (keyStore != null) {
            try {
                keyStore.deleteEntry(userId);
            }
            catch (KeyStoreException e) {
                throw new SilverpeasRuntimeException("Cannot delete X509 certificate from the truststore", (Throwable)e);
            }
            this.writeKeyStore(keyStore);
        }
    }

    private KeyStore getKeyStore() {
        KeyStore keyStore;
        try {
            keyStore = KeyStore.getInstance("jks");
        }
        catch (KeyStoreException e) {
            throw new SilverpeasRuntimeException("Cannot get a Keystore", (Throwable)e);
        }
        try (FileInputStream fis = new FileInputStream(this.truststoreFile);){
            keyStore.load(fis, this.truststorePwd.toCharArray());
        }
        catch (Exception e) {
            SilverLogger.getLogger(X509Factory.class).error(e.getMessage(), (Throwable)e);
        }
        return keyStore;
    }

    private void writeKeyStore(KeyStore keyStore) {
        try (FileOutputStream fos = new FileOutputStream(this.truststoreFile);){
            keyStore.store(fos, this.truststorePwd.toCharArray());
        }
        catch (Exception e) {
            SilverLogger.getLogger(X509Factory.class).error(e.getMessage(), (Throwable)e);
        }
    }
}

