/*
 * Decompiled with CFR 0.152.
 */
package org.silverpeas.core.security.authentication.verifier;

import javax.servlet.http.HttpServletRequest;
import org.silverpeas.core.admin.user.model.User;
import org.silverpeas.core.admin.user.model.UserDetail;
import org.silverpeas.core.cache.service.CacheAccessorProvider;
import org.silverpeas.core.security.authentication.exception.AuthenticationUserMustAcceptTermsOfService;
import org.silverpeas.core.security.authentication.verifier.AbstractAuthenticationVerifier;
import org.silverpeas.core.security.authentication.verifier.TermsOfServiceAcceptanceFrequency;
import org.silverpeas.kernel.cache.model.Cache;
import org.silverpeas.kernel.util.StringUtil;

public class UserMustAcceptTermsOfServiceVerifier
extends AbstractAuthenticationVerifier {
    public static final String ERROR_USER_TOS_REFUSED = "Error_UserTosRefused";
    public static final String ERROR_USER_TOS_TIMEOUT = "Error_UserTosTimeout";
    private static final TermsOfServiceAcceptanceFrequency globalAcceptanceFrequency;
    private static final int LIVE_10_MINUTES = 600;
    private static final Cache applicationCache;
    private String tosToken;

    protected UserMustAcceptTermsOfServiceVerifier(User user) {
        super(user);
    }

    public String getDestination(HttpServletRequest request) {
        request.setAttribute("tosToken", (Object)this.tosToken);
        request.setAttribute("language", (Object)this.getUser().getUserPreferences().getLanguage());
        boolean specificTemplateContentActivated = settings.getBoolean("termsOfServiceAcceptanceSpecificTemplateContent.domain" + this.getUser().getDomainId(), false);
        if (specificTemplateContentActivated) {
            request.setAttribute("templateDomainIdContent", (Object)("_domain" + this.getUser().getDomainId()));
        }
        return "/CredentialsServlet/TermsOfServiceRequest";
    }

    public UserMustAcceptTermsOfServiceVerifier verify() throws AuthenticationUserMustAcceptTermsOfService {
        if (this.isTermsOfServiceAcceptanceDateIsExpired()) {
            this.tosToken = applicationCache.add((Object)this, 600);
            throw new AuthenticationUserMustAcceptTermsOfService("The user must accept the terms of service", new String[0]);
        }
        return this;
    }

    private synchronized boolean isTermsOfServiceAcceptanceDateIsExpired() {
        if (this.getUser() == null || this.getUser().isAnonymous()) {
            return false;
        }
        String specificAcceptanceFrequencyValue = settings.getString("termsOfServiceAcceptanceFrequency.domain" + this.getUser().getDomainId(), null);
        TermsOfServiceAcceptanceFrequency acceptanceFrequency = StringUtil.isDefined((String)specificAcceptanceFrequencyValue) ? TermsOfServiceAcceptanceFrequency.decode(specificAcceptanceFrequencyValue) : globalAcceptanceFrequency;
        UserDetail user = (UserDetail)this.getUser();
        return acceptanceFrequency.isActivated() && acceptanceFrequency.isAcceptanceDateExpired(user.getTosAcceptanceDate());
    }

    public UserMustAcceptTermsOfServiceVerifier clearCache() {
        UserMustAcceptTermsOfServiceVerifier.clearCache(this.tosToken);
        return this;
    }

    protected static synchronized UserMustAcceptTermsOfServiceVerifier get(String tosToken) {
        UserMustAcceptTermsOfServiceVerifier verifier = (UserMustAcceptTermsOfServiceVerifier)applicationCache.get((Object)tosToken, UserMustAcceptTermsOfServiceVerifier.class);
        if (verifier == null) {
            verifier = new UserMustAcceptTermsOfServiceVerifier(null);
        }
        return verifier;
    }

    private static synchronized void clearCache(String tosToken) {
        if (tosToken != null) {
            applicationCache.remove((Object)tosToken);
        }
    }

    static {
        applicationCache = CacheAccessorProvider.getApplicationCacheAccessor().getCache();
        globalAcceptanceFrequency = TermsOfServiceAcceptanceFrequency.decode(settings.getString("termsOfServiceAcceptanceFrequency"));
    }
}

