/*
 * Decompiled with CFR 0.152.
 */
package org.silverpeas.core.security.authentication.verifier;

import java.lang.annotation.Annotation;
import java.util.Date;
import java.util.Iterator;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpSession;
import org.apache.commons.lang3.time.DateUtils;
import org.silverpeas.core.admin.service.AdminController;
import org.silverpeas.core.admin.user.model.User;
import org.silverpeas.core.i18n.I18NHelper;
import org.silverpeas.core.scheduler.Job;
import org.silverpeas.core.scheduler.JobExecutionContext;
import org.silverpeas.core.scheduler.SchedulerException;
import org.silverpeas.core.scheduler.SchedulerProvider;
import org.silverpeas.core.scheduler.trigger.JobTrigger;
import org.silverpeas.core.scheduler.trigger.TimeUnit;
import org.silverpeas.core.security.authentication.AuthenticationResponse;
import org.silverpeas.core.security.authentication.exception.AuthenticationNoMoreUserConnectionAttemptException;
import org.silverpeas.core.security.authentication.verifier.AbstractAuthenticationVerifier;
import org.silverpeas.core.util.DateUtil;
import org.silverpeas.core.util.ServiceProvider;
import org.silverpeas.kernel.logging.SilverLogger;
import org.silverpeas.kernel.util.StringUtil;

public class UserCanTryAgainToLoginVerifier
extends AbstractAuthenticationVerifier {
    private static final Map<String, UserCanTryAgainToLoginVerifier> cache = new ConcurrentHashMap<String, UserCanTryAgainToLoginVerifier>();
    private static boolean isActivated = false;
    private static boolean isCacheCleanerInitialized = false;
    private static int nbMaxAttempts = settings.getInteger("nbConnectionAttemptsBeforeBlockingUser", 0);
    private int nbAttempts = 0;
    private Date initializationOrLastVerifyDate = DateUtil.getNow();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private UserCanTryAgainToLoginVerifier(User user) {
        super(user);
        if (isActivated && !isCacheCleanerInitialized) {
            Map<String, UserCanTryAgainToLoginVerifier> map = cache;
            synchronized (map) {
                if (!SchedulerProvider.getVolatileScheduler().isJobScheduled("AuthenticationUserConnectionAttemptsVerifierCleanerJob")) {
                    try {
                        SchedulerProvider.getVolatileScheduler().scheduleJob((Job)new CacheCleanerJob(), JobTrigger.triggerEvery((int)10, (TimeUnit)TimeUnit.MINUTE));
                        isCacheCleanerInitialized = true;
                    }
                    catch (SchedulerException e) {
                        SilverLogger.getLogger((Object)this).error(e.getMessage(), (Throwable)e);
                    }
                }
            }
        }
    }

    public boolean isActivated() {
        return isActivated;
    }

    public String performRequestUrl(HttpServletRequest request, String originalUrl) {
        HttpSession session;
        if (isActivated && (session = request.getSession(false)) != null) {
            session.setAttribute("WarningMessage", (Object)this.getMessage());
        }
        return originalUrl;
    }

    public String getMessage() {
        if (isActivated && (this.getUser() == null || !this.getUser().isAnonymous())) {
            return UserCanTryAgainToLoginVerifier.getString("authentication.attempts.remaining", this.getUser() != null && StringUtil.isDefined((String)this.getUser().getId()) ? this.getUser().getUserPreferences().getLanguage() : I18NHelper.DEFAULT_LANGUAGE, String.valueOf(nbMaxAttempts - this.nbAttempts));
        }
        return "";
    }

    public String getErrorDestination() {
        return "/Login?ErrorCode=" + AuthenticationResponse.Status.USER_ACCOUNT_BLOCKED;
    }

    public UserCanTryAgainToLoginVerifier verify() throws AuthenticationNoMoreUserConnectionAttemptException {
        this.initializationOrLastVerifyDate = DateUtil.getNow();
        if (!this.isAtLeastOneUserConnectionAttempt()) {
            if (this.getUser() != null && StringUtil.isDefined((String)this.getUser().getId())) {
                AdminController adminController = (AdminController)ServiceProvider.getService(AdminController.class, (Annotation[])new Annotation[0]);
                adminController.blockUser(this.getUser().getId());
                this.clearCache();
            }
            throw new AuthenticationNoMoreUserConnectionAttemptException((String)(this.getUser() != null ? "Login=" + this.getUser().getLogin() : ""), new String[0]);
        }
        return this;
    }

    private synchronized boolean isAtLeastOneUserConnectionAttempt() {
        return !isActivated || this.getUser() != null && (this.getUser().isAnonymous() || ++this.nbAttempts < nbMaxAttempts);
    }

    public UserCanTryAgainToLoginVerifier clearCache() {
        UserCanTryAgainToLoginVerifier.clearCache(this.getUser());
        return this;
    }

    public void clearSession(HttpServletRequest request) {
        HttpSession session = request.getSession(false);
        if (session != null) {
            session.removeAttribute("WarningMessage");
        }
    }

    protected static synchronized UserCanTryAgainToLoginVerifier get(User user) {
        if (user == null) {
            return new UserCanTryAgainToLoginVerifier(null);
        }
        String userKey = UserCanTryAgainToLoginVerifier.key(user);
        UserCanTryAgainToLoginVerifier verifier = cache.get(userKey);
        if (verifier == null) {
            verifier = new UserCanTryAgainToLoginVerifier(user);
            if (isActivated) {
                cache.put(userKey, verifier);
            }
        } else {
            verifier.setUser(user);
        }
        return verifier;
    }

    private static synchronized void clearCache(User user) {
        if (user != null) {
            cache.remove(UserCanTryAgainToLoginVerifier.key(user));
        }
    }

    private static String key(User user) {
        return "key(" + user.getLogin() + "#@#" + user.getDomainId() + ")";
    }

    static {
        if (nbMaxAttempts > 0) {
            isActivated = true;
        }
    }

    private static class CacheCleanerJob
    extends Job {
        public static final String JOB_NAME = "AuthenticationUserConnectionAttemptsVerifierCleanerJob";

        public CacheCleanerJob() {
            super(JOB_NAME);
        }

        public void execute(JobExecutionContext context) {
            Date now = DateUtil.getNow();
            Iterator<Map.Entry<String, UserCanTryAgainToLoginVerifier>> it = cache.entrySet().iterator();
            while (it.hasNext()) {
                UserCanTryAgainToLoginVerifier verifier = it.next().getValue();
                if (DateUtils.addHours((Date)verifier.initializationOrLastVerifyDate, (int)1).compareTo(now) >= 0) continue;
                it.remove();
            }
        }
    }
}

