/*
 * Decompiled with CFR 0.152.
 */
package org.silverpeas.core.notification.user.client;

import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.annotation.Nonnull;
import javax.inject.Inject;
import javax.transaction.Transactional;
import org.apache.commons.lang3.StringUtils;
import org.silverpeas.core.admin.component.ComponentInstanceDeletion;
import org.silverpeas.core.admin.component.model.ComponentInst;
import org.silverpeas.core.admin.service.AdminException;
import org.silverpeas.core.admin.service.Administration;
import org.silverpeas.core.admin.service.AdministrationServiceProvider;
import org.silverpeas.core.admin.service.OrganizationController;
import org.silverpeas.core.admin.space.SpaceInst;
import org.silverpeas.core.admin.space.SpaceInstLight;
import org.silverpeas.core.admin.user.constant.UserAccessLevel;
import org.silverpeas.core.admin.user.model.User;
import org.silverpeas.core.admin.user.model.UserDetail;
import org.silverpeas.core.annotation.Service;
import org.silverpeas.core.exception.DecodingException;
import org.silverpeas.core.i18n.AbstractI18NBean;
import org.silverpeas.core.i18n.I18NHelper;
import org.silverpeas.core.notification.NotificationException;
import org.silverpeas.core.notification.user.client.ExternalRecipient;
import org.silverpeas.core.notification.user.client.NotificationAddress;
import org.silverpeas.core.notification.user.client.NotificationManager;
import org.silverpeas.core.notification.user.client.NotificationManagerSettings;
import org.silverpeas.core.notification.user.client.NotificationMetaData;
import org.silverpeas.core.notification.user.client.NotificationParameterNames;
import org.silverpeas.core.notification.user.client.NotificationParameters;
import org.silverpeas.core.notification.user.client.NotificationURLProvider;
import org.silverpeas.core.notification.user.client.UserRecipient;
import org.silverpeas.core.notification.user.client.constant.BuiltInNotifAddress;
import org.silverpeas.core.notification.user.client.constant.NotifChannel;
import org.silverpeas.core.notification.user.client.model.NotifAddressRow;
import org.silverpeas.core.notification.user.client.model.NotifAddressTable;
import org.silverpeas.core.notification.user.client.model.NotifChannelRow;
import org.silverpeas.core.notification.user.client.model.NotifChannelTable;
import org.silverpeas.core.notification.user.client.model.NotifDefaultAddressRow;
import org.silverpeas.core.notification.user.client.model.NotifDefaultAddressTable;
import org.silverpeas.core.notification.user.client.model.NotifPreferenceRow;
import org.silverpeas.core.notification.user.client.model.NotifPreferenceTable;
import org.silverpeas.core.notification.user.client.model.NotificationSchema;
import org.silverpeas.core.notification.user.delayed.delegate.DelayedNotificationDelegate;
import org.silverpeas.core.notification.user.delayed.model.DelayedNotificationData;
import org.silverpeas.core.notification.user.server.NotificationData;
import org.silverpeas.core.notification.user.server.NotificationServer;
import org.silverpeas.core.notification.user.server.NotificationServerException;
import org.silverpeas.core.util.EmailAddress;
import org.silverpeas.core.util.URLUtil;
import org.silverpeas.kernel.SilverpeasRuntimeException;
import org.silverpeas.kernel.bundle.LocalizationBundle;
import org.silverpeas.kernel.bundle.ResourceLocator;
import org.silverpeas.kernel.logging.SilverLogger;
import org.silverpeas.kernel.util.StringUtil;

@Service
@Transactional
public class DefaultNotificationManager
implements NotificationURLProvider,
ComponentInstanceDeletion,
NotificationManager {
    private static final String FROM_UID = "I";
    private static final String FROM_EMAIL = "E";
    private static final String FROM_NAME = "N";
    private static final String HTML_BREAK_LINES = "<br><br>";
    private static final String OF_THE_USER = " of the user ";
    private static final String FOR_THE_USER = " for the user ";
    private static final String MESSAGE_PRIORITY = "messagePriority";
    private LocalizationBundle multilang = ResourceLocator.getLocalizationBundle((String)"org.silverpeas.notificationManager.multilang.notificationManagerBundle", (String)"fr");
    @Inject
    private NotificationSchema schema;
    @Inject
    private NotificationServer server;

    protected DefaultNotificationManager() {
    }

    public DefaultNotificationManager forLanguage(String language) {
        String lang = StringUtil.isDefined((String)language) ? language : I18NHelper.DEFAULT_LANGUAGE;
        this.multilang = ResourceLocator.getLocalizationBundle((String)"org.silverpeas.notificationManager.multilang.notificationManagerBundle", (String)lang);
        return this;
    }

    @Override
    public void delete(String componentInstanceId) {
        int id = OrganizationController.get().getComponentInst(componentInstanceId).getLocalId();
        try {
            this.schema.notifPreference().dereferenceComponentInstanceId(id);
        }
        catch (SQLException e) {
            SilverLogger.getLogger((Object)this).error(e.getMessage(), (Throwable)e);
        }
    }

    public List<Properties> getNotifAddressProperties(String aUserId) throws NotificationException {
        ArrayList<Properties> addresses = new ArrayList<Properties>();
        try {
            NotifAddressTable nat = this.schema.notifAddress();
            boolean isMultiChannelSupported = this.isMultiChannelNotification();
            this.addToUserAddressProperties(BuiltInNotifAddress.BASIC_POPUP, aUserId, isMultiChannelSupported, addresses);
            this.addToUserAddressProperties(BuiltInNotifAddress.BASIC_SILVERMAIL, aUserId, isMultiChannelSupported, addresses);
            this.addToUserAddressProperties(BuiltInNotifAddress.BASIC_SMTP, aUserId, isMultiChannelSupported, addresses);
            this.addToUserAddressProperties(BuiltInNotifAddress.BASIC_REMOVE, aUserId, isMultiChannelSupported, addresses);
            Stream.of(nat.getAllByUserId(Integer.parseInt(aUserId))).forEach(r -> {
                try {
                    this.addToUserAddressProperties((NotifAddressRow)r, aUserId, isMultiChannelSupported, (List<Properties>)addresses);
                }
                catch (SQLException e) {
                    throw new SilverpeasRuntimeException((Throwable)e);
                }
            });
        }
        catch (SQLException | SilverpeasRuntimeException e) {
            throw new NotificationException("Cannot get notification addresses of the user " + aUserId, e);
        }
        return addresses;
    }

    private void addToUserAddressProperties(BuiltInNotifAddress mediaType, String aUserId, boolean multiChannelSupported, List<Properties> properties) throws NotificationException, SQLException {
        NotificationParameters params = new NotificationParameters();
        params.setAddressId(mediaType.getId());
        NotifAddressRow row = this.getNotifAddressRow(params, aUserId);
        this.addToUserAddressProperties(row, aUserId, multiChannelSupported, properties);
    }

    private void addToUserAddressProperties(NotifAddressRow row, String aUserId, boolean multiChannelSupported, List<Properties> properties) throws SQLException {
        boolean defaultAddress = this.isDefaultNotifAddress(row.getId(), aUserId, multiChannelSupported);
        boolean editable = BuiltInNotifAddress.decode((Integer)row.getId()).isEmpty();
        boolean testable = row.getId() != BuiltInNotifAddress.BASIC_REMOVE.getId();
        properties.add(this.notifAddressRowToProperties(row, editable, editable, testable, defaultAddress));
    }

    public Properties getNotifAddressProperties(String addressId, String aUserId) throws NotificationException {
        Properties p;
        try {
            int id = Integer.parseInt(addressId);
            NotificationParameters params = new NotificationParameters();
            params.setAddressId(id);
            p = this.notifAddressRowToProperties(this.getNotifAddressRow(params, aUserId), true, true, true, this.isDefaultNotifAddress(id, aUserId, false));
        }
        catch (SQLException e) {
            throw new NotificationException("Cannot get the notification address " + addressId + OF_THE_USER + aUserId, (Throwable)e);
        }
        return p;
    }

    public String getDefaultAddressId(String aUserId) throws NotificationException {
        try {
            NotifDefaultAddressTable ndat = this.schema.notifDefaultAddress();
            NotifDefaultAddressRow[] ndars = ndat.getAllByUserId(Integer.parseInt(aUserId));
            int addressId = ndars.length > 0 ? ndars[0].getNotifAddressId() : this.getDefaultNotificationChannels().get(0).getMediaType().getId();
            return String.valueOf(addressId);
        }
        catch (SQLException | DecodingException e) {
            throw new NotificationException("Cannot get the default notification address of the user " + aUserId, e);
        }
    }

    public List<Properties> getNotifChannels() throws NotificationException {
        ArrayList<Properties> ar = new ArrayList<Properties>();
        try {
            NotifChannelRow[] rows;
            NotifChannelTable nct = this.schema.notifChannel();
            for (NotifChannelRow row : rows = nct.getAllRows()) {
                if (!row.getCouldBeAdded().equalsIgnoreCase("Y")) continue;
                Properties p = new Properties();
                p.setProperty("id", String.valueOf(row.getId()));
                p.setProperty("name", this.multilang.getString("channelType" + row.getId()));
                ar.add(p);
            }
        }
        catch (SQLException e) {
            throw new NotificationException("Cannot get the notification channels", (Throwable)e);
        }
        return ar;
    }

    public List<Properties> getNotifPreferences(String aUserId) throws NotificationException {
        ArrayList<Properties> ar = new ArrayList<Properties>();
        try {
            NotifPreferenceRow[] nprs;
            NotifPreferenceTable npt = this.schema.notifPreference();
            for (NotifPreferenceRow npr : nprs = npt.getAllByUserId(Integer.parseInt(aUserId))) {
                ar.add(this.notifPreferencesRowToProperties(aUserId, npr));
            }
        }
        catch (SQLException e) {
            throw new NotificationException("Cannot get the notification preferences of the user " + aUserId, (Throwable)e);
        }
        return ar;
    }

    public Properties getNotifPreference(String aPrefId, String aUserId) throws NotificationException {
        try {
            NotifPreferenceTable npt = this.schema.notifPreference();
            NotifPreferenceRow npr = npt.getNotifPreference(Integer.parseInt(aPrefId));
            return this.notifPreferencesRowToProperties(aUserId, npr);
        }
        catch (SQLException e) {
            throw new NotificationException("Cannot get the notification preference " + aPrefId + OF_THE_USER + aUserId, (Throwable)e);
        }
    }

    public void setDefaultAddress(String aNotificationAddressId, String aUserId) throws NotificationException {
        try {
            NotifDefaultAddressTable ndat = this.schema.notifDefaultAddress();
            int uId = Integer.parseInt(aUserId);
            int nId = Integer.parseInt(aNotificationAddressId);
            NotifDefaultAddressRow[] ndars = ndat.getAllByUserId(uId);
            if (ndars.length > 0) {
                if (ndars[0].getNotifAddressId() != nId) {
                    ndars[0].setNotifAddressId(nId);
                    ndat.update(ndars[0]);
                }
            } else {
                NotifDefaultAddressRow newRow = new NotifDefaultAddressRow(-1, uId, nId);
                ndat.create(newRow);
            }
        }
        catch (SQLException e) {
            throw new NotificationException("Cannot set the default address " + aNotificationAddressId + FOR_THE_USER + aUserId, (Throwable)e);
        }
    }

    public void addDefaultAddress(String aNotificationAddressId, String aUserId) throws NotificationException {
        try {
            NotifDefaultAddressTable ndat = this.schema.notifDefaultAddress();
            NotifDefaultAddressRow newRow = new NotifDefaultAddressRow(-1, Integer.parseInt(aUserId), Integer.parseInt(aNotificationAddressId));
            ndat.create(newRow);
        }
        catch (SQLException e) {
            throw new NotificationException("Cannot set the address " + aNotificationAddressId + FOR_THE_USER + aUserId, (Throwable)e);
        }
    }

    public void savePreferences(String aUserId, int instanceLocalId, int aMessageType, String notifAddressId) throws NotificationException {
        try {
            int uId = Integer.parseInt(aUserId);
            NotifPreferenceTable npt = this.schema.notifPreference();
            int messageType = aMessageType;
            if (messageType == -1) {
                messageType = 0;
            }
            NotifPreferenceRow npr = npt.getByUserIdAndComponentInstanceIdAndMessageType(uId, instanceLocalId, messageType);
            int nId = Integer.parseInt(notifAddressId);
            if (nId == BuiltInNotifAddress.DEFAULT.getId()) {
                if (npr != null) {
                    npt.delete(npr.getId());
                }
            } else {
                if (npr == null) {
                    npr = new NotifPreferenceRow(-1, nId, instanceLocalId, uId, messageType);
                } else {
                    npr.setNotifAddressId(nId);
                }
                npt.save(npr);
            }
        }
        catch (SQLException e) {
            throw new NotificationException("Cannot save the notification preferences of the user " + aUserId + " for the component instance " + instanceLocalId, (Throwable)e);
        }
    }

    public void saveNotifAddress(NotificationAddress notificationAddress) throws NotificationException {
        try {
            NotifAddressTable nat = this.schema.notifAddress();
            NotifAddressRow row = new NotifAddressRow(notificationAddress.getRawId(), notificationAddress.getUserId(), notificationAddress.getName(), notificationAddress.getRawChannelId(), notificationAddress.getAddress(), notificationAddress.getUsage(), 0);
            nat.save(row);
        }
        catch (SQLException e) {
            throw new NotificationException("Cannot save the address " + notificationAddress.getId() + FOR_THE_USER + notificationAddress.getUserId() + " with as name " + notificationAddress.getName() + " and for the channel " + notificationAddress.getChannelId(), (Throwable)e);
        }
    }

    public void deletePreference(String aPreferenceId) throws NotificationException {
        try {
            NotifPreferenceTable npt = this.schema.notifPreference();
            npt.delete(Integer.parseInt(aPreferenceId));
        }
        catch (SQLException e) {
            throw new NotificationException("Cannot delete the notification preference " + aPreferenceId, (Throwable)e);
        }
    }

    public void deleteNotifAddress(String aNotificationAddressId) throws NotificationException {
        try {
            List<NotifChannel> channels = this.getDefaultNotificationChannels();
            NotifAddressTable nat = this.schema.notifAddress();
            nat.deleteAndPropagate(Integer.parseInt(aNotificationAddressId), channels.get(0).getMediaType().getId());
        }
        catch (SQLException e) {
            throw new NotificationException("Cannot delete the notification address " + aNotificationAddressId, (Throwable)e);
        }
    }

    public void deleteAllDefaultAddress(String userId) throws NotificationException {
        try {
            NotifDefaultAddressTable nat = this.schema.notifDefaultAddress();
            nat.dereferenceUserId(Integer.parseInt(userId));
        }
        catch (SQLException e) {
            throw new NotificationException("Cannot delete all the notification addresses of the user " + userId, (Throwable)e);
        }
    }

    public void testNotifAddress(String addressId, String aUserId) throws NotificationException {
        try {
            NotificationMetaData metaData = new NotificationMetaData(0, this.multilang.getString("testMsgTitle"), this.multilang.getString("testMsgBody"));
            NotificationParameters params = new NotificationParameters();
            params.setAddressId(Integer.parseInt(addressId)).setTitle(metaData.getTitle()).setMessage(metaData.getContent()).setFromUserId(Integer.parseInt(aUserId)).setLanguage(this.multilang.getLocale().getLanguage());
            NotificationData nd = this.createNotificationData(params, aUserId);
            this.server.addNotification(nd);
        }
        catch (SQLException | NotificationServerException e) {
            throw new NotificationException("Cannot test the notification address " + addressId + OF_THE_USER + aUserId, (Throwable)e);
        }
    }

    public void notifyUsers(NotificationParameters params, Collection<String> userIds) throws NotificationException {
        Collection<String> recipientIds;
        if (UserAccessLevel.GUEST.equals((Object)this.getUserAccessLevel(params.getFromUserId()))) {
            params.setMessage(this.multilang.getString("guestNotAllowedBody1") + "<br>" + params.getTitle() + HTML_BREAK_LINES + this.multilang.getString("guestNotAllowedBody2")).setTitle(this.multilang.getString("guestNotAllowedTitle")).setMessagePriority(0).setAddressId(BuiltInNotifAddress.BASIC_POPUP.getId()).setComponentInstance(-1);
            recipientIds = Collections.singleton(String.valueOf(params.getFromUserId()));
        } else {
            recipientIds = userIds;
        }
        this.checkTitleLength(params);
        try {
            params.trace();
            for (String userId : recipientIds) {
                this.doNewDelayedNotifications(params, userId);
            }
        }
        catch (Exception e) {
            throw new NotificationException((Throwable)e);
        }
    }

    private void checkTitleLength(NotificationParameters params) throws NotificationException {
        if (params.isTitleExceedsMaxSize()) {
            throw new NotificationException("The title is too long. It exceeds the threshold 1023", new String[0]);
        }
    }

    private void doNewDelayedNotifications(NotificationParameters params, String userId) throws NotificationException {
        try {
            for (DelayedNotificationData dnd : this.createAllDelayedNotificationData(params, userId)) {
                DelayedNotificationDelegate.executeNewNotification(dnd);
            }
        }
        catch (NotificationServerException e) {
            throw new NotificationException((Throwable)((Object)e));
        }
        catch (Exception ex) {
            SilverLogger.getLogger((Object)this).error((Throwable)ex);
        }
    }

    public void notifyExternals(NotificationParameters params, Collection<ExternalRecipient> externals) throws NotificationException {
        params.setAddressId(BuiltInNotifAddress.BASIC_SMTP.getId());
        this.checkTitleLength(params);
        try {
            for (ExternalRecipient externalRecipient : externals) {
                NotificationData nd = this.createExternalNotificationData(params, externalRecipient.getEmail());
                this.server.addNotification(nd);
            }
        }
        catch (SQLException | NotificationServerException e) {
            throw new NotificationException((Throwable)e);
        }
    }

    public Collection<UserRecipient> getUsersFromGroup(String groupId) throws NotificationException {
        try {
            UserDetail[] users = AdministrationServiceProvider.getAdminService().getAllUsersOfGroup(groupId);
            ArrayList<UserRecipient> recipients = new ArrayList<UserRecipient>(users.length);
            for (UserDetail user : users) {
                if (!user.isActivatedState()) continue;
                recipients.add(new UserRecipient((User)user));
            }
            return recipients;
        }
        catch (AdminException e) {
            throw new NotificationException((Throwable)((Object)e));
        }
    }

    public String getComponentFullName(String compInst) throws NotificationException {
        return this.getComponentFullName(compInst, " - ", false);
    }

    private String getComponentFullName(String compInst, String separator, boolean isPathToComponent) throws NotificationException {
        try {
            StringBuilder sb = new StringBuilder();
            ComponentInst instance = AdministrationServiceProvider.getAdminService().getComponentInst(compInst);
            NotificationManagerSettings.isComponentInstanceLabelInNotificationSource();
            if (!isPathToComponent) {
                sb.append(this.getSpaceLabelOf(instance)).append(separator);
            } else {
                sb.append(this.getSpaceLabelPathOf(instance, separator)).append(separator);
            }
            sb.append(instance.getLabel());
            return sb.toString();
        }
        catch (AdminException e) {
            throw new NotificationException((Throwable)((Object)e));
        }
    }

    private String computeDefaultSource(String compInst) throws AdminException {
        String separator = " - ";
        boolean isSpaceLabelSet = NotificationManagerSettings.isSpaceLabelInNotificationSource();
        boolean isCompInstLabelSet = NotificationManagerSettings.isComponentInstanceLabelInNotificationSource();
        StringBuilder source = new StringBuilder();
        if (isSpaceLabelSet || isCompInstLabelSet) {
            ComponentInst instance = AdministrationServiceProvider.getAdminService().getComponentInst(compInst);
            if (isSpaceLabelSet) {
                source.append(this.getSpaceLabelOf(instance));
            }
            if (isCompInstLabelSet) {
                if (isSpaceLabelSet) {
                    source.append(" - ");
                }
                source.append(instance.getLabel());
            }
        }
        return source.toString();
    }

    private String getSpaceLabelPathOf(ComponentInst instance, String pathSeparator) throws AdminException {
        List<SpaceInstLight> spaces = AdministrationServiceProvider.getAdminService().getPathToComponent(instance.getId());
        return spaces.stream().map(AbstractI18NBean::getName).collect(Collectors.joining(pathSeparator));
    }

    private String getSpaceLabelOf(ComponentInst instance) throws AdminException {
        SpaceInst space = AdministrationServiceProvider.getAdminService().getSpaceInstById(instance.getDomainFatherId());
        return space.getName();
    }

    private User getUser(String userId) {
        try {
            UserDetail user = Administration.get().getUserDetail(userId);
            if (user != null && !user.isSystem()) {
                return user;
            }
            SilverLogger.getLogger((Object)this).warn("No user with id " + userId, new Object[0]);
            return null;
        }
        catch (AdminException e) {
            SilverLogger.getLogger((Object)this).error(e.getMessage(), new Object[0]);
            return null;
        }
    }

    private String getUserEmail(String userId) {
        String valret = "";
        User user = this.getUser(userId);
        if (user != null) {
            valret = user.getEmailAddress();
        }
        return valret;
    }

    private UserAccessLevel getUserAccessLevel(int userId) {
        UserAccessLevel valret = UserAccessLevel.UNKNOWN;
        User user = this.getUser(String.valueOf(userId));
        if (user != null) {
            valret = user.getAccessLevel();
        }
        return valret;
    }

    private String getUserFullName(int userId) {
        String valret = "";
        User user = this.getUser(String.valueOf(userId));
        if (user != null) {
            valret = user.getDisplayedName();
        }
        return valret;
    }

    private Properties notifPreferencesRowToProperties(String aUserId, NotifPreferenceRow npr) throws NotificationException, SQLException {
        boolean canEdit = true;
        boolean canDelete = true;
        boolean canTest = false;
        boolean isDefault = false;
        Properties p = new Properties();
        NotificationParameters params = new NotificationParameters();
        params.setAddressId(npr.getNotifAddressId());
        NotifAddressRow nar = this.getNotifAddressRow(params, aUserId);
        p.setProperty("id", String.valueOf(npr.getId()));
        p.setProperty("notifAddressId", String.valueOf(npr.getNotifAddressId()));
        p.setProperty("notifAddress", this.getSureString(nar.getNotifName()));
        p.setProperty("componentId", String.valueOf(npr.getComponentInstanceId()));
        p.setProperty("component", this.getComponentFullName(String.valueOf(npr.getComponentInstanceId())));
        p.setProperty("priorityId", String.valueOf(npr.getMessageType()));
        p.setProperty("priority", this.getSureString(this.multilang.getString(MESSAGE_PRIORITY + npr.getMessageType())));
        return this.setCommonNotifPrefsProperties(canEdit, canDelete, canTest, isDefault, p);
    }

    @Nonnull
    private Properties setCommonNotifPrefsProperties(boolean canEdit, boolean canDelete, boolean canTest, boolean isDefault, Properties p) {
        p.setProperty("canEdit", String.valueOf(canEdit));
        p.setProperty("canDelete", String.valueOf(canDelete));
        p.setProperty("canTest", String.valueOf(canTest));
        p.setProperty("isDefault", String.valueOf(isDefault));
        return p;
    }

    private Properties notifAddressRowToProperties(NotifAddressRow nar, boolean canEdit, boolean canDelete, boolean canTest, boolean isDefault) throws SQLException {
        Properties p = new Properties();
        int channelId = nar.getNotifChannelId();
        int addressId = nar.getId();
        String addressValue = addressId == BuiltInNotifAddress.BASIC_POPUP.getId() || addressId == BuiltInNotifAddress.BASIC_SILVERMAIL.getId() ? this.getUserFullName(Integer.parseInt(this.getSureString(nar.getAddress()))) : this.getSureString(nar.getAddress());
        NotifChannelTable nct = this.schema.notifChannel();
        NotifChannelRow crow = nct.getNotifChannel(channelId);
        p.setProperty("id", String.valueOf(addressId));
        p.setProperty("address", addressValue);
        p.setProperty("name", this.getSureString(nar.getNotifName()));
        p.setProperty("channelId", String.valueOf(channelId));
        p.setProperty("channel", this.getSureString(crow.getName()));
        p.setProperty("usageId", this.getSureString(nar.getUsage()));
        p.setProperty("usage", this.getSureString(this.multilang.getString(this.getSureString(nar.getUsage()))));
        return this.setCommonNotifPrefsProperties(canEdit, canDelete, canTest, isDefault, p);
    }

    private NotifAddressRow getNotifAddressRow(NotificationParameters params, String aUserId) throws SQLException, NotificationException {
        int addressId = this.getAddressId(params, aUserId);
        if (addressId == BuiltInNotifAddress.DEFAULT.getId()) {
            addressId = Integer.parseInt(this.getDefaultAddressId(aUserId));
        }
        NotifAddressRow nar = this.getNotifAddressRow(params, aUserId, addressId);
        return nar;
    }

    private NotifAddressRow getNotifAddressRow(NotificationParameters params, String aUserId, int addressId) throws SQLException {
        NotifAddressRow nar = addressId == BuiltInNotifAddress.BASIC_POPUP.getId() ? new NotifAddressRow(addressId, aUserId, this.multilang.getString("defaultAddressPOPUP"), NotifChannel.POPUP.getId(), aUserId, "addressUsePro", params.getMessagePriority()) : (addressId == BuiltInNotifAddress.BASIC_REMOVE.getId() ? new NotifAddressRow(addressId, aUserId, this.multilang.getString("defaultAddressREMOVE"), NotifChannel.REMOVE.getId(), "", "addressUsePro", params.getMessagePriority()) : (addressId == BuiltInNotifAddress.BASIC_SILVERMAIL.getId() ? new NotifAddressRow(addressId, aUserId, this.multilang.getString("defaultAddressSILVERMAIL"), NotifChannel.SILVERMAIL.getId(), aUserId, "addressUsePro", params.getMessagePriority()) : (addressId == BuiltInNotifAddress.BASIC_SMTP.getId() ? new NotifAddressRow(addressId, aUserId, this.multilang.getString("defaultAddressSPMAIL"), NotifChannel.SMTP.getId(), this.getUserEmail(aUserId), "addressUsePro", params.getMessagePriority()) : (addressId == BuiltInNotifAddress.BASIC_SERVER.getId() ? new NotifAddressRow(addressId, aUserId, this.multilang.getString("defaultAddressSERVER"), NotifChannel.SERVER.getId(), aUserId, "addressUsePro", params.getMessagePriority()) : this.schema.notifAddress().getNotifAddress(addressId)))));
        return nar;
    }

    private List<NotifAddressRow> getAllNotifAddressRow(NotificationParameters params, String aUserId) throws SQLException {
        NotifDefaultAddressTable ndat;
        NotifDefaultAddressRow[] ndars;
        int addressId = this.getAddressId(params, aUserId);
        Stream<Integer> addressIdStream = addressId == BuiltInNotifAddress.DEFAULT.getId() ? ((ndars = (ndat = this.schema.notifDefaultAddress()).getAllByUserId(Integer.parseInt(aUserId))).length > 0 ? Stream.of(ndars).map(NotifDefaultAddressRow::getNotifAddressId) : this.getDefaultNotificationChannels().stream().map(NotifChannel::getMediaType).map(BuiltInNotifAddress::getId)) : Stream.of(Integer.valueOf(addressId));
        try {
            return addressIdStream.map(m -> {
                try {
                    return this.getNotifAddressRow(params, aUserId, (int)m);
                }
                catch (SQLException e) {
                    throw new SilverpeasRuntimeException((Throwable)e);
                }
            }).collect(Collectors.toList());
        }
        catch (SilverpeasRuntimeException e) {
            throw (SQLException)e.getCause();
        }
    }

    private int getAddressId(NotificationParameters params, String aUserId) throws SQLException {
        int addressId = params.getAddressId();
        if (params.isAddressDefinedByComponent()) {
            NotifPreferenceRow npr;
            addressId = BuiltInNotifAddress.DEFAULT.getId();
            if (params.isComponentInstanceDefined() && (npr = this.schema.notifPreference().getByUserIdAndComponentInstanceIdAndMessageType(Integer.parseInt(aUserId), params.getComponentInstance(), params.getMessagePriority())) != null) {
                addressId = npr.getNotifAddressId();
            }
        }
        return addressId;
    }

    private NotificationData createNotificationData(NotificationParameters params, String aUserId) throws SQLException, NotificationException {
        StringBuilder theMessage = new StringBuilder(100);
        HashMap<String, Object> theExtraParams = new HashMap<String, Object>();
        NotifAddressRow nar = this.getNotifAddressRow(params, aUserId);
        NotifChannelRow ncr = this.schema.notifChannel().getNotifChannel(nar.getNotifChannelId());
        NotificationData nd = new NotificationData();
        nd.setTargetChannel(ncr.getName());
        nd.setTargetReceipt(nar.getAddress());
        this.setSubject(params, theMessage, theExtraParams, ncr);
        String senderName = this.getSenderName(params);
        this.setSenderAddress(params, theMessage, theExtraParams, ncr, nd, senderName);
        theExtraParams.put(NotificationParameterNames.SERVER_BASEURL.toString(), this.getUserAutoRedirectServerURL(aUserId));
        theExtraParams.put(NotificationParameterNames.SERVERURL.toString(), this.getUserAutoRedirectSilverpeasServerURL(aUserId));
        String url = params.getLink().getLinkUrl();
        if (StringUtil.isDefined((String)url)) {
            theExtraParams.put(NotificationParameterNames.URL.toString(), url.startsWith("http") ? url : this.getUserAutoRedirectURL(aUserId, url));
        }
        this.setSource(params, theExtraParams, null);
        return this.setCommonNotifData(params, theExtraParams, theMessage, senderName, nd);
    }

    private void setSubject(NotificationParameters params, StringBuilder theMessage, Map<String, Object> theExtraParams, NotifChannelRow ncr) {
        if ("Y".equalsIgnoreCase(ncr.getSubjectAvailable())) {
            theExtraParams.put(NotificationParameterNames.SUBJECT.toString(), params.getTitle());
        } else if (!params.isFromUserIdDefined()) {
            theMessage.append(this.multilang.getString("subject")).append(" : ").append(params.getTitle()).append(HTML_BREAK_LINES);
        }
    }

    private void setSenderAddress(NotificationParameters params, StringBuilder theMessage, Map<String, Object> theExtraParams, NotifChannelRow ncr, NotificationData nd, String senderName) {
        if (FROM_UID.equalsIgnoreCase(ncr.getFromAvailable())) {
            theExtraParams.put(NotificationParameterNames.FROM.toString(), Integer.toString(params.getFromUserId()));
            nd.setSenderId(Integer.toString(params.getFromUserId()));
        } else if (FROM_EMAIL.equalsIgnoreCase(ncr.getFromAvailable())) {
            this.setSenderEmail(params, theExtraParams, senderName);
        } else if (FROM_NAME.equalsIgnoreCase(ncr.getFromAvailable())) {
            theExtraParams.put(NotificationParameterNames.FROM.toString(), senderName);
        } else {
            theMessage.append(this.multilang.getString("from")).append(" : ").append(senderName).append(HTML_BREAK_LINES);
        }
    }

    private NotificationData createExternalNotificationData(NotificationParameters params, String email) throws SQLException {
        StringBuilder theMessage = new StringBuilder(100);
        HashMap<String, Object> theExtraParams = new HashMap<String, Object>();
        NotifAddressRow nar = new NotifAddressRow(BuiltInNotifAddress.BASIC_SMTP.getId(), "-1", this.multilang.getString("defaultAddressSPMAIL"), NotifChannel.SMTP.getId(), email, "addressUsePro", params.getMessagePriority());
        NotifChannelRow ncr = this.schema.notifChannel().getNotifChannel(nar.getNotifChannelId());
        NotificationData nd = new NotificationData();
        nd.setTargetChannel(ncr.getName());
        nd.setTargetReceipt(nar.getAddress());
        this.setSubject(params, theMessage, theExtraParams, ncr);
        String senderName = this.getSenderName(params);
        this.setSenderEmail(params, theExtraParams, senderName);
        theExtraParams.put(NotificationParameterNames.SERVER_BASEURL.toString(), URLUtil.getCurrentServerURL());
        theExtraParams.put(NotificationParameterNames.SERVERURL.toString(), URLUtil.getAbsoluteApplicationURL());
        if (StringUtil.isDefined((String)params.getLink().getLinkUrl())) {
            theExtraParams.put(NotificationParameterNames.URL.toString(), params.getLink().getLinkUrl());
            theExtraParams.put(NotificationParameterNames.LINKLABEL.toString(), params.getLink().getLinkLabel());
        }
        this.setSource(params, theExtraParams, null);
        return this.setCommonNotifData(params, theExtraParams, theMessage, senderName, nd);
    }

    @Nonnull
    private NotificationData setCommonNotifData(NotificationParameters params, Map<String, Object> theExtraParams, StringBuilder theMessage, String senderName, NotificationData nd) {
        if (StringUtil.isDefined((String)params.getSessionId())) {
            theExtraParams.put(NotificationParameterNames.SESSIONID.toString(), params.getSessionId());
        }
        if (params.getDate() != null) {
            theExtraParams.put(NotificationParameterNames.DATE.toString(), params.getDate());
        }
        if (params.getLanguage() != null) {
            theExtraParams.put(NotificationParameterNames.LANGUAGE.toString(), params.getLanguage());
        }
        nd.setSenderName(senderName);
        if (!theExtraParams.isEmpty()) {
            nd.setTargetParam(theExtraParams);
        }
        theMessage.append(params.getMessage());
        nd.setMessage(theMessage.toString());
        nd.setAnswerAllowed(params.isAnswerAllowed());
        return nd;
    }

    private void setSource(NotificationParameters params, Map<String, Object> theExtraParams, DelayedNotificationData delayedNotificationData) {
        if (StringUtil.isDefined((String)params.getSource())) {
            theExtraParams.put(NotificationParameterNames.SOURCE.toString(), params.getSource());
        } else if (params.isComponentInstanceDefined()) {
            String instanceId = String.valueOf(params.getComponentInstance());
            try {
                String source = this.computeDefaultSource(instanceId);
                theExtraParams.put(NotificationParameterNames.SOURCE.toString(), source);
                if (delayedNotificationData != null && delayedNotificationData.getResource() != null && StringUtils.isBlank((CharSequence)delayedNotificationData.getResource().getResourceLocation())) {
                    String resourceLocation = this.getComponentFullName(instanceId, "@#@#@", true);
                    delayedNotificationData.getResource().setResourceLocation(resourceLocation);
                }
            }
            catch (Exception e) {
                SilverLogger.getLogger((Object)this).warn((Throwable)e);
            }
        }
    }

    private void setSenderEmail(NotificationParameters params, Map<String, Object> theExtraParams, String senderName) {
        String fromEmail = null;
        if (!EmailAddress.isValid((String)senderName) && params.getFromUserId() >= 0) {
            fromEmail = this.getUserEmail(String.valueOf(params.getFromUserId()));
        }
        if (StringUtil.isNotDefined(fromEmail)) {
            fromEmail = AdministrationServiceProvider.getAdminService().getSilverpeasEmail();
        }
        theExtraParams.put(NotificationParameterNames.FROM.toString(), fromEmail);
    }

    private List<DelayedNotificationData> createAllDelayedNotificationData(NotificationParameters params, String aUserId) throws SQLException {
        List<NotifAddressRow> nars = this.getAllNotifAddressRow(params, aUserId);
        ArrayList<DelayedNotificationData> dnds = new ArrayList<DelayedNotificationData>(nars.size());
        for (NotifAddressRow curAddresseRow : nars) {
            NotifChannelRow notifChannelRow = this.schema.notifChannel().getNotifChannel(curAddresseRow.getNotifChannelId());
            NotificationData notificationData = new NotificationData();
            notificationData.setTargetChannel(notifChannelRow.getName());
            notificationData.setTargetReceipt(curAddresseRow.getAddress());
            DelayedNotificationData delayedNotificationData = this.initDelayedNotificationData(aUserId, params, notificationData, curAddresseRow);
            dnds.add(delayedNotificationData);
            StringBuilder theMessage = new StringBuilder(100);
            HashMap<String, Object> theExtraParams = new HashMap<String, Object>();
            this.setSubject(params, theMessage, theExtraParams, notifChannelRow);
            String senderName = this.getSenderName(params);
            this.setSenderAddress(params, theMessage, theExtraParams, notifChannelRow, notificationData, senderName);
            theExtraParams.put(NotificationParameterNames.SERVER_BASEURL.toString(), this.getUserAutoRedirectServerURL(aUserId));
            theExtraParams.put(NotificationParameterNames.SERVERURL.toString(), this.getUserAutoRedirectSilverpeasServerURL(aUserId));
            if (StringUtil.isDefined((String)params.getLink().getLinkUrl())) {
                theExtraParams.put(NotificationParameterNames.URL.toString(), this.computeURL(aUserId, params.getLink().getLinkUrl()));
                theExtraParams.put(NotificationParameterNames.LINKLABEL.toString(), params.getLink().getLinkLabel());
            }
            if (params.getNotificationResourceData() != null && StringUtil.isDefined((String)params.getNotificationResourceData().getAttachmentTargetId())) {
                theExtraParams.put(NotificationParameterNames.ATTACHMENT_TARGETID.toString(), params.getNotificationResourceData().getAttachmentTargetId());
                theExtraParams.put(NotificationParameterNames.COMPONENTID.toString(), params.getNotificationResourceData().getComponentInstanceId());
            }
            this.setSource(params, theExtraParams, delayedNotificationData);
            this.setCommonNotifData(params, theExtraParams, theMessage, senderName, notificationData);
        }
        return dnds;
    }

    @Nonnull
    private DelayedNotificationData initDelayedNotificationData(String aUserId, NotificationParameters params, NotificationData notificationData, NotifAddressRow curAddresseRow) {
        DelayedNotificationData delayedNotificationData = new DelayedNotificationData();
        delayedNotificationData.setUserId(aUserId);
        delayedNotificationData.setAction(params.getAction());
        delayedNotificationData.setChannel((NotifChannel)NotifChannel.decode((Integer)curAddresseRow.getNotifChannelId()).orElseThrow(() -> new DecodingException("No such channel id: " + curAddresseRow.getNotifChannelId())));
        delayedNotificationData.setCreationDate(params.getDate());
        delayedNotificationData.setFromUserId(Integer.valueOf(params.getFromUserId()));
        delayedNotificationData.setLanguage(params.getLanguage());
        delayedNotificationData.setMessage(params.getOriginalExtraMessage());
        delayedNotificationData.setResource(params.getNotificationResourceData());
        delayedNotificationData.setSendImmediately(params.isSendImmediately());
        delayedNotificationData.setNotificationData(notificationData);
        delayedNotificationData.setNotificationParameters(params);
        return delayedNotificationData;
    }

    private String getSenderName(NotificationParameters params) {
        String senderName = params.isFromUserIdDefined() ? this.getUserFullName(params.getFromUserId()) : params.getSenderName();
        return senderName;
    }

    private boolean isDefaultNotifAddress(int addressId, String aUserId, boolean isMultiChannelNotification) throws SQLException {
        boolean valret;
        NotifDefaultAddressTable ndat = this.schema.notifDefaultAddress();
        NotifDefaultAddressRow[] ndars = ndat.getAllByUserId(Integer.parseInt(aUserId));
        if (ndars.length > 0) {
            valret = this.isDefaultNotifAddress(addressId, isMultiChannelNotification, ndars);
        } else {
            List<NotifChannel> channels = this.getDefaultNotificationChannels();
            valret = channels.stream().map(NotifChannel::getMediaType).anyMatch(m -> m.getId() == addressId);
        }
        return valret;
    }

    private boolean isDefaultNotifAddress(int addressId, boolean isMultiChannelNotification, NotifDefaultAddressRow[] ndars) {
        boolean valret = !isMultiChannelNotification ? addressId == ndars[0].getNotifAddressId() : Stream.of(ndars).anyMatch(ndar -> addressId == ndar.getNotifAddressId());
        return valret;
    }

    private String getSureString(String s) {
        if (s != null) {
            return s;
        }
        return "";
    }

    public boolean isMultiChannelNotification() {
        return NotificationManagerSettings.isMultiChannelNotificationEnabled();
    }

    protected List<NotifChannel> getDefaultNotificationChannels() {
        return NotificationManagerSettings.getDefaultChannels();
    }
}

