/*
 * Decompiled with CFR 0.152.
 */
package org.silverpeas.core.mail.engine;

import java.util.concurrent.Semaphore;
import org.silverpeas.core.annotation.Bean;
import org.silverpeas.core.mail.MailToSend;
import org.silverpeas.core.mail.engine.MailSender;
import org.silverpeas.core.thread.task.AbstractRequestTask;
import org.silverpeas.core.thread.task.RequestTaskManager;
import org.silverpeas.kernel.logging.SilverLogger;

@Bean
public class MailSenderTask
extends AbstractRequestTask<MailProcessContext> {
    private static final Semaphore orderedOneByOneSemaphore = new Semaphore(1, true);

    public static void addMailToSend(MailToSend mailToSend) {
        MailToSendRequest mailToSendRequest = new MailToSendRequest(mailToSend);
        if (mailToSend.isAsynchronous()) {
            RequestTaskManager.get().push(MailSenderTask.class, (AbstractRequestTask.Request)mailToSendRequest);
        } else {
            try {
                mailToSendRequest.process(new MailProcessContext(orderedOneByOneSemaphore));
            }
            catch (InterruptedException e) {
                SilverLogger.getLogger(MailSenderTask.class).error(e.getLocalizedMessage(), (Throwable)e);
                Thread.currentThread().interrupt();
            }
        }
    }

    protected MailProcessContext getProcessContext() {
        return new MailProcessContext(orderedOneByOneSemaphore);
    }

    static class MailToSendRequest
    implements AbstractRequestTask.Request<MailProcessContext> {
        private final MailToSend mailToSend;

        MailToSendRequest(MailToSend mailToSend) {
            this.mailToSend = mailToSend;
        }

        public void process(MailProcessContext context) throws InterruptedException {
            try {
                context.getSemaphore().acquire();
                MailSender.get().send(this.mailToSend);
            }
            finally {
                context.getSemaphore().release();
            }
        }
    }

    static class MailProcessContext
    implements AbstractRequestTask.ProcessContext {
        private final Semaphore semaphore;

        MailProcessContext(Semaphore semaphore) {
            this.semaphore = semaphore;
        }

        Semaphore getSemaphore() {
            return this.semaphore;
        }
    }
}

