/*
 * Decompiled with CFR 0.152.
 */
package org.silverpeas.core.io.upload;

import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import org.apache.commons.fileupload.disk.DiskFileItem;
import org.apache.commons.io.IOUtils;
import org.silverpeas.core.io.upload.UploadedFile;
import org.silverpeas.core.util.file.FileUtil;

public class UploadedFileItem
extends DiskFileItem {
    private UploadedFile uploadedFile;

    UploadedFileItem(UploadedFile uploadedFile) {
        super("", "", false, "", 0, null);
        this.uploadedFile = uploadedFile;
    }

    public String getName() {
        return this.uploadedFile.getFile().getName();
    }

    public long getSize() {
        return this.uploadedFile.getFile().length();
    }

    public String getContentType() {
        return FileUtil.getMimeType(this.getName());
    }

    public byte[] get() {
        byte[] fileData = new byte[(int)this.getSize()];
        try (FileInputStream fis = new FileInputStream(this.uploadedFile.getFile());){
            IOUtils.readFully((InputStream)fis, (byte[])fileData);
        }
        catch (IOException e) {
            fileData = null;
        }
        return fileData;
    }

    public InputStream getInputStream() throws IOException {
        return new FileInputStream(this.uploadedFile.getFile());
    }

    public OutputStream getOutputStream() throws IOException {
        return new FileOutputStream(this.uploadedFile.getFile());
    }
}

