/*
 * Decompiled with CFR 0.152.
 */
package org.silverpeas.core.datereminder;

import java.util.Calendar;
import java.util.Collection;
import java.util.Date;
import java.util.Locale;
import org.silverpeas.core.annotation.Service;
import org.silverpeas.core.cache.service.CacheAccessorProvider;
import org.silverpeas.core.datereminder.exception.DateReminderException;
import org.silverpeas.core.datereminder.persistence.DateReminderDetail;
import org.silverpeas.core.datereminder.persistence.PersistentResourceDateReminder;
import org.silverpeas.core.datereminder.persistence.service.DateReminderServiceProvider;
import org.silverpeas.core.datereminder.provider.DateReminderProcess;
import org.silverpeas.core.datereminder.provider.DateReminderProcessRegistration;
import org.silverpeas.core.initialization.Initialization;
import org.silverpeas.core.notification.NotificationException;
import org.silverpeas.core.persistence.EntityReference;
import org.silverpeas.core.persistence.datasource.OperationContext;
import org.silverpeas.core.scheduler.Scheduler;
import org.silverpeas.core.scheduler.SchedulerEvent;
import org.silverpeas.core.scheduler.SchedulerEventListener;
import org.silverpeas.core.scheduler.SchedulerProvider;
import org.silverpeas.core.scheduler.trigger.JobTrigger;
import org.silverpeas.kernel.SilverpeasException;
import org.silverpeas.kernel.bundle.ResourceLocator;
import org.silverpeas.kernel.bundle.SettingBundle;
import org.silverpeas.kernel.logging.SilverLogger;

@Service
public class DateReminderScheduler
implements SchedulerEventListener,
Initialization {
    public static final String DATEREMINDER_JOB_NAME_PROCESS = "A_ProcessDateReminder";

    public void init() {
        try {
            SettingBundle settings = ResourceLocator.getSettingBundle((String)"org.silverpeas.dateReminder.settings.dateReminderSettings");
            String cron = settings.getString("cronScheduledDateReminder");
            SilverLogger.getLogger((Object)this).debug("Date reminder Processor scheduled with cron ''{0}''", new Object[]{cron});
            Scheduler scheduler = SchedulerProvider.getVolatileScheduler();
            scheduler.unscheduleJob(DATEREMINDER_JOB_NAME_PROCESS);
            JobTrigger trigger = JobTrigger.triggerAt((String)cron);
            scheduler.scheduleJob(DATEREMINDER_JOB_NAME_PROCESS, trigger, (SchedulerEventListener)this);
        }
        catch (Exception e) {
            SilverLogger.getLogger((Object)this).error("Cannot schedule date reminder", (Throwable)e);
        }
    }

    public void doScheduledDateReminder() throws DateReminderException {
        CacheAccessorProvider.getThreadCacheAccessor().getCache().clear();
        Calendar calendar = Calendar.getInstance(Locale.FRENCH);
        calendar.set(11, 0);
        calendar.set(12, 0);
        calendar.set(13, 0);
        calendar.set(14, 0);
        Date deadLine = calendar.getTime();
        Collection<PersistentResourceDateReminder> listResourceDateReminder = DateReminderServiceProvider.getDateReminderService().listAllDateReminderMaturing(deadLine);
        EntityReference entityReference = null;
        for (PersistentResourceDateReminder resourceDateReminder : listResourceDateReminder) {
            for (DateReminderProcess dateReminderProcess : DateReminderProcessRegistration.getProcesses(resourceDateReminder)) {
                boolean performed;
                try {
                    entityReference = dateReminderProcess.perform(resourceDateReminder);
                    performed = true;
                }
                catch (NotificationException e) {
                    SilverLogger.getLogger((Object)this).error("Date reminder failure for type = {0}, resource = {1}", (Object[])new String[]{resourceDateReminder.getResourceType(), resourceDateReminder.getId()}, (Throwable)e);
                    performed = false;
                }
                if (!performed) continue;
                OperationContext.getFromCache().withUser(resourceDateReminder.getLastUpdater());
                DateReminderDetail dateReminderDetail = resourceDateReminder.getDateReminder();
                dateReminderDetail.setProcessStatus(1);
                DateReminderServiceProvider.getDateReminderService().set(entityReference, dateReminderDetail);
            }
        }
    }

    public void triggerFired(SchedulerEvent anEvent) throws SilverpeasException {
        this.doScheduledDateReminder();
    }

    public void jobSucceeded(SchedulerEvent anEvent) {
    }

    public void jobFailed(SchedulerEvent anEvent) {
        SilverLogger.getLogger((Object)this).error("The job {0} failed", new Object[]{anEvent.getJobExecutionContext().getJobName()});
    }
}

