/*
 * Decompiled with CFR 0.152.
 */
package org.silverpeas.core.contribution.model;

import java.io.Serializable;
import java.util.Date;
import javax.persistence.Column;
import javax.persistence.Embeddable;
import javax.persistence.Temporal;
import javax.persistence.TemporalType;
import javax.persistence.Transient;
import org.silverpeas.core.admin.user.model.User;
import org.silverpeas.core.contribution.ContributionStatus;
import org.silverpeas.kernel.util.StringUtil;

@Embeddable
public class ContributionValidation
implements Serializable {
    private static final long serialVersionUID = 6313266204966304781L;
    @Column(name="status", nullable=false)
    private String status = ContributionStatus.DRAFT.name();
    @Column(name="validationDate")
    @Temporal(value=TemporalType.TIMESTAMP)
    private Date validationDate;
    @Column(name="validationComment")
    private String validationComment;
    @Column(name="validationBy", length=40)
    private String validationBy;
    @Transient
    private User validator;

    public boolean isInDraft() {
        return this.getStatus().isInDraft();
    }

    public boolean isRefused() {
        return this.getStatus().isRefused();
    }

    public boolean isPendingValidation() {
        return this.getStatus().isPendingValidation();
    }

    public boolean isValidated() {
        return this.getStatus().isValidated();
    }

    public ContributionStatus getStatus() {
        return ContributionStatus.from(this.status);
    }

    public void setStatus(ContributionStatus status) {
        this.status = status.name();
    }

    public Date getDate() {
        return this.validationDate;
    }

    public void setDate(Date validationDate) {
        this.validationDate = validationDate;
    }

    public String getComment() {
        return this.validationComment;
    }

    public void setComment(String validationComment) {
        this.validationComment = validationComment;
    }

    public User getValidator() {
        if (StringUtil.isDefined((String)this.validationBy)) {
            if (this.validator == null || !this.validationBy.equals(this.validator.getId())) {
                this.validator = User.getById((String)this.validationBy);
            }
        } else {
            this.validator = null;
        }
        return this.validator;
    }

    public void setValidationBy(String validatedBy) {
        this.validator = null;
        this.validationBy = validatedBy;
    }

    public void setValidator(User validator) {
        this.validator = validator;
        this.validationBy = validator != null ? validator.getId() : null;
    }

    public String toString() {
        return "ContributionValidation{status=" + this.status + ", validationDate=" + this.validationDate + ", validationComment=" + this.validationComment + ", validationBy=" + this.validationBy + "}";
    }

    public ContributionValidation() {
    }

    public ContributionValidation(ContributionStatus status, User validator, Date validationDate) {
        this.setStatus(status);
        this.validationBy = validator.getId();
        this.validator = validator;
        this.validationDate = validationDate;
    }

    public ContributionValidation(ContributionStatus status, User validator, Date validationDate, String comment) {
        this(status, validator, validationDate);
        this.validationComment = comment;
    }
}

