/*
 * Decompiled with CFR 0.152.
 */
package org.silverpeas.core.contribution.content.form.field;

import java.text.ParseException;
import javax.annotation.Nonnull;
import org.silverpeas.core.contribution.content.form.AbstractField;
import org.silverpeas.core.contribution.content.form.Field;
import org.silverpeas.core.contribution.content.form.FormException;
import org.silverpeas.core.util.DateUtil;
import org.silverpeas.kernel.logging.SilverLogger;

public abstract class DateField
extends AbstractField {
    private static final long serialVersionUID = -885405651541562611L;
    public static final String TYPE = "date";

    @Override
    public String getTypeName() {
        return TYPE;
    }

    public abstract boolean isReadOnly();

    @Override
    public String getValue() {
        return this.getStringValue();
    }

    @Override
    public String getValue(String language) {
        return this.formatClient(this.getStringValue(), language);
    }

    @Override
    public void setValue(String value) throws FormException {
        this.setStringValue(value);
    }

    @Override
    public void setValue(String value, String language) throws FormException {
        this.setStringValue(this.formatBD(value, language));
    }

    private String formatClient(String value, String language) {
        if (value != null && !value.isEmpty()) {
            try {
                value = DateUtil.getInputDate((String)value, (String)language);
            }
            catch (ParseException pe) {
                SilverLogger.getLogger((Object)this).error((Throwable)pe);
            }
        }
        return value;
    }

    private String formatBD(String newValue, String language) {
        String dateBD = null;
        try {
            dateBD = DateUtil.date2SQLDate((String)newValue, (String)language);
        }
        catch (ParseException pe) {
            SilverLogger.getLogger((Object)this).error((Throwable)pe);
        }
        return dateBD;
    }

    @Override
    public boolean acceptValue(String value) {
        return !this.isReadOnly();
    }

    @Override
    public boolean acceptValue(String value, String language) {
        return !this.isReadOnly();
    }

    @Override
    public Object getObjectValue() {
        return this.getStringValue();
    }

    @Override
    public void setObjectValue(Object value) throws FormException {
        if (value instanceof String) {
            this.setStringValue((String)value);
        } else {
            if (value != null) {
                throw new FormException("The value " + value + " isn't a string!", new String[0]);
            }
            this.setNull();
        }
    }

    @Override
    public boolean acceptObjectValue(Object value) {
        return value instanceof String && !this.isReadOnly();
    }

    @Override
    public boolean isNull() {
        return this.getStringValue() == null || this.getStringValue().trim().isEmpty();
    }

    @Override
    public void setNull() throws FormException {
        this.setStringValue(null);
    }

    public boolean equals(Object o) {
        String s = this.getStringValue();
        if (s == null) {
            s = "";
        }
        if (o instanceof DateField) {
            String t = ((DateField)o).getStringValue();
            if (t == null) {
                t = "";
            }
            return s.equals(t);
        }
        return false;
    }

    @Override
    public int compareTo(@Nonnull Field o) {
        String s = this.getStringValue();
        if (s == null) {
            s = "";
        }
        if (o instanceof DateField) {
            String t = o.getStringValue();
            if (t == null) {
                t = "";
            }
            return s.compareTo(t);
        }
        return -1;
    }

    public int hashCode() {
        String s = this.getStringValue();
        return s.hashCode();
    }
}

