/*
 * Decompiled with CFR 0.152.
 */
package org.silverpeas.core.calendar.notification;

import java.util.Collections;
import org.silverpeas.core.admin.user.model.User;
import org.silverpeas.core.annotation.Service;
import org.silverpeas.core.calendar.Attendee;
import org.silverpeas.core.calendar.CalendarEvent;
import org.silverpeas.core.calendar.CalendarEventOccurrence;
import org.silverpeas.core.calendar.PlannedOnCalendar;
import org.silverpeas.core.calendar.notification.AbstractNotifier;
import org.silverpeas.core.calendar.notification.AttendeeLifeCycleEvent;
import org.silverpeas.core.calendar.notification.AttendeeNotificationBuilder;
import org.silverpeas.core.calendar.notification.CalendarOperation;
import org.silverpeas.core.calendar.notification.LifeCycleEventSubType;
import org.silverpeas.core.notification.user.UserNotification;
import org.silverpeas.core.notification.user.client.constant.NotifAction;

@Service
public class CalendarComponentNotifier
extends AbstractNotifier<AttendeeLifeCycleEvent> {
    public void onDeletion(AttendeeLifeCycleEvent event) {
        Attendee attendee = (Attendee)event.getTransition().getBefore();
        CalendarOperation operation = event.getSubType() == LifeCycleEventSubType.SINGLE ? CalendarOperation.ATTENDEE_REMOVING : CalendarOperation.SINCE_ATTENDEE_REMOVING;
        UserNotification notification = new AttendeeNotificationBuilder(event.getPlannedObject(), NotifAction.UPDATE).immediately().from(User.getCurrentRequester()).to(attendee).about(operation, attendee).build();
        notification.send();
    }

    public void onUpdate(AttendeeLifeCycleEvent event) {
        Attendee before = (Attendee)event.getTransition().getBefore();
        Attendee after = (Attendee)event.getTransition().getAfter();
        if (before.getPresenceStatus() != after.getPresenceStatus()) {
            CalendarOperation operation = event.getSubType() == LifeCycleEventSubType.SINGLE ? CalendarOperation.ATTENDEE_PRESENCE : CalendarOperation.SINCE_ATTENDEE_PRESENCE;
            UserNotification notification = new AttendeeNotificationBuilder(event.getPlannedObject(), NotifAction.UPDATE).immediately().from(User.getCurrentRequester()).to(after).about(operation, after).build();
            notification.send();
        } else if (before.getParticipationStatus() != after.getParticipationStatus()) {
            if (after.getParticipationStatus() == Attendee.ParticipationStatus.AWAITING) {
                PlannedOnCalendar modified = event.getPlannedObject();
                boolean isRecurrent = this.isRecurrent(modified);
                CalendarOperation operation = isRecurrent ? CalendarOperation.SINCE_ATTENDEE_ADDING : CalendarOperation.ATTENDEE_ADDING;
                UserNotification notification = new AttendeeNotificationBuilder(modified, NotifAction.CREATE).immediately().from(User.getCurrentRequester()).to(Collections.singletonList(after)).about(operation, after).build();
                notification.send();
            } else {
                CalendarOperation operation = event.getSubType() == LifeCycleEventSubType.SINGLE ? CalendarOperation.ATTENDEE_PARTICIPATION : CalendarOperation.SINCE_ATTENDEE_PARTICIPATION;
                UserNotification notification = new AttendeeNotificationBuilder(event.getPlannedObject(), NotifAction.UPDATE).immediately().from(User.getCurrentRequester()).to(this.ownerOf(after.getCalendarComponent())).about(operation, after).build();
                notification.send();
            }
        }
    }

    public void onCreation(AttendeeLifeCycleEvent event) {
        Attendee attendee = (Attendee)event.getTransition().getAfter();
        CalendarOperation operation = event.getSubType() == LifeCycleEventSubType.SINGLE ? CalendarOperation.ATTENDEE_ADDING : CalendarOperation.SINCE_ATTENDEE_ADDING;
        UserNotification notification = new AttendeeNotificationBuilder(event.getPlannedObject(), NotifAction.UPDATE).immediately().from(User.getCurrentRequester()).to(attendee).about(operation, attendee).build();
        notification.send();
    }

    private boolean isRecurrent(PlannedOnCalendar planned) {
        return planned instanceof CalendarEventOccurrence || ((CalendarEvent)planned).isRecurrent();
    }
}

